/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkbox.bootstraptoggle.BootstrapToggle;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkbox.bootstraptoggle.BootstrapToggleConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleApplication;
import org.apache.syncope.client.console.panels.search.AnySelectionDirectoryPanel;
import org.apache.syncope.client.console.panels.search.GroupSearchPanel;
import org.apache.syncope.client.console.panels.search.GroupSelectionDirectoryPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchClausePanel;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.panels.search.UserSearchPanel;
import org.apache.syncope.client.console.panels.search.UserSelectionDirectoryPanel;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wizards.any.GroupWrapper;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.ActionPermissions;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;

public class Ownership
extends WizardStep
implements WizardModel.ICondition {
    private static final long serialVersionUID = 855618618337931784L;
    private final Pattern owner = Pattern.compile("\\[\\(\\d+\\)\\] .*");
    private final GroupWrapper wrapper;
    private final WebMarkupContainer ownerContainer;
    private final AnyTypeRestClient anyTypeRestClient = new AnyTypeRestClient();
    private final AnyTypeClassRestClient anyTypeClassRestClient = new AnyTypeClassRestClient();
    private final GroupSearchPanel groupSearchPanel;
    private final GroupRestClient groupRestClient = new GroupRestClient();
    private final Fragment groupSearchFragment;
    private final GroupSelectionDirectoryPanel groupDirectoryPanel;
    private final UserSearchPanel userSearchPanel;
    private final UserRestClient userRestClient = new UserRestClient();
    private final Fragment userSearchFragment;
    private final UserSelectionDirectoryPanel userDirectoryPanel;
    private final Model<Boolean> isGroupOwnership;

    public Ownership(final GroupWrapper groupWrapper, PageReference pageRef) {
        ActionPermissions permissions = new ActionPermissions();
        this.setMetaData(MetaDataRoleAuthorizationStrategy.ACTION_PERMISSIONS, (Serializable)permissions);
        permissions.authorize(RENDER, new Roles("USER_SEARCH"));
        this.setTitleModel((IModel)new ResourceModel("group.ownership"));
        this.wrapper = groupWrapper;
        this.isGroupOwnership = Model.of((Serializable)Boolean.valueOf(((GroupTO)groupWrapper.getInnerObject()).getGroupOwner() != null));
        BootstrapToggleConfig config = new BootstrapToggleConfig().withOnStyle(BootstrapToggleConfig.Style.info).withOffStyle(BootstrapToggleConfig.Style.warning).withSize(BootstrapToggleConfig.Size.mini);
        this.add(new Component[]{new BootstrapToggle("ownership", (IModel)new Model<Boolean>(){
            private static final long serialVersionUID = 6062041315055645807L;

            public Boolean getObject() {
                return (Boolean)Ownership.this.isGroupOwnership.getObject();
            }
        }, config){
            private static final long serialVersionUID = 2969634208049189343L;

            protected IModel<String> getOffLabel() {
                return Model.of((Serializable)((Object)"USER Owner"));
            }

            protected IModel<String> getOnLabel() {
                return Model.of((Serializable)((Object)"GROUP Owner"));
            }

            protected CheckBox newCheckBox(String id, IModel<Boolean> model) {
                CheckBox checkBox = super.newCheckBox(id, model);
                checkBox.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                    private static final long serialVersionUID = 18235445704320L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        Ownership.this.isGroupOwnership.setObject((Serializable)Boolean.valueOf((Boolean)Ownership.this.isGroupOwnership.getObject() == false));
                        if (((Boolean)Ownership.this.isGroupOwnership.getObject()).booleanValue()) {
                            Ownership.this.ownerContainer.addOrReplace(new Component[]{Ownership.this.groupSearchFragment});
                            Ownership.this.groupDirectoryPanel.search(null, target);
                        } else {
                            Ownership.this.ownerContainer.addOrReplace(new Component[]{Ownership.this.userSearchFragment});
                            Ownership.this.userDirectoryPanel.search(null, target);
                        }
                        target.add(new Component[]{Ownership.this.ownerContainer});
                    }
                }});
                return checkBox;
            }
        }});
        this.ownerContainer = new WebMarkupContainer("ownerContainer");
        this.ownerContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.ownerContainer});
        this.groupSearchFragment = new Fragment("search", "groupSearchFragment", (MarkupContainer)this);
        this.groupSearchPanel = (GroupSearchPanel)((Object)new GroupSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(new ArrayList())).required(false).enableSearch((IEventSink)this).build("groupsearch"));
        this.groupSearchFragment.add(new Component[]{this.groupSearchPanel.setRenderBodyOnly(true)});
        AnyTypeTO anyTypeTO = this.anyTypeRestClient.read(AnyTypeKind.GROUP.name());
        this.groupDirectoryPanel = (GroupSelectionDirectoryPanel)((Object)GroupSelectionDirectoryPanel.class.cast((Object)new GroupSelectionDirectoryPanel.Builder(this.anyTypeClassRestClient.list(anyTypeTO.getClasses()), anyTypeTO.getKey(), pageRef).build("searchResult")));
        this.groupSearchFragment.add(new Component[]{this.groupDirectoryPanel});
        this.userSearchFragment = new Fragment("search", "userSearchFragment", (MarkupContainer)this);
        this.userSearchPanel = (UserSearchPanel)((Object)UserSearchPanel.class.cast(new UserSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(new ArrayList())).required(false).enableSearch((IEventSink)this).build("usersearch")));
        this.userSearchFragment.add(new Component[]{this.userSearchPanel.setRenderBodyOnly(true)});
        anyTypeTO = this.anyTypeRestClient.read(AnyTypeKind.USER.name());
        this.userDirectoryPanel = (UserSelectionDirectoryPanel)((Object)UserSelectionDirectoryPanel.class.cast((Object)new UserSelectionDirectoryPanel.Builder(this.anyTypeClassRestClient.list(anyTypeTO.getClasses()), anyTypeTO.getKey(), pageRef).build("searchResult")));
        this.userSearchFragment.add(new Component[]{this.userDirectoryPanel});
        if (((Boolean)this.isGroupOwnership.getObject()).booleanValue()) {
            this.ownerContainer.add(new Component[]{this.groupSearchFragment});
        } else {
            this.ownerContainer.add(new Component[]{this.userSearchFragment});
        }
        AjaxTextFieldPanel userOwner = new AjaxTextFieldPanel("userOwner", "userOwner", (IModel<String>)new PropertyModel<String>(groupWrapper.getInnerObject(), "userOwner"){
            private static final long serialVersionUID = -3743432456095828573L;

            public String getObject() {
                if (((GroupTO)groupWrapper.getInnerObject()).getUserOwner() == null) {
                    return "";
                }
                UserTO userTO = (UserTO)Ownership.this.userRestClient.read(((GroupTO)groupWrapper.getInnerObject()).getUserOwner());
                if (userTO == null) {
                    return "";
                }
                return String.format("[%s] %s", userTO.getKey(), userTO.getUsername());
            }

            public void setObject(String object) {
                if (StringUtils.isBlank((CharSequence)object)) {
                    ((GroupTO)groupWrapper.getInnerObject()).setUserOwner(null);
                } else {
                    Matcher matcher = Ownership.this.owner.matcher(object);
                    if (matcher.matches()) {
                        ((GroupTO)groupWrapper.getInnerObject()).setUserOwner(matcher.group(1));
                    }
                }
            }
        }, false);
        userOwner.setPlaceholder("userOwner");
        userOwner.hideLabel();
        userOwner.setReadOnly(true).setOutputMarkupId(true);
        this.userSearchFragment.add(new Component[]{userOwner});
        IndicatingAjaxLink<Void> userOwnerReset = new IndicatingAjaxLink<Void>("userOwnerReset"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                this.send((IEventSink)Ownership.this, Broadcast.EXACT, new AnySelectionDirectoryPanel.ItemSelection<Object>(target, null));
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        this.userSearchFragment.add(new Component[]{userOwnerReset});
        AjaxTextFieldPanel groupOwner = new AjaxTextFieldPanel("groupOwner", "groupOwner", (IModel<String>)new PropertyModel<String>(groupWrapper.getInnerObject(), "groupOwner"){
            private static final long serialVersionUID = -3743432456095828573L;

            public String getObject() {
                if (((GroupTO)groupWrapper.getInnerObject()).getGroupOwner() == null) {
                    return "";
                }
                GroupTO groupTO = (GroupTO)Ownership.this.groupRestClient.read(((GroupTO)groupWrapper.getInnerObject()).getGroupOwner());
                if (groupTO == null) {
                    return "";
                }
                return String.format("[%s] %s", groupTO.getKey(), groupTO.getName());
            }

            public void setObject(String object) {
                if (StringUtils.isBlank((CharSequence)object)) {
                    ((GroupTO)groupWrapper.getInnerObject()).setGroupOwner(null);
                } else {
                    Matcher matcher = Ownership.this.owner.matcher(object);
                    if (matcher.matches()) {
                        ((GroupTO)groupWrapper.getInnerObject()).setGroupOwner(matcher.group(1));
                    }
                }
            }
        }, false);
        groupOwner.setPlaceholder("groupOwner");
        groupOwner.hideLabel();
        groupOwner.setReadOnly(true).setOutputMarkupId(true);
        this.groupSearchFragment.add(new Component[]{groupOwner});
        IndicatingAjaxLink<Void> groupOwnerReset = new IndicatingAjaxLink<Void>("groupOwnerReset"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                this.send((IEventSink)Ownership.this, Broadcast.EXACT, new AnySelectionDirectoryPanel.ItemSelection<Object>(target, null));
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        this.groupSearchFragment.add(new Component[]{groupOwnerReset});
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof SearchClausePanel.SearchEvent) {
            AjaxRequestTarget target = ((SearchClausePanel.SearchEvent)SearchClausePanel.SearchEvent.class.cast(event.getPayload())).getTarget();
            if (((Boolean)this.isGroupOwnership.getObject()).booleanValue()) {
                String fiql = SearchUtils.buildFIQL((List)this.groupSearchPanel.getModel().getObject(), SyncopeClient.getGroupSearchConditionBuilder());
                this.groupDirectoryPanel.search(fiql, target);
            } else {
                String fiql = SearchUtils.buildFIQL((List)this.userSearchPanel.getModel().getObject(), SyncopeClient.getUserSearchConditionBuilder());
                this.userDirectoryPanel.search(fiql, target);
            }
        } else if (event.getPayload() instanceof AnySelectionDirectoryPanel.ItemSelection) {
            Object sel = ((AnySelectionDirectoryPanel.ItemSelection)event.getPayload()).getSelection();
            if (sel == null) {
                ((GroupTO)this.wrapper.getInnerObject()).setUserOwner(null);
                ((GroupTO)this.wrapper.getInnerObject()).setGroupOwner(null);
            } else if (sel instanceof UserTO) {
                ((GroupTO)this.wrapper.getInnerObject()).setUserOwner(sel.getKey());
                ((GroupTO)this.wrapper.getInnerObject()).setGroupOwner(null);
            } else if (sel instanceof GroupTO) {
                ((GroupTO)this.wrapper.getInnerObject()).setGroupOwner(sel.getKey());
                ((GroupTO)this.wrapper.getInnerObject()).setUserOwner(null);
            }
            ((AnySelectionDirectoryPanel.ItemSelection)event.getPayload()).getTarget().add(new Component[]{this.ownerContainer});
        } else {
            super.onEvent(event);
        }
    }

    public boolean evaluate() {
        return SyncopeConsoleApplication.get().getSecuritySettings().getAuthorizationStrategy().isActionAuthorized((Component)this, RENDER);
    }
}

