/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.panels.search.AbstractSearchPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class GroupSearchPanel
extends AbstractSearchPanel {
    private static final long serialVersionUID = 5757183539269316263L;

    protected GroupSearchPanel(String id, Builder builder) {
        super(id, AnyTypeKind.GROUP, builder);
    }

    @Override
    protected void populate() {
        super.populate();
        this.types = new LoadableDetachableModel<List<SearchClause.Type>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<SearchClause.Type> load() {
                ArrayList<SearchClause.Type> result = new ArrayList<SearchClause.Type>();
                result.add(SearchClause.Type.ATTRIBUTE);
                result.add(SearchClause.Type.RESOURCE);
                result.add(SearchClause.Type.GROUP_MEMBER);
                return result;
            }
        };
        this.groupNames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return Collections.emptyList();
            }
        };
        this.anames = new LoadableDetachableModel<Map<String, PlainSchemaTO>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected Map<String, PlainSchemaTO> load() {
                return GroupSearchPanel.this.schemaRestClient.getSchemas(SchemaType.PLAIN, null, GroupSearchPanel.this.anyTypeRestClient.read(GroupSearchPanel.this.type).getClasses().toArray(new String[0])).stream().collect(Collectors.toMap(schema -> schema.getKey(), Function.identity()));
            }
        };
    }

    public static class Builder
    extends AbstractSearchPanel.Builder<GroupSearchPanel> {
        private static final long serialVersionUID = 6308997285778809578L;

        public Builder(IModel<List<SearchClause>> model) {
            super(model);
        }

        @Override
        public GroupSearchPanel build(String id) {
            return new GroupSearchPanel(id, this);
        }
    }
}

