/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.pages.OIDCClientBeforeLogout;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCClientLogin
extends WebPage {
    private static final long serialVersionUID = 8581614051773949262L;
    private static final Logger LOG = LoggerFactory.getLogger(OIDCClientLogin.class);
    private static final String OIDC_ACCESS_ERROR = "OIDC access error";

    public OIDCClientLogin(PageParameters parameters) {
        super(parameters);
        String token = (String)((ServletWebRequest)this.getRequest()).getContainerRequest().getSession().getAttribute("oidcclient.jwt");
        if (StringUtils.isBlank((CharSequence)token)) {
            LOG.error("No JWT found, redirecting to default greeter");
            PageParameters params = new PageParameters();
            params.add("errorMessage", (Object)OIDC_ACCESS_ERROR);
            this.setResponsePage(this.getApplication().getHomePage(), params);
        }
        IAuthenticationStrategy strategy = this.getApplication().getSecuritySettings().getAuthenticationStrategy();
        if (SyncopeEnduserSession.get().authenticate(token)) {
            if (parameters.get("logoutSupported").toBoolean(false)) {
                SyncopeEnduserSession.get().setAttribute("beforeLogoutPage", OIDCClientBeforeLogout.class);
            }
            this.setResponsePage(this.getApplication().getHomePage());
        } else {
            PageParameters params = new PageParameters();
            params.add("errorMessage", (Object)OIDC_ACCESS_ERROR);
            this.setResponsePage(this.getApplication().getHomePage(), params);
        }
        strategy.remove();
    }
}

