/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.search.SpecialAttr;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.service.AnyObjectService;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.logic.AnyObjectLogic;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.rest.cxf.service.AbstractAnyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AnyObjectServiceImpl
extends AbstractAnyService<AnyObjectTO, AnyObjectPatch>
implements AnyObjectService {
    @Autowired
    private AnyObjectDAO anyObjectDAO;
    @Autowired
    private AnyObjectLogic logic;

    @Override
    protected AnyDAO<?> getAnyDAO() {
        return this.anyObjectDAO;
    }

    @Override
    protected AbstractAnyLogic<AnyObjectTO, AnyObjectPatch> getAnyLogic() {
        return this.logic;
    }

    @Override
    protected AnyObjectPatch newPatch(String key) {
        AnyObjectPatch patch = new AnyObjectPatch();
        patch.setKey(key);
        return patch;
    }

    public Response create(AnyObjectTO anyObjectTO) {
        ProvisioningResult created = this.logic.create(anyObjectTO, this.isNullPriorityAsync());
        return this.createResponse(created);
    }

    public Response update(AnyObjectTO anyObjectTO) {
        anyObjectTO.setKey(this.getActualKey(this.getAnyDAO(), anyObjectTO.getKey()));
        AnyObjectTO before = this.logic.read(anyObjectTO.getKey());
        this.checkETag(before.getETagValue());
        ProvisioningResult updated = this.logic.update(AnyOperations.diff((AnyObjectTO)anyObjectTO, (AnyObjectTO)before, (boolean)false), this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }

    public Response update(AnyObjectPatch anyObjectPatch) {
        return this.doUpdate(anyObjectPatch);
    }

    @Override
    public PagedResult<AnyObjectTO> search(AnyQuery anyQuery) {
        if (StringUtils.isBlank((CharSequence)anyQuery.getFiql()) || -1 == anyQuery.getFiql().indexOf(SpecialAttr.TYPE.toString())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchExpression);
            sce.getElements().add(SpecialAttr.TYPE.toString() + " is required in the FIQL string");
            throw sce;
        }
        return super.search(anyQuery);
    }
}

