/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.provisioning.api.AnyObjectProvisioningManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.workflow.api.AnyObjectWorkflowAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DefaultAnyObjectProvisioningManager
implements AnyObjectProvisioningManager {
    @Autowired
    protected AnyObjectWorkflowAdapter awfAdapter;
    @Autowired
    protected PropagationManager propagationManager;
    @Autowired
    protected PropagationTaskExecutor taskExecutor;
    @Autowired
    protected VirAttrHandler virtAttrHandler;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;

    public Pair<String, List<PropagationStatus>> create(AnyObjectTO anyObjectTO, boolean nullPriorityAsync) {
        return this.create(anyObjectTO, Collections.emptySet(), nullPriorityAsync);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Pair<String, List<PropagationStatus>> create(AnyObjectTO anyObjectTO, Set<String> excludedResources, boolean nullPriorityAsync) {
        WorkflowResult created = this.awfAdapter.create(anyObjectTO);
        List taskInfos = this.propagationManager.getCreateTasks(AnyTypeKind.ANY_OBJECT, (String)created.getResult(), null, created.getPropByRes(), (Collection)anyObjectTO.getVirAttrs(), excludedResources);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync);
        return Pair.of((Object)created.getResult(), (Object)propagationReporter.getStatuses());
    }

    public Pair<AnyObjectPatch, List<PropagationStatus>> update(AnyObjectPatch anyObjectPatch, boolean nullPriorityAsync) {
        return this.update(anyObjectPatch, Collections.emptySet(), nullPriorityAsync);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Pair<AnyObjectPatch, List<PropagationStatus>> update(AnyObjectPatch anyObjectPatch, Set<String> excludedResources, boolean nullPriorityAsync) {
        WorkflowResult updated = this.awfAdapter.update(anyObjectPatch);
        List taskInfos = this.propagationManager.getUpdateTasks(AnyTypeKind.ANY_OBJECT, ((AnyObjectPatch)updated.getResult()).getKey(), false, null, updated.getPropByRes(), null, (Collection)anyObjectPatch.getVirAttrs(), excludedResources);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync);
        return Pair.of((Object)updated.getResult(), (Object)propagationReporter.getStatuses());
    }

    public List<PropagationStatus> delete(String key, boolean nullPriorityAsync) {
        return this.delete(key, Collections.emptySet(), nullPriorityAsync);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<PropagationStatus> delete(String key, Set<String> excludedResources, boolean nullPriorityAsync) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.DELETE, this.anyObjectDAO.findAllResourceKeys(key));
        List taskInfos = this.propagationManager.getDeleteTasks(AnyTypeKind.ANY_OBJECT, key, propByRes, null, excludedResources);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync);
        this.awfAdapter.delete(key);
        return propagationReporter.getStatuses();
    }

    public String unlink(AnyObjectPatch anyObjectPatch) {
        return ((AnyObjectPatch)this.awfAdapter.update(anyObjectPatch).getResult()).getKey();
    }

    public String link(AnyObjectPatch anyObjectPatch) {
        return ((AnyObjectPatch)this.awfAdapter.update(anyObjectPatch).getResult()).getKey();
    }

    public List<PropagationStatus> provision(String key, Collection<String> resources, boolean nullPriorityAsync) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.UPDATE, resources);
        List taskInfos = this.propagationManager.getUpdateTasks(AnyTypeKind.ANY_OBJECT, key, false, null, propByRes, null, null, null);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync);
        return propagationReporter.getStatuses();
    }

    public List<PropagationStatus> deprovision(String key, Collection<String> resources, boolean nullPriorityAsync) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.DELETE, resources);
        List taskInfos = this.propagationManager.getDeleteTasks(AnyTypeKind.ANY_OBJECT, key, propByRes, null, (Collection)this.anyObjectDAO.findAllResourceKeys(key).stream().filter(resource -> !resources.contains(resource)).collect(Collectors.toList()));
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync);
        return propagationReporter.getStatuses();
    }
}

