/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.logger;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.logger.AbstractLoggerCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerDelete
extends AbstractLoggerCommand {
    private static final Logger LOG = LoggerFactory.getLogger(LoggerDelete.class);
    private static final String DELETE_HELP_MESSAGE = "logger --delete {LOG-NAME} {LOG-NAME} [...]";
    private final Input input;

    public LoggerDelete(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.parameterNumber() >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.loggerSyncopeOperations.delete(parameter);
                    this.loggerResultManager.deletedMessage("Logger", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error deleting logger", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.loggerResultManager.notFoundError("Logger", parameter);
                        continue;
                    }
                    this.loggerResultManager.genericError(ex.getMessage());
                }
            }
        } else {
            this.loggerResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

