/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import javax.annotation.Resource;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.entity.Domain;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.DefaultCredentialChecker;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

@Configurable
public class UsernamePasswordAuthenticationProvider
implements AuthenticationProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(UsernamePasswordAuthenticationProvider.class);
    protected static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    @Autowired
    protected AuthDataAccessor dataAccessor;
    @Autowired
    protected UserProvisioningManager provisioningManager;
    @Autowired
    private DefaultCredentialChecker credentialChecker;
    @Resource(name="adminUser")
    protected String adminUser;
    @Resource(name="adminPassword")
    protected String adminPassword;
    @Resource(name="adminPasswordAlgorithm")
    protected String adminPasswordAlgorithm;
    @Resource(name="anonymousUser")
    protected String anonymousUser;
    @Resource(name="anonymousKey")
    protected String anonymousKey;

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public void setAdminPasswordAlgorithm(String adminPasswordAlgorithm) {
        this.adminPasswordAlgorithm = adminPasswordAlgorithm;
    }

    public void setAnonymousKey(String anonymousKey) {
        this.anonymousKey = anonymousKey;
    }

    public Authentication authenticate(Authentication authentication) {
        boolean isAuthenticated;
        Boolean authenticated;
        String domainKey = ((SyncopeAuthenticationDetails)SyncopeAuthenticationDetails.class.cast(authentication.getDetails())).getDomain();
        String[] username = new String[1];
        if (this.anonymousUser.equals(authentication.getName())) {
            username[0] = this.anonymousUser;
            this.credentialChecker.checkIsDefaultAnonymousKeyInUse();
            authenticated = authentication.getCredentials().toString().equals(this.anonymousKey);
        } else if (this.adminUser.equals(authentication.getName())) {
            username[0] = this.adminUser;
            if ("Master".equals(domainKey)) {
                this.credentialChecker.checkIsDefaultAdminPasswordInUse();
                authenticated = ENCRYPTOR.verify(authentication.getCredentials().toString(), CipherAlgorithm.valueOf((String)this.adminPasswordAlgorithm), this.adminPassword);
            } else {
                String domainToFind = domainKey;
                authenticated = AuthContextUtils.execWithAuthContext("Master", () -> {
                    Domain domain = this.dataAccessor.findDomain(domainToFind);
                    return ENCRYPTOR.verify(authentication.getCredentials().toString(), domain.getAdminCipherAlgorithm(), domain.getAdminPwd());
                });
            }
        } else {
            Pair authResult = AuthContextUtils.execWithAuthContext(domainKey, () -> this.dataAccessor.authenticate(authentication));
            authenticated = (Boolean)authResult.getValue();
            if (authResult.getLeft() != null && authResult.getRight() != null) {
                username[0] = ((User)authResult.getLeft()).getUsername();
                if (!((Boolean)authResult.getRight()).booleanValue()) {
                    AuthContextUtils.execWithAuthContext(domainKey, () -> {
                        this.provisioningManager.internalSuspend(((User)authResult.getLeft()).getKey());
                        return null;
                    });
                }
            }
        }
        if (username[0] == null) {
            username[0] = authentication.getPrincipal().toString();
        }
        boolean bl = isAuthenticated = authenticated != null && authenticated != false;
        if (!isAuthenticated) {
            AuthContextUtils.execWithAuthContext(domainKey, () -> {
                this.dataAccessor.audit(AuditElements.EventCategoryType.LOGIC, "Authentication", null, "login", AuditElements.Result.FAILURE, null, isAuthenticated, authentication, "User " + username[0] + " not authenticated");
                return null;
            });
            LOG.debug("User {} not authenticated", (Object)username[0]);
            throw new BadCredentialsException("User " + username[0] + " not authenticated");
        }
        UsernamePasswordAuthenticationToken token = AuthContextUtils.execWithAuthContext(domainKey, () -> {
            UsernamePasswordAuthenticationToken token1 = new UsernamePasswordAuthenticationToken((Object)username[0], null, this.dataAccessor.getAuthorities(username[0]));
            token1.setDetails(authentication.getDetails());
            this.dataAccessor.audit(AuditElements.EventCategoryType.LOGIC, "Authentication", null, "login", AuditElements.Result.SUCCESS, null, isAuthenticated, authentication, "Successfully authenticated, with entitlements: " + token1.getAuthorities());
            return token1;
        });
        LOG.debug("User {} successfully authenticated, with entitlements {}", (Object)username[0], (Object)token.getAuthorities());
        return token;
    }

    public boolean supports(Class<? extends Object> type) {
        return type.equals(UsernamePasswordAuthenticationToken.class);
    }
}

