/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.security.SecureRandom;
import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.RandomStringGenerator;

public final class SecureRandomUtils {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final RandomStringGenerator FOR_PASSWORD = new RandomStringGenerator.Builder().usingRandom(RANDOM::nextInt).withinRange(48, 122).filteredBy(new CharacterPredicate[]{Character::isLetterOrDigit}).build();
    private static final RandomStringGenerator FOR_LETTERS = new RandomStringGenerator.Builder().usingRandom(RANDOM::nextInt).withinRange(97, 122).build();
    private static final RandomStringGenerator FOR_NUMBERS = new RandomStringGenerator.Builder().usingRandom(RANDOM::nextInt).withinRange(48, 57).build();

    public static String generateRandomPassword(int tokenLength) {
        return FOR_PASSWORD.generate(tokenLength);
    }

    public static String generateRandomLetter() {
        return FOR_LETTERS.generate(1);
    }

    public static String generateRandomNumber() {
        return FOR_NUMBERS.generate(1);
    }

    public static String generateRandomSpecialCharacter(char[] characters) {
        return new RandomStringGenerator.Builder().usingRandom(RANDOM::nextInt).filteredBy(new CharacterPredicate[]{codePoint -> {
            boolean found = false;
            for (int i = 0; i < characters.length && !found; ++i) {
                found = codePoint == Character.codePointAt(characters, i);
            }
            return found;
        }}).build().generate(1);
    }

    private SecureRandomUtils() {
    }
}

