/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.provisioning.api.EntitlementsHolder;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetails;
import org.apache.syncope.core.spring.security.SyncopeGrantedAuthority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public final class AuthContextUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AuthContextUtils.class);

    public static String getUsername() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication == null ? "unauthenticated" : authentication.getName();
    }

    public static void updateUsername(String newUsername) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        UsernamePasswordAuthenticationToken newAuth = new UsernamePasswordAuthenticationToken((Object)new User(newUsername, "FAKE_PASSWORD", auth.getAuthorities()), auth.getCredentials(), auth.getAuthorities());
        newAuth.setDetails(auth.getDetails());
        SecurityContextHolder.getContext().setAuthentication((Authentication)newAuth);
    }

    public static Set<SyncopeGrantedAuthority> getAuthorities() {
        SecurityContext ctx = SecurityContextHolder.getContext();
        if (ctx != null && ctx.getAuthentication() != null && ctx.getAuthentication().getAuthorities() != null) {
            HashSet<SyncopeGrantedAuthority> result = new HashSet<SyncopeGrantedAuthority>();
            ctx.getAuthentication().getAuthorities().stream().filter(authority -> authority instanceof SyncopeGrantedAuthority).forEachOrdered(authority -> result.add((SyncopeGrantedAuthority)SyncopeGrantedAuthority.class.cast(authority)));
            return result;
        }
        return Collections.emptySet();
    }

    public static Map<String, Set<String>> getAuthorizations() {
        HashMap<String, Set<String>> result = null;
        SecurityContext ctx = SecurityContextHolder.getContext();
        if (ctx != null && ctx.getAuthentication() != null && ctx.getAuthentication().getAuthorities() != null) {
            result = new HashMap<String, Set<String>>();
            for (GrantedAuthority authority : ctx.getAuthentication().getAuthorities()) {
                if (!(authority instanceof SyncopeGrantedAuthority)) continue;
                result.put(((SyncopeGrantedAuthority)SyncopeGrantedAuthority.class.cast(authority)).getAuthority(), ((SyncopeGrantedAuthority)SyncopeGrantedAuthority.class.cast(authority)).getRealms());
            }
        }
        return result == null ? Collections.emptyMap() : result;
    }

    public static String getDomain() {
        String domainKey;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String string = domainKey = auth != null && auth.getDetails() instanceof SyncopeAuthenticationDetails ? ((SyncopeAuthenticationDetails)SyncopeAuthenticationDetails.class.cast(auth.getDetails())).getDomain() : null;
        if (StringUtils.isBlank(domainKey)) {
            domainKey = "Master";
        }
        return domainKey;
    }

    private static void setFakeAuth(String domain) {
        List authorities = EntitlementsHolder.getInstance().getValues().stream().map(entitlement -> new SyncopeGrantedAuthority((String)entitlement, "/")).collect(Collectors.toList());
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)new User((String)ApplicationContextProvider.getBeanFactory().getBean("adminUser", String.class), "FAKE_PASSWORD", authorities), (Object)"FAKE_PASSWORD", authorities);
        auth.setDetails((Object)new SyncopeAuthenticationDetails(domain));
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
    }

    public static <T> T execWithAuthContext(String domainKey, Executable<T> executable) {
        SecurityContext ctx = SecurityContextHolder.getContext();
        AuthContextUtils.setFakeAuth(domainKey);
        try {
            T t = executable.exec();
            return t;
        }
        catch (Throwable t) {
            LOG.debug("Error during execution with domain {} context", (Object)domainKey, (Object)t);
            throw t;
        }
        finally {
            SecurityContextHolder.clearContext();
            SecurityContextHolder.setContext((SecurityContext)ctx);
        }
    }

    private AuthContextUtils() {
    }

    public static interface Executable<T> {
        public T exec();
    }
}

