/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring;

import groovy.lang.GroovyClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.syncope.common.lib.policy.AccountRuleConf;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.common.lib.policy.PullCorrelationRuleConf;
import org.apache.syncope.common.lib.policy.PushCorrelationRuleConf;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.core.persistence.api.ImplementationLookup;
import org.apache.syncope.core.persistence.api.dao.AccountRule;
import org.apache.syncope.core.persistence.api.dao.PasswordRule;
import org.apache.syncope.core.persistence.api.dao.PullCorrelationRule;
import org.apache.syncope.core.persistence.api.dao.PushCorrelationRule;
import org.apache.syncope.core.persistence.api.dao.Reportlet;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImplementationManager {
    private static final Logger LOG = LoggerFactory.getLogger(ImplementationManager.class);
    private static final GroovyClassLoader GROOVY_CLASSLOADER = new GroovyClassLoader();
    private static final Map<String, Class<?>> CLASS_CACHE = Collections.synchronizedMap(new HashMap());

    public static Optional<Reportlet> buildReportlet(Implementation impl) throws InstantiationException, IllegalAccessException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return Optional.of(ImplementationManager.buildGroovy(impl));
            }
        }
        Reportlet reportlet = null;
        ReportletConf reportletConf = (ReportletConf)POJOHelper.deserialize((String)impl.getBody(), ReportletConf.class);
        Class reportletClass = ((ImplementationLookup)ApplicationContextProvider.getApplicationContext().getBean(ImplementationLookup.class)).getReportletClass(reportletConf.getClass());
        if (reportletClass == null) {
            LOG.warn("Could not find matching reportlet for {}", reportletConf.getClass());
        } else {
            if (ApplicationContextProvider.getBeanFactory().containsSingleton(reportletClass.getName())) {
                reportlet = (Reportlet)ApplicationContextProvider.getBeanFactory().getSingleton(reportletClass.getName());
            } else {
                reportlet = (Reportlet)ApplicationContextProvider.getBeanFactory().createBean(reportletClass, 2, false);
                ApplicationContextProvider.getBeanFactory().registerSingleton(reportletClass.getName(), (Object)reportlet);
            }
            reportlet.setConf(reportletConf);
        }
        return Optional.ofNullable(reportlet);
    }

    public static Optional<AccountRule> buildAccountRule(Implementation impl) throws InstantiationException, IllegalAccessException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return Optional.of(ImplementationManager.buildGroovy(impl));
            }
        }
        AccountRule rule = null;
        AccountRuleConf ruleConf = (AccountRuleConf)POJOHelper.deserialize((String)impl.getBody(), AccountRuleConf.class);
        Class ruleClass = ((ImplementationLookup)ApplicationContextProvider.getApplicationContext().getBean(ImplementationLookup.class)).getAccountRuleClass(ruleConf.getClass());
        if (ruleClass == null) {
            LOG.warn("Could not find matching account rule for {}", impl.getClass());
        } else {
            if (ApplicationContextProvider.getBeanFactory().containsSingleton(ruleClass.getName())) {
                rule = (AccountRule)ApplicationContextProvider.getBeanFactory().getSingleton(ruleClass.getName());
            } else {
                rule = (AccountRule)ApplicationContextProvider.getBeanFactory().createBean(ruleClass, 2, false);
                ApplicationContextProvider.getBeanFactory().registerSingleton(ruleClass.getName(), (Object)rule);
            }
            rule.setConf(ruleConf);
        }
        return Optional.ofNullable(rule);
    }

    public static Optional<PasswordRule> buildPasswordRule(Implementation impl) throws InstantiationException, IllegalAccessException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return Optional.of(ImplementationManager.buildGroovy(impl));
            }
        }
        PasswordRule rule = null;
        PasswordRuleConf ruleConf = (PasswordRuleConf)POJOHelper.deserialize((String)impl.getBody(), PasswordRuleConf.class);
        Class ruleClass = ((ImplementationLookup)ApplicationContextProvider.getApplicationContext().getBean(ImplementationLookup.class)).getPasswordRuleClass(ruleConf.getClass());
        if (ruleClass == null) {
            LOG.warn("Could not find matching password rule for {}", impl.getClass());
        } else {
            if (ApplicationContextProvider.getBeanFactory().containsSingleton(ruleClass.getName())) {
                rule = (PasswordRule)ApplicationContextProvider.getBeanFactory().getSingleton(ruleClass.getName());
            } else {
                rule = (PasswordRule)ApplicationContextProvider.getBeanFactory().createBean(ruleClass, 2, false);
                ApplicationContextProvider.getBeanFactory().registerSingleton(ruleClass.getName(), (Object)rule);
            }
            rule.setConf(ruleConf);
        }
        return Optional.ofNullable(rule);
    }

    public static Optional<PullCorrelationRule> buildPullCorrelationRule(Implementation impl) throws InstantiationException, IllegalAccessException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return Optional.of(ImplementationManager.buildGroovy(impl));
            }
        }
        PullCorrelationRule rule = null;
        PullCorrelationRuleConf ruleConf = (PullCorrelationRuleConf)POJOHelper.deserialize((String)impl.getBody(), PullCorrelationRuleConf.class);
        Class ruleClass = ((ImplementationLookup)ApplicationContextProvider.getApplicationContext().getBean(ImplementationLookup.class)).getPullCorrelationRuleClass(ruleConf.getClass());
        if (ruleClass == null) {
            LOG.warn("Could not find matching pull correlation rule for {}", impl.getClass());
        } else {
            if (ApplicationContextProvider.getBeanFactory().containsSingleton(ruleClass.getName())) {
                rule = (PullCorrelationRule)ApplicationContextProvider.getBeanFactory().getSingleton(ruleClass.getName());
            } else {
                rule = (PullCorrelationRule)ApplicationContextProvider.getBeanFactory().createBean(ruleClass, 2, false);
                ApplicationContextProvider.getBeanFactory().registerSingleton(ruleClass.getName(), (Object)rule);
            }
            rule.setConf(ruleConf);
        }
        return Optional.ofNullable(rule);
    }

    public static Optional<PushCorrelationRule> buildPushCorrelationRule(Implementation impl) throws InstantiationException, IllegalAccessException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return Optional.of(ImplementationManager.buildGroovy(impl));
            }
        }
        PushCorrelationRule rule = null;
        PushCorrelationRuleConf ruleConf = (PushCorrelationRuleConf)POJOHelper.deserialize((String)impl.getBody(), PushCorrelationRuleConf.class);
        Class ruleClass = ((ImplementationLookup)ApplicationContextProvider.getApplicationContext().getBean(ImplementationLookup.class)).getPushCorrelationRuleClass(ruleConf.getClass());
        if (ruleClass == null) {
            LOG.warn("Could not find matching push correlation rule for {}", impl.getClass());
        } else {
            if (ApplicationContextProvider.getBeanFactory().containsSingleton(ruleClass.getName())) {
                rule = (PushCorrelationRule)ApplicationContextProvider.getBeanFactory().getSingleton(ruleClass.getName());
            } else {
                rule = (PushCorrelationRule)ApplicationContextProvider.getBeanFactory().createBean(ruleClass, 2, false);
                ApplicationContextProvider.getBeanFactory().registerSingleton(ruleClass.getName(), (Object)rule);
            }
            rule.setConf(ruleConf);
        }
        return Optional.ofNullable(rule);
    }

    public static <T> T build(Implementation impl) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return ImplementationManager.buildGroovy(impl);
            }
        }
        return ImplementationManager.buildJava(impl);
    }

    private static <T> T buildGroovy(Implementation impl) throws InstantiationException, IllegalAccessException {
        Class<?> clazz;
        if (CLASS_CACHE.containsKey(impl.getKey())) {
            clazz = CLASS_CACHE.get(impl.getKey());
        } else {
            clazz = GROOVY_CLASSLOADER.parseClass(impl.getBody());
            CLASS_CACHE.put(impl.getKey(), clazz);
        }
        return (T)ApplicationContextProvider.getBeanFactory().createBean(clazz, 2, false);
    }

    private static <T> T buildJava(Implementation impl) throws ClassNotFoundException {
        Class<?> clazz;
        if (CLASS_CACHE.containsKey(impl.getKey())) {
            clazz = CLASS_CACHE.get(impl.getKey());
        } else {
            clazz = Class.forName(impl.getBody());
            CLASS_CACHE.put(impl.getKey(), clazz);
        }
        return (T)ApplicationContextProvider.getBeanFactory().createBean(clazz, 2, false);
    }

    public static Class<?> purge(String implementation) {
        return CLASS_CACHE.remove(implementation);
    }

    private ImplementationManager() {
    }
}

