/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.datetime;

import java.time.LocalDate;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.LocalDateConverter;

public class LocalDateTextField
extends TextField<LocalDate>
implements AbstractTextComponent.ITextFormatProvider {
    private static final long serialVersionUID = 1L;
    private final TextFormatConverter converter;

    public LocalDateTextField(String id, IModel<LocalDate> model, final String datePattern) {
        super(id, model, LocalDate.class);
        this.converter = new TextFormatConverter(){
            private static final long serialVersionUID = 1L;

            public DateTimeFormatter getDateTimeFormatter(Locale locale) {
                return DateTimeFormatter.ofPattern(datePattern).withLocale(locale);
            }

            @Override
            public String getTextFormat(Locale locale) {
                return datePattern;
            }
        };
    }

    public LocalDateTextField(String id, String datePattern) {
        this(id, null, datePattern);
    }

    public LocalDateTextField(String id, IModel<LocalDate> model, final FormatStyle dateStyle) {
        super(id, model, LocalDate.class);
        this.converter = new TextFormatConverter(){
            private static final long serialVersionUID = 1L;

            public DateTimeFormatter getDateTimeFormatter(Locale locale) {
                return DateTimeFormatter.ofLocalizedDate(dateStyle).withLocale(locale);
            }

            @Override
            public String getTextFormat(Locale locale) {
                return DateTimeFormatterBuilder.getLocalizedDateTimePattern(dateStyle, null, IsoChronology.INSTANCE, locale);
            }
        };
    }

    public LocalDateTextField(String id, FormatStyle dateStyle) {
        this(id, null, dateStyle);
    }

    protected IConverter<?> createConverter(Class<?> clazz) {
        if (LocalDate.class.isAssignableFrom(clazz)) {
            return this.converter;
        }
        return null;
    }

    public final String getTextFormat() {
        return this.converter.getTextFormat(this.getLocale());
    }

    private abstract class TextFormatConverter
    extends LocalDateConverter {
        private static final long serialVersionUID = 1L;

        private TextFormatConverter() {
        }

        public abstract String getTextFormat(Locale var1);
    }
}

