/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.model.CustomAttributesInfo;
import org.apache.syncope.client.enduser.resources.BaseUserSelfResource;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

@Resource(key="userSelfRead", path="/api/self/read")
public class UserSelfReadResource
extends BaseUserSelfResource {
    private static final long serialVersionUID = -9184809392631523912L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        LOG.debug("Requested user self information");
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("application/json");
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            UserTO userTO = (UserTO)SerializationUtils.clone((Serializable)SyncopeEnduserSession.get().getSelfTO());
            for (PlainSchemaTO plainSchema : SyncopeEnduserSession.get().getDatePlainSchemas()) {
                for (MembershipTO membership : userTO.getMemberships()) {
                    this.dateToMillis(membership.getPlainAttrs(), plainSchema);
                }
            }
            for (MembershipTO membership : userTO.getMemberships()) {
                String groupName = membership.getGroupName();
                membership.getPlainAttrs().stream().map(attr -> {
                    attr.setSchema(groupName.concat("#").concat(attr.getSchema()));
                    return attr;
                }).forEachOrdered(attr -> userTO.getPlainAttrs().add(attr));
                membership.getPlainAttrs().clear();
                membership.getDerAttrs().stream().map(attr -> {
                    attr.setSchema(groupName.concat("#").concat(attr.getSchema()));
                    return attr;
                }).forEachOrdered(attr -> userTO.getDerAttrs().add(attr));
                membership.getDerAttrs().clear();
                membership.getVirAttrs().stream().map(attr -> {
                    attr.setSchema(groupName.concat("#").concat(attr.getSchema()));
                    return attr;
                }).forEachOrdered(attr -> userTO.getVirAttrs().add(attr));
                membership.getVirAttrs().clear();
            }
            this.applyFromCustomization(userTO, SyncopeEnduserApplication.get().getCustomForm());
            for (PlainSchemaTO plainSchema : SyncopeEnduserSession.get().getDatePlainSchemas()) {
                this.dateToMillis(userTO.getPlainAttrs(), plainSchema);
            }
            final String selfTOJson = MAPPER.writeValueAsString((Object)userTO);
            response.setContentType("application/json");
            response.setTextEncoding(StandardCharsets.UTF_8.name());
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)selfTOJson);
                }
            });
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving selfTO", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }

    private void applyFromCustomization(UserTO userTO, Map<String, CustomAttributesInfo> customForm) {
        if (customForm != null && !customForm.isEmpty()) {
            this.customizeAttrTOs(userTO.getPlainAttrs(), customForm.get(SchemaType.PLAIN.name()));
            this.customizeAttrTOs(userTO.getDerAttrs(), customForm.get(SchemaType.DERIVED.name()));
            this.customizeAttrTOs(userTO.getVirAttrs(), customForm.get(SchemaType.VIRTUAL.name()));
        }
    }

    private void customizeAttrTOs(Set<AttrTO> attrs, CustomAttributesInfo customAttributesInfo) {
        if (customAttributesInfo != null && customAttributesInfo.isShow().booleanValue() && !customAttributesInfo.getAttributes().isEmpty()) {
            attrs.removeAll(attrs.stream().filter(attr -> !customAttributesInfo.getAttributes().containsKey(attr.getSchema())).collect(Collectors.toList()));
        } else if (customAttributesInfo != null && !customAttributesInfo.isShow().booleanValue()) {
            attrs.clear();
        }
    }
}

