/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.resources.BaseResource;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.string.StringValue;

@Resource(key="groups", path="/api/groups")
public class GroupResource
extends BaseResource {
    private static final long serialVersionUID = 7475706378304995200L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        LOG.debug("Search all available groups");
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("application/json");
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            String realm = URLDecoder.decode(attributes.getParameters().get("realm").toString("/"), "UTF-8");
            StringValue term = attributes.getParameters().get("term");
            final GroupResponse groupResponse = new GroupResponse();
            int totGroups = SyncopeEnduserSession.get().getService(SyncopeService.class).numbers().getTotalGroups();
            List groupTOs = SyncopeEnduserSession.get().getService(SyncopeService.class).searchAssignableGroups(realm, term.isNull() || term.isEmpty() ? null : URLDecoder.decode(term.toString(), "UTF-8"), 1, 30).getResult();
            groupResponse.setTotGroups(totGroups);
            groupResponse.setGroupTOs(groupTOs.stream().collect(Collectors.toMap(AnyTO::getKey, GroupTO::getName)));
            response.setTextEncoding(StandardCharsets.UTF_8.name());
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)BaseResource.MAPPER.writeValueAsString((Object)groupResponse));
                }
            });
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving available groups", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }

    private class GroupResponse {
        private Map<String, String> groups;
        private int totGroups;

        private GroupResponse() {
        }

        public Map<String, String> getGroupTOs() {
            return Collections.unmodifiableMap(this.groups);
        }

        public void setGroupTOs(Map<String, String> groups) {
            this.groups = groups;
        }

        public int getTotGroups() {
            return this.totGroups;
        }

        public void setTotGroups(int totGroups) {
            this.totGroups = totGroups;
        }
    }
}

