/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.wizard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.extensions.wizard.AbstractWizardModel;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.util.collections.ArrayListStack;
import org.apache.wicket.util.io.IClusterable;

public class WizardModel
extends AbstractWizardModel {
    public static final ICondition TRUE = (ICondition & Serializable)() -> true;
    private static final long serialVersionUID = 1L;
    private IWizardStep activeStep;
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    private final ArrayListStack<IWizardStep> history = new ArrayListStack();
    private final List<IWizardStep> steps = new ArrayList<IWizardStep>();

    public void add(IWizardStep step) {
        if (step instanceof ICondition) {
            this.add(step, (ICondition)((Object)step));
        } else {
            this.add(step, TRUE);
        }
    }

    public void add(IWizardStep step, ICondition condition) {
        this.steps.add(step);
        this.conditions.add(condition);
    }

    @Override
    public final IWizardStep getActiveStep() {
        return this.activeStep;
    }

    @Override
    public boolean isLastAvailable() {
        return this.allStepsComplete() && !this.isLastStep(this.activeStep);
    }

    @Override
    public boolean isLastStep(IWizardStep step) {
        return this.findLastStep().equals(step);
    }

    @Override
    public boolean isNextAvailable() {
        return this.activeStep.isComplete() && !this.isLastStep(this.activeStep);
    }

    @Override
    public boolean isPreviousAvailable() {
        return !this.history.isEmpty();
    }

    @Override
    public void last() {
        this.history.push((Object)this.getActiveStep());
        IWizardStep lastStep = this.findLastStep();
        this.setActiveStep(lastStep);
    }

    @Override
    public void next() {
        this.history.push((Object)this.getActiveStep());
        IWizardStep step = this.findNextVisibleStep();
        this.setActiveStep(step);
    }

    @Override
    public void previous() {
        IWizardStep step = (IWizardStep)this.history.pop();
        this.setActiveStep(step);
    }

    @Override
    public void reset() {
        this.history.clear();
        this.activeStep = null;
        for (IWizardStep step : this.steps) {
            step.init(this);
        }
        this.setActiveStep(this.findNextVisibleStep());
    }

    public void setActiveStep(IWizardStep step) {
        if (this.activeStep != null && step != null && this.activeStep.equals(step)) {
            return;
        }
        this.activeStep = step;
        this.fireActiveStepChanged(step);
    }

    @Override
    public Iterator<IWizardStep> stepIterator() {
        ArrayList<IWizardStep> filtered = new ArrayList<IWizardStep>();
        for (int s = 0; s < this.steps.size(); ++s) {
            if (!this.conditions.get(s).evaluate()) continue;
            filtered.add(this.steps.get(s));
        }
        return filtered.iterator();
    }

    protected final boolean allStepsComplete() {
        for (IWizardStep step : this.steps) {
            if (step.isComplete()) continue;
            return false;
        }
        return true;
    }

    protected final IWizardStep findLastStep() {
        for (int i = this.conditions.size() - 1; i >= 0; --i) {
            ICondition condition = this.conditions.get(i);
            if (!condition.evaluate()) continue;
            return this.steps.get(i);
        }
        throw new IllegalStateException("Wizard contains no visible steps");
    }

    protected final IWizardStep findNextVisibleStep() {
        int startIndex;
        for (int i = startIndex = this.activeStep == null ? 0 : this.steps.indexOf(this.activeStep) + 1; i < this.conditions.size(); ++i) {
            ICondition condition = this.conditions.get(i);
            if (!condition.evaluate()) continue;
            return this.steps.get(i);
        }
        throw new IllegalStateException("Wizard contains no more visible steps");
    }

    public List<ICondition> getConditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    @FunctionalInterface
    public static interface ICondition
    extends IClusterable {
        public boolean evaluate();
    }
}

