/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.WorkflowDefinitionTO;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="Workflow")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="workflows")
public interface WorkflowService
extends JAXRSService {
    @GET
    @Path(value="{anyType}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<WorkflowDefinitionTO> list(@NotNull @PathParam(value="anyType") String var1);

    @GET
    @Path(value="{anyType}/{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response get(@NotNull @PathParam(value="anyType") String var1, @NotNull @PathParam(value="key") String var2);

    @GET
    @Path(value="{anyType}/{key}/diagram.png")
    @Produces(value={"image/png"})
    public Response exportDiagram(@NotNull @PathParam(value="anyType") String var1, @NotNull @PathParam(value="key") String var2);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @PUT
    @Path(value="{anyType}/{key}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void set(@NotNull @PathParam(value="anyType") String var1, @NotNull @PathParam(value="key") String var2, @NotNull String var3);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{anyType}/{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@NotNull @PathParam(value="anyType") String var1, @NotNull @PathParam(value="key") String var2);
}

