/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.to.WorkflowFormTO;
import org.apache.syncope.common.lib.to.WorkflowTaskTO;
import org.apache.syncope.common.rest.api.beans.WorkflowFormQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="UserWorkflow")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="userworkflow")
public interface UserWorkflowService
extends JAXRSService {
    @GET
    @Path(value="forms")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public PagedResult<WorkflowFormTO> getForms(@BeanParam WorkflowFormQuery var1);

    @GET
    @Path(value="forms/{userKey}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public WorkflowFormTO getFormForUser(@NotNull @PathParam(value="userKey") String var1);

    @POST
    @Path(value="forms/{taskId}/claim")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public WorkflowFormTO claimForm(@NotNull @PathParam(value="taskId") String var1);

    @POST
    @Path(value="forms")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public UserTO submitForm(@NotNull WorkflowFormTO var1);

    @GET
    @Path(value="tasks/{userKey}")
    public List<WorkflowTaskTO> getAvailableTasks(@NotNull @PathParam(value="userKey") String var1);

    @POST
    @Path(value="tasks/{taskId}/execute")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public UserTO executeTask(@NotNull @PathParam(value="taskId") String var1, @NotNull UserTO var2);
}

