/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="Realms")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="realms")
public interface RealmService
extends JAXRSService {
    @GET
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<RealmTO> list();

    @GET
    @Path(value="{fullPath:.*}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<RealmTO> list(@NotNull @PathParam(value="fullPath") String var1);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false"))})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Realm successfully created enriched with propagation status information, as Entity,or empty if 'Prefer: return-no-content' was specified", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}, headers={@Header(name="X-Syncope-Key", schema=@Schema(type="string"), description="UUID generated for the realm created"), @Header(name="Location", schema=@Schema(type="string"), description="URL of the realm created"), @Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @POST
    @Path(value="{parentPath:.*}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response create(@NotNull @PathParam(value="parentPath") String var1, @NotNull RealmTO var2);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false")), @Parameter(name="fullPath", description="Realm's key", in=ParameterIn.PATH, schema=@Schema(type="string"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Realm successfully updated enriched with propagation status information, as Entity", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}), @ApiResponse(responseCode="204", description="No content if 'Prefer: return-no-content' was specified", headers={@Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @PUT
    @Path(value="{fullPath:.*}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response update(@NotNull RealmTO var1);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Realm successfully deleted enriched with propagation status information, as Entity", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}), @ApiResponse(responseCode="204", description="No content if 'Prefer: return-no-content' was specified", headers={@Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @DELETE
    @Path(value="{fullPath:.*}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response delete(@NotNull @PathParam(value="fullPath") String var1);
}

