/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.history.async;

import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.impl.cfg.TransactionListener;
import org.flowable.common.engine.impl.cfg.TransactionPropagation;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.job.service.impl.util.CommandContextUtil;

public class TriggerAsyncExecutorTransactionListener
implements TransactionListener {
    protected List<HistoryJobEntity> historyJobEntities;
    protected JobServiceConfiguration jobServiceConfiguration;

    public TriggerAsyncExecutorTransactionListener(CommandContext commandContext) {
        this(commandContext, null);
    }

    public TriggerAsyncExecutorTransactionListener(CommandContext commandContext, HistoryJobEntity historyJobEntity) {
        this.jobServiceConfiguration = CommandContextUtil.getJobServiceConfiguration(commandContext);
        if (historyJobEntity != null) {
            this.historyJobEntities = new ArrayList<HistoryJobEntity>(1);
            this.historyJobEntities.add(historyJobEntity);
        }
    }

    public void addHistoryJobEntity(HistoryJobEntity historyJobEntity) {
        if (this.historyJobEntities == null) {
            this.historyJobEntities = new ArrayList<HistoryJobEntity>(1);
        }
        this.historyJobEntities.add(historyJobEntity);
    }

    public void addHistoryJobEntities(List<HistoryJobEntity> historyJobEntities) {
        if (this.historyJobEntities == null) {
            this.historyJobEntities = new ArrayList<HistoryJobEntity>(historyJobEntities.size());
        }
        this.historyJobEntities.addAll(historyJobEntities);
    }

    public void execute(CommandContext commandContext) {
        for (final HistoryJobEntity historyJobEntity : this.historyJobEntities) {
            this.jobServiceConfiguration.getCommandExecutor().execute(new CommandConfig(false, TransactionPropagation.REQUIRES_NEW), (Command)new Command<Void>(){

                public Void execute(CommandContext commandContext) {
                    TriggerAsyncExecutorTransactionListener.this.jobServiceConfiguration.getAsyncHistoryExecutor().executeAsyncJob(historyJobEntity);
                    return null;
                }
            });
        }
    }
}

