/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl;

import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.job.api.DeadLetterJobQuery;
import org.flowable.job.api.HistoryJobQuery;
import org.flowable.job.api.JobInfo;
import org.flowable.job.api.JobQuery;
import org.flowable.job.api.SuspendedJobQuery;
import org.flowable.job.api.TimerJobQuery;
import org.flowable.job.service.JobService;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.DeadLetterJobQueryImpl;
import org.flowable.job.service.impl.HistoryJobQueryImpl;
import org.flowable.job.service.impl.JobQueryImpl;
import org.flowable.job.service.impl.ServiceImpl;
import org.flowable.job.service.impl.SuspendedJobQueryImpl;
import org.flowable.job.service.impl.TimerJobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntity;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntityManager;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntityManager;
import org.flowable.job.service.impl.persistence.entity.SuspendedJobEntity;
import org.flowable.job.service.impl.persistence.entity.SuspendedJobEntityManager;

public class JobServiceImpl
extends ServiceImpl
implements JobService {
    public JobServiceImpl(JobServiceConfiguration jobServiceConfiguration) {
        super(jobServiceConfiguration);
    }

    @Override
    public JobQuery createJobQuery() {
        return new JobQueryImpl(this.getCommandExecutor());
    }

    @Override
    public TimerJobQuery createTimerJobQuery() {
        return new TimerJobQueryImpl(this.getCommandExecutor());
    }

    @Override
    public SuspendedJobQuery createSuspendedJobQuery() {
        return new SuspendedJobQueryImpl(this.getCommandExecutor());
    }

    @Override
    public DeadLetterJobQuery createDeadLetterJobQuery() {
        return new DeadLetterJobQueryImpl(this.getCommandExecutor());
    }

    @Override
    public HistoryJobQuery createHistoryJobQuery() {
        return new HistoryJobQueryImpl(this.getCommandExecutor());
    }

    @Override
    public void scheduleAsyncJob(JobEntity job) {
        this.getJobManager().scheduleAsyncJob(job);
    }

    @Override
    public JobEntity findJobById(String jobId) {
        return (JobEntity)this.getJobEntityManager().findById(jobId);
    }

    @Override
    public List<JobEntity> findJobsByExecutionId(String executionId) {
        return this.getJobEntityManager().findJobsByExecutionId(executionId);
    }

    @Override
    public List<SuspendedJobEntity> findSuspendedJobsByExecutionId(String executionId) {
        return this.getSuspendedJobEntityManager().findJobsByExecutionId(executionId);
    }

    @Override
    public List<DeadLetterJobEntity> findDeadLetterJobsByExecutionId(String executionId) {
        return this.getDeadLetterJobEntityManager().findJobsByExecutionId(executionId);
    }

    @Override
    public List<JobEntity> findJobsByProcessInstanceId(String processInstanceId) {
        return this.getJobEntityManager().findJobsByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<SuspendedJobEntity> findSuspendedJobsByProcessInstanceId(String processInstanceId) {
        return this.getSuspendedJobEntityManager().findJobsByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<DeadLetterJobEntity> findDeadLetterJobsByProcessInstanceId(String processInstanceId) {
        return this.getDeadLetterJobEntityManager().findJobsByProcessInstanceId(processInstanceId);
    }

    @Override
    public void updateAllJobTypesTenantIdForDeployment(String deploymentId, String newTenantId) {
        this.getJobEntityManager().updateJobTenantIdForDeployment(deploymentId, newTenantId);
        this.getTimerJobEntityManager().updateJobTenantIdForDeployment(deploymentId, newTenantId);
        this.getSuspendedJobEntityManager().updateJobTenantIdForDeployment(deploymentId, newTenantId);
        this.getDeadLetterJobEntityManager().updateJobTenantIdForDeployment(deploymentId, newTenantId);
    }

    @Override
    public AbstractRuntimeJobEntity activateSuspendedJob(SuspendedJobEntity job) {
        if (((JobServiceConfiguration)((Object)this.configuration)).getJobParentStateResolver().isSuspended(job)) {
            throw new FlowableIllegalArgumentException("Can not activate job " + job.getId() + ". Parent is suspended.");
        }
        return this.getJobManager().activateSuspendedJob(job);
    }

    @Override
    public SuspendedJobEntity moveJobToSuspendedJob(AbstractRuntimeJobEntity job) {
        return this.getJobManager().moveJobToSuspendedJob(job);
    }

    @Override
    public AbstractRuntimeJobEntity moveJobToDeadLetterJob(AbstractRuntimeJobEntity job) {
        return this.getJobManager().moveJobToDeadLetterJob(job);
    }

    @Override
    public void unacquireWithDecrementRetries(JobInfo job) {
        this.getJobManager().unacquireWithDecrementRetries(job);
    }

    @Override
    public JobEntity createJob() {
        return (JobEntity)this.getJobEntityManager().create();
    }

    @Override
    public void createAsyncJob(JobEntity job, boolean isExclusive) {
        this.getJobManager().createAsyncJob(job, isExclusive);
    }

    @Override
    public void insertJob(JobEntity job) {
        this.getJobEntityManager().insert(job);
    }

    @Override
    public DeadLetterJobEntity createDeadLetterJob() {
        return (DeadLetterJobEntity)this.getDeadLetterJobEntityManager().create();
    }

    @Override
    public void insertDeadLetterJob(DeadLetterJobEntity deadLetterJob) {
        this.getDeadLetterJobEntityManager().insert(deadLetterJob);
    }

    @Override
    public void updateJob(JobEntity job) {
        this.getJobEntityManager().update(job);
    }

    @Override
    public void deleteJob(String jobId) {
        this.getJobEntityManager().delete(jobId);
    }

    @Override
    public void deleteJob(JobEntity job) {
        this.getJobEntityManager().delete(job);
    }

    @Override
    public void deleteJobsByExecutionId(String executionId) {
        JobEntityManager jobEntityManager = this.getJobEntityManager();
        List jobsForExecution = jobEntityManager.findJobsByExecutionId(executionId);
        for (JobEntity job : jobsForExecution) {
            this.getJobEntityManager().delete(job);
            if (!this.getEventDispatcher().isEnabled()) continue;
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_CANCELED, job));
        }
    }

    @Override
    public void deleteSuspendedJobsByExecutionId(String executionId) {
        SuspendedJobEntityManager suspendedJobEntityManager = this.getSuspendedJobEntityManager();
        List<SuspendedJobEntity> suspendedJobsForExecution = suspendedJobEntityManager.findJobsByExecutionId(executionId);
        for (SuspendedJobEntity job : suspendedJobsForExecution) {
            suspendedJobEntityManager.delete(job);
            if (!this.getEventDispatcher().isEnabled()) continue;
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_CANCELED, job));
        }
    }

    @Override
    public void deleteDeadLetterJobsByExecutionId(String executionId) {
        DeadLetterJobEntityManager deadLetterJobEntityManager = this.getDeadLetterJobEntityManager();
        List<DeadLetterJobEntity> deadLetterJobsForExecution = deadLetterJobEntityManager.findJobsByExecutionId(executionId);
        for (DeadLetterJobEntity job : deadLetterJobsForExecution) {
            deadLetterJobEntityManager.delete(job);
            if (!this.getEventDispatcher().isEnabled()) continue;
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_CANCELED, job));
        }
    }
}

