/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.ws.WebSocketSettings;
import org.apache.wicket.protocol.ws.api.WicketWebSocketJQueryResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.cookies.CookieUtils;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.template.PackageTextTemplate;

public class BaseWebSocketBehavior
extends Behavior {
    private final String resourceName;

    protected BaseWebSocketBehavior() {
        this.resourceName = null;
    }

    public BaseWebSocketBehavior(String resourceName) {
        this.resourceName = (String)Args.notEmpty((CharSequence)resourceName, (String)"resourceName");
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)WicketWebSocketJQueryResourceReference.get()));
        PackageTextTemplate webSocketSetupTemplate = new PackageTextTemplate(WicketWebSocketJQueryResourceReference.class, "res/js/wicket-websocket-setup.js.tmpl");
        HashMap variables = Generics.newHashMap();
        if (Strings.isEmpty((CharSequence)this.resourceName)) {
            int pageId = component.getPage().getPageId();
            variables.put("pageId", pageId);
            variables.put("resourceName", "");
        } else {
            variables.put("resourceName", this.resourceName);
            variables.put("pageId", false);
        }
        WebSocketSettings webSocketSettings = WebSocketSettings.Holder.get(component.getApplication());
        CharSequence baseUrl = this.getBaseUrl(webSocketSettings);
        Args.notNull((Object)baseUrl, (String)"baseUrl");
        variables.put("baseUrl", baseUrl);
        Integer port = this.getPort(webSocketSettings);
        variables.put("port", port);
        Integer securePort = this.getSecurePort(webSocketSettings);
        variables.put("securePort", securePort);
        CharSequence contextPath = this.getContextPath(webSocketSettings);
        Args.notNull((Object)contextPath, (String)"contextPath");
        variables.put("contextPath", contextPath);
        variables.put("applicationName", component.getApplication().getName());
        CharSequence filterPrefix = this.getFilterPrefix(webSocketSettings);
        Args.notNull((Object)filterPrefix, (String)"filterPrefix");
        variables.put("filterPrefix", filterPrefix);
        CharSequence sessionId = this.getSessionId(component);
        variables.put("sessionId", sessionId);
        String webSocketSetupScript = webSocketSetupTemplate.asString((Map)variables);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)webSocketSetupScript));
    }

    protected Integer getPort(WebSocketSettings webSocketSettings) {
        return webSocketSettings.getPort();
    }

    protected Integer getSecurePort(WebSocketSettings webSocketSettings) {
        return webSocketSettings.getSecurePort();
    }

    protected CharSequence getFilterPrefix(WebSocketSettings webSocketSettings) {
        return webSocketSettings.getFilterPrefix();
    }

    protected CharSequence getContextPath(WebSocketSettings webSocketSettings) {
        return webSocketSettings.getContextPath();
    }

    protected CharSequence getBaseUrl(WebSocketSettings webSocketSettings) {
        return webSocketSettings.getBaseUrl();
    }

    protected CharSequence getSessionId(Component component) {
        String sessionId = "";
        WebApplication application = (WebApplication)component.getApplication();
        Set effectiveSessionTrackingModes = application.getServletContext().getEffectiveSessionTrackingModes();
        Object containerRequest = component.getRequest().getContainerRequest();
        if (effectiveSessionTrackingModes.size() == 1 && SessionTrackingMode.URL.equals(effectiveSessionTrackingModes.iterator().next())) {
            sessionId = component.getSession().getId();
        } else if (containerRequest instanceof HttpServletRequest) {
            CookieUtils cookieUtils = new CookieUtils();
            Cookie jsessionid = cookieUtils.getCookie("JSESSIONID");
            HttpServletRequest httpServletRequest = (HttpServletRequest)containerRequest;
            if (jsessionid == null || !httpServletRequest.isRequestedSessionIdValid()) {
                sessionId = component.getSession().getId();
            }
        }
        return sessionId;
    }

    public boolean getStatelessHint(Component component) {
        return false;
    }
}

