/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm.sc;

import groovyjarjarasm.asm.Handle;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.LambdaExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.ClosureWriter;
import org.codehaus.groovy.classgen.asm.CompileStack;
import org.codehaus.groovy.classgen.asm.LambdaWriter;
import org.codehaus.groovy.classgen.asm.OperandStack;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.classgen.asm.WriterControllerFactory;
import org.codehaus.groovy.classgen.asm.sc.StaticTypesClosureWriter;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class StaticTypesLambdaWriter
extends LambdaWriter {
    private static final String DO_CALL = "doCall";
    private static final String ORIGINAL_PARAMETERS_WITH_EXACT_TYPE = "__ORIGINAL_PARAMETERS_WITH_EXACT_TYPE";
    private static final String LAMBDA_SHARED_VARIABLES = "__LAMBDA_SHARED_VARIABLES";
    private static final String ENCLOSING_THIS = "__enclosing_this";
    private static final String LAMBDA_THIS = "__lambda_this";
    private static final String INIT = "<init>";
    private static final String IS_GENERATED_CONSTRUCTOR = "__IS_GENERATED_CONSTRUCTOR";
    private StaticTypesClosureWriter staticTypesClosureWriter;
    private WriterController controller;
    private WriterControllerFactory factory;
    private final Map<Expression, ClassNode> lambdaClassMap = new HashMap<Expression, ClassNode>();

    public StaticTypesLambdaWriter(WriterController wc) {
        super(wc);
        this.staticTypesClosureWriter = new StaticTypesClosureWriter(wc);
        this.controller = wc;
        this.factory = new WriterControllerFactory(){

            @Override
            public WriterController makeController(WriterController normalController) {
                return StaticTypesLambdaWriter.this.controller;
            }
        };
    }

    @Override
    public void writeLambda(LambdaExpression expression) {
        ClassNode lambdaType = this.getLambdaType(expression);
        ClassNode redirect = lambdaType.redirect();
        if (null == lambdaType || !ClassHelper.isFunctionalInterface(redirect)) {
            super.writeLambda(expression);
            return;
        }
        MethodNode abstractMethodNode = ClassHelper.findSAM(redirect);
        String abstractMethodDesc = this.createMethodDescriptor(abstractMethodNode);
        ClassNode classNode = this.controller.getClassNode();
        boolean isInterface = classNode.isInterface();
        ClassNode lambdaWrapperClassNode = this.getOrAddLambdaClass(expression, 0x11 | (isInterface ? 8 : 0) | 0x1000, abstractMethodNode);
        MethodNode syntheticLambdaMethodNode = lambdaWrapperClassNode.getMethods(DO_CALL).get(0);
        this.newGroovyLambdaWrapperAndLoad(lambdaWrapperClassNode, syntheticLambdaMethodNode);
        this.loadEnclosingClassInstance();
        MethodVisitor mv = this.controller.getMethodVisitor();
        OperandStack operandStack = this.controller.getOperandStack();
        mv.visitInvokeDynamicInsn(abstractMethodNode.getName(), this.createAbstractMethodDesc(lambdaType, lambdaWrapperClassNode), this.createBootstrapMethod(isInterface), this.createBootstrapMethodArguments(abstractMethodDesc, lambdaWrapperClassNode, syntheticLambdaMethodNode));
        operandStack.replace(redirect, 2);
        if (null != expression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_LAMBDA_TYPE)) {
            mv.visitInsn(89);
        }
    }

    private ClassNode getLambdaType(LambdaExpression expression) {
        ClassNode type = (ClassNode)expression.getNodeMetaData((Object)StaticTypesMarker.PARAMETER_TYPE);
        if (null == type) {
            type = (ClassNode)expression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_LAMBDA_TYPE);
        }
        return type;
    }

    private void loadEnclosingClassInstance() {
        MethodVisitor mv = this.controller.getMethodVisitor();
        OperandStack operandStack = this.controller.getOperandStack();
        CompileStack compileStack = this.controller.getCompileStack();
        if (this.controller.isStaticMethod() || compileStack.isInSpecialConstructorCall()) {
            operandStack.pushConstant(ConstantExpression.NULL);
        } else {
            mv.visitVarInsn(25, 0);
            operandStack.push(this.controller.getClassNode());
        }
    }

    private void newGroovyLambdaWrapperAndLoad(ClassNode lambdaWrapperClassNode, MethodNode syntheticLambdaMethodNode) {
        MethodVisitor mv = this.controller.getMethodVisitor();
        String lambdaWrapperClassInternalName = BytecodeHelper.getClassInternalName(lambdaWrapperClassNode);
        mv.visitTypeInsn(187, lambdaWrapperClassInternalName);
        mv.visitInsn(89);
        this.loadEnclosingClassInstance();
        this.loadEnclosingClassInstance();
        this.loadSharedVariables(syntheticLambdaMethodNode);
        List constructorNodeList = lambdaWrapperClassNode.getDeclaredConstructors().stream().filter(e -> Boolean.TRUE.equals(e.getNodeMetaData(IS_GENERATED_CONSTRUCTOR))).collect(Collectors.toList());
        if (constructorNodeList.size() == 0) {
            throw new GroovyBugError("Failed to find the generated constructor");
        }
        ConstructorNode constructorNode = (ConstructorNode)constructorNodeList.get(0);
        Parameter[] lambdaWrapperClassConstructorParameters = constructorNode.getParameters();
        mv.visitMethodInsn(183, lambdaWrapperClassInternalName, INIT, BytecodeHelper.getMethodDescriptor(ClassHelper.VOID_TYPE, lambdaWrapperClassConstructorParameters), lambdaWrapperClassNode.isInterface());
        OperandStack operandStack = this.controller.getOperandStack();
        operandStack.replace(ClassHelper.CLOSURE_TYPE, lambdaWrapperClassConstructorParameters.length);
    }

    private Parameter[] loadSharedVariables(MethodNode syntheticLambdaMethodNode) {
        Parameter[] lambdaSharedVariableParameters;
        for (Parameter parameter : lambdaSharedVariableParameters = (Parameter[])syntheticLambdaMethodNode.getNodeMetaData(LAMBDA_SHARED_VARIABLES)) {
            String parameterName = parameter.getName();
            StaticTypesLambdaWriter.loadReference(parameterName, this.controller);
            if (parameter.getNodeMetaData(ClosureWriter.UseExistingReference.class) != null) continue;
            parameter.setNodeMetaData(ClosureWriter.UseExistingReference.class, Boolean.TRUE);
        }
        return lambdaSharedVariableParameters;
    }

    private String createAbstractMethodDesc(ClassNode parameterType, ClassNode lambdaClassNode) {
        LinkedList<Parameter> lambdaSharedVariableList = new LinkedList<Parameter>();
        this.prependEnclosingThis(lambdaSharedVariableList);
        this.prependParameter(lambdaSharedVariableList, LAMBDA_THIS, lambdaClassNode);
        return BytecodeHelper.getMethodDescriptor(parameterType.redirect(), lambdaSharedVariableList.toArray(Parameter.EMPTY_ARRAY));
    }

    private Handle createBootstrapMethod(boolean isInterface) {
        return new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", isInterface);
    }

    private Object[] createBootstrapMethodArguments(String abstractMethodDesc, ClassNode lambdaClassNode, MethodNode syntheticLambdaMethodNode) {
        return new Object[]{Type.getType(abstractMethodDesc), new Handle(5, lambdaClassNode.getName(), syntheticLambdaMethodNode.getName(), BytecodeHelper.getMethodDescriptor(syntheticLambdaMethodNode), lambdaClassNode.isInterface()), Type.getType(BytecodeHelper.getMethodDescriptor(syntheticLambdaMethodNode.getReturnType(), (Parameter[])syntheticLambdaMethodNode.getNodeMetaData(ORIGINAL_PARAMETERS_WITH_EXACT_TYPE)))};
    }

    private String createMethodDescriptor(MethodNode abstractMethodNode) {
        return BytecodeHelper.getMethodDescriptor(abstractMethodNode.getReturnType().getTypeClass(), (Class[])Arrays.stream(abstractMethodNode.getParameters()).map(e -> e.getType().getTypeClass()).toArray(Class[]::new));
    }

    public ClassNode getOrAddLambdaClass(LambdaExpression expression, int mods, MethodNode abstractMethodNode) {
        ClassNode lambdaClass = this.lambdaClassMap.get(expression);
        if (lambdaClass == null) {
            lambdaClass = this.createLambdaClass(expression, mods, abstractMethodNode);
            this.lambdaClassMap.put(expression, lambdaClass);
            this.controller.getAcg().addInnerClass(lambdaClass);
            lambdaClass.addInterface(ClassHelper.GENERATED_LAMBDA_TYPE);
            lambdaClass.putNodeMetaData(WriterControllerFactory.class, this.factory);
        }
        lambdaClass.putNodeMetaData((Object)StaticCompilationMetadataKeys.STATIC_COMPILE_NODE, Boolean.TRUE);
        return lambdaClass;
    }

    protected ClassNode createLambdaClass(LambdaExpression expression, int mods, MethodNode abstractMethodNode) {
        ClassNode outerClass = this.controller.getOutermostClass();
        ClassNode classNode = this.controller.getClassNode();
        String name = this.genLambdaClassName();
        boolean staticMethodOrInStaticClass = this.controller.isStaticMethod() || classNode.isStaticClass();
        InnerClassNode answer = new InnerClassNode(classNode, name, mods, ClassHelper.CLOSURE_TYPE.getPlainNodeReference());
        answer.setEnclosingMethod(this.controller.getMethodNode());
        answer.setSynthetic(true);
        answer.setUsingGenerics(outerClass.isUsingGenerics());
        answer.setSourcePosition(expression);
        if (staticMethodOrInStaticClass) {
            answer.setStaticClass(true);
        }
        if (this.controller.isInScriptBody()) {
            answer.setScriptBody(true);
        }
        MethodNode syntheticLambdaMethodNode = this.addSyntheticLambdaMethodNode(expression, answer, abstractMethodNode);
        Parameter[] localVariableParameters = (Parameter[])syntheticLambdaMethodNode.getNodeMetaData(LAMBDA_SHARED_VARIABLES);
        this.addFieldsAndGettersForLocalVariables(answer, localVariableParameters);
        ConstructorNode constructorNode = this.addConstructor(expression, localVariableParameters, answer, this.createBlockStatementForConstructor(expression));
        constructorNode.putNodeMetaData(IS_GENERATED_CONSTRUCTOR, Boolean.TRUE);
        Parameter enclosingThisParameter = syntheticLambdaMethodNode.getParameters()[0];
        new TransformationVisitor(answer, enclosingThisParameter).visitMethod(syntheticLambdaMethodNode);
        return answer;
    }

    private String genLambdaClassName() {
        ClassNode classNode = this.controller.getClassNode();
        ClassNode outerClass = this.controller.getOutermostClass();
        MethodNode methodNode = this.controller.getMethodNode();
        return classNode.getName() + "$" + this.controller.getContext().getNextLambdaInnerName(outerClass, classNode, methodNode);
    }

    private MethodNode addSyntheticLambdaMethodNode(LambdaExpression expression, InnerClassNode answer, MethodNode abstractMethodNode) {
        Parameter[] parametersWithExactType = this.createParametersWithExactType(expression);
        Parameter[] localVariableParameters = this.getLambdaSharedVariables(expression);
        StaticTypesLambdaWriter.removeInitialValues(localVariableParameters);
        LinkedList<Parameter> methodParameterList = new LinkedList<Parameter>(Arrays.asList(parametersWithExactType));
        this.prependEnclosingThis(methodParameterList);
        MethodNode methodNode = answer.addMethod(DO_CALL, 1, abstractMethodNode.getReturnType(), methodParameterList.toArray(Parameter.EMPTY_ARRAY), ClassNode.EMPTY_ARRAY, expression.getCode());
        methodNode.putNodeMetaData(ORIGINAL_PARAMETERS_WITH_EXACT_TYPE, parametersWithExactType);
        methodNode.putNodeMetaData(LAMBDA_SHARED_VARIABLES, localVariableParameters);
        methodNode.setSourcePosition(expression);
        return methodNode;
    }

    private Parameter prependEnclosingThis(List<Parameter> methodParameterList) {
        return this.prependParameter(methodParameterList, ENCLOSING_THIS, this.controller.getClassNode().getPlainNodeReference());
    }

    private Parameter prependParameter(List<Parameter> methodParameterList, String parameterName, ClassNode parameterType) {
        Parameter parameter = new Parameter(parameterType, parameterName);
        parameter.setOriginType(parameterType);
        parameter.setClosureSharedVariable(false);
        methodParameterList.add(0, parameter);
        return parameter;
    }

    private Parameter[] createParametersWithExactType(LambdaExpression expression) {
        Parameter[] parameters = expression.getParameters();
        if (parameters == null) {
            parameters = Parameter.EMPTY_ARRAY;
        }
        for (int i = 0; i < parameters.length; ++i) {
            ClassNode inferredType = (ClassNode)parameters[i].getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            if (null == inferredType) continue;
            parameters[i].setType(inferredType);
            parameters[i].setOriginType(inferredType);
        }
        return parameters;
    }

    @Override
    protected ClassNode createClosureClass(ClosureExpression expression, int mods) {
        return this.staticTypesClosureWriter.createClosureClass(expression, mods);
    }

    private static final class TransformationVisitor
    extends ClassCodeVisitorSupport {
        private ClosureWriter.CorrectAccessedVariableVisitor correctAccessedVariableVisitor;
        private Parameter enclosingThisParameter;

        public TransformationVisitor(InnerClassNode icn, Parameter enclosingThisParameter) {
            this.correctAccessedVariableVisitor = new ClosureWriter.CorrectAccessedVariableVisitor(icn);
            this.enclosingThisParameter = enclosingThisParameter;
        }

        @Override
        public void visitVariableExpression(VariableExpression expression) {
            this.correctAccessedVariableVisitor.visitVariableExpression(expression);
        }

        @Override
        public void visitMethodCallExpression(MethodCallExpression call) {
            VariableExpression originalObjectExpression;
            Expression objectExpression;
            if (!call.getMethodTarget().isStatic() && (objectExpression = call.getObjectExpression()) instanceof VariableExpression && null == (originalObjectExpression = (VariableExpression)objectExpression).getAccessedVariable()) {
                VariableExpression thisVariable = new VariableExpression(this.enclosingThisParameter);
                thisVariable.setSourcePosition(originalObjectExpression);
                call.setObjectExpression(thisVariable);
                call.setImplicitThis(false);
            }
            super.visitMethodCallExpression(call);
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return null;
        }
    }
}

