/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.PathParam;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.lib.AbstractBaseBean;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.OrgUnitTO;
import org.apache.syncope.common.lib.to.ProvisionTO;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.common.lib.types.ConnectorCapability;
import org.apache.syncope.common.lib.types.TraceLevel;

@XmlRootElement(name="resource")
@XmlType
public class ResourceTO
extends AbstractBaseBean
implements EntityTO {
    private static final long serialVersionUID = -9193551354041698963L;
    private String key;
    private String connector;
    private String connectorDisplayName;
    private final List<ProvisionTO> provisions = new ArrayList<ProvisionTO>();
    private OrgUnitTO orgUnit;
    private Integer propagationPriority;
    private boolean randomPwdIfNotProvided;
    private boolean enforceMandatoryCondition;
    private TraceLevel createTraceLevel = TraceLevel.ALL;
    private TraceLevel updateTraceLevel = TraceLevel.ALL;
    private TraceLevel deleteTraceLevel = TraceLevel.ALL;
    private TraceLevel provisioningTraceLevel = TraceLevel.ALL;
    private String passwordPolicy;
    private String accountPolicy;
    private String pullPolicy;
    private String pushPolicy;
    private final List<ConnConfProperty> confOverride = new ArrayList<ConnConfProperty>();
    private boolean overrideCapabilities = false;
    private final Set<ConnectorCapability> capabilitiesOverride = EnumSet.noneOf(ConnectorCapability.class);
    private final List<String> propagationActions = new ArrayList<String>();

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    @PathParam(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public boolean isEnforceMandatoryCondition() {
        return this.enforceMandatoryCondition;
    }

    public void setEnforceMandatoryCondition(boolean enforceMandatoryCondition) {
        this.enforceMandatoryCondition = enforceMandatoryCondition;
    }

    public String getConnector() {
        return this.connector;
    }

    public void setConnector(String connector) {
        this.connector = connector;
    }

    public String getConnectorDisplayName() {
        return this.connectorDisplayName;
    }

    public void setConnectorDisplayName(String connectorDisplayName) {
        this.connectorDisplayName = connectorDisplayName;
    }

    public Integer getPropagationPriority() {
        return this.propagationPriority;
    }

    public void setPropagationPriority(Integer propagationPriority) {
        this.propagationPriority = propagationPriority;
    }

    public boolean isRandomPwdIfNotProvided() {
        return this.randomPwdIfNotProvided;
    }

    public void setRandomPwdIfNotProvided(boolean randomPwdIfNotProvided) {
        this.randomPwdIfNotProvided = randomPwdIfNotProvided;
    }

    public TraceLevel getCreateTraceLevel() {
        return this.createTraceLevel;
    }

    public void setCreateTraceLevel(TraceLevel createTraceLevel) {
        this.createTraceLevel = createTraceLevel;
    }

    public TraceLevel getDeleteTraceLevel() {
        return this.deleteTraceLevel;
    }

    public void setDeleteTraceLevel(TraceLevel deleteTraceLevel) {
        this.deleteTraceLevel = deleteTraceLevel;
    }

    public TraceLevel getUpdateTraceLevel() {
        return this.updateTraceLevel;
    }

    public void setUpdateTraceLevel(TraceLevel updateTraceLevel) {
        this.updateTraceLevel = updateTraceLevel;
    }

    public String getPasswordPolicy() {
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(String passwordPolicy) {
        this.passwordPolicy = passwordPolicy;
    }

    public String getAccountPolicy() {
        return this.accountPolicy;
    }

    public void setAccountPolicy(String accountPolicy) {
        this.accountPolicy = accountPolicy;
    }

    public String getPullPolicy() {
        return this.pullPolicy;
    }

    public void setPullPolicy(String pullPolicy) {
        this.pullPolicy = pullPolicy;
    }

    public String getPushPolicy() {
        return this.pushPolicy;
    }

    public void setPushPolicy(String pushPolicy) {
        this.pushPolicy = pushPolicy;
    }

    @JsonIgnore
    public Optional<ProvisionTO> getProvision(String anyType) {
        return this.provisions.stream().filter(provision -> anyType != null && anyType.equals(provision.getAnyType())).findFirst();
    }

    @XmlElementWrapper(name="provisions")
    @XmlElement(name="provision")
    @JsonProperty(value="provisions")
    public List<ProvisionTO> getProvisions() {
        return this.provisions;
    }

    public OrgUnitTO getOrgUnit() {
        return this.orgUnit;
    }

    public void setOrgUnit(OrgUnitTO orgUnit) {
        this.orgUnit = orgUnit;
    }

    @XmlElementWrapper(name="confOverride")
    @XmlElement(name="property")
    @JsonProperty(value="confOverride")
    public List<ConnConfProperty> getConfOverride() {
        return this.confOverride;
    }

    public boolean isOverrideCapabilities() {
        return this.overrideCapabilities;
    }

    public void setOverrideCapabilities(boolean overrideCapabilities) {
        this.overrideCapabilities = overrideCapabilities;
    }

    @XmlElementWrapper(name="capabilitiesOverride")
    @XmlElement(name="capability")
    @JsonProperty(value="capabilitiesOverride")
    public Set<ConnectorCapability> getCapabilitiesOverride() {
        return this.capabilitiesOverride;
    }

    public TraceLevel getProvisioningTraceLevel() {
        return this.provisioningTraceLevel;
    }

    public void setProvisioningTraceLevel(TraceLevel provisioningTraceLevel) {
        this.provisioningTraceLevel = provisioningTraceLevel;
    }

    @XmlElementWrapper(name="propagationActions")
    @XmlElement(name="propagationAction")
    @JsonProperty(value="propagationActions")
    public List<String> getPropagationActions() {
        return this.propagationActions;
    }
}

