/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.resource.Mapping;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnit;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.api.data.JEXLItemTransformer;
import org.apache.syncope.core.provisioning.java.data.JEXLItemTransformerImpl;
import org.apache.syncope.core.provisioning.java.jexl.JexlUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.ImplementationManager;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MappingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MappingUtils.class);

    public static Optional<? extends MappingItem> getConnObjectKeyItem(Provision provision) {
        Mapping mapping = null;
        if (provision != null) {
            mapping = provision.getMapping();
        }
        return mapping == null ? Optional.empty() : mapping.getConnObjectKeyItem();
    }

    public static List<? extends Item> getPropagationItems(List<? extends Item> items) {
        return items.stream().filter(item -> item.getPurpose() == MappingPurpose.PROPAGATION || item.getPurpose() == MappingPurpose.BOTH).collect(Collectors.toList());
    }

    public static List<? extends Item> getPullItems(List<? extends Item> items) {
        return items.stream().filter(item -> item.getPurpose() == MappingPurpose.PULL || item.getPurpose() == MappingPurpose.BOTH).collect(Collectors.toList());
    }

    private static Name getName(String evalConnObjectLink, String connObjectKey) {
        Name name;
        if (StringUtils.isBlank((CharSequence)evalConnObjectLink)) {
            LOG.debug("Add connObjectKey [{}] as __NAME__", (Object)connObjectKey);
            name = new Name(connObjectKey);
        } else {
            LOG.debug("Add connObjectLink [{}] as __NAME__", (Object)evalConnObjectLink);
            name = new Name(evalConnObjectLink);
            LOG.debug("connObjectKey will be used just as __UID__ attribute");
        }
        return name;
    }

    public static Name evaluateNAME(Any<?> any, Provision provision, String connObjectKey) {
        if (StringUtils.isBlank((CharSequence)connObjectKey)) {
            LOG.warn("Missing ConnObjectKey value for {}: ", (Object)provision.getResource());
        }
        String connObjectLink = provision == null || provision.getMapping() == null ? null : provision.getMapping().getConnObjectLink();
        String evalConnObjectLink = null;
        if (StringUtils.isNotBlank((CharSequence)connObjectLink)) {
            MapContext jexlContext = new MapContext();
            JexlUtils.addFieldsToContext(any, (JexlContext)jexlContext);
            JexlUtils.addPlainAttrsToContext(any.getPlainAttrs(), (JexlContext)jexlContext);
            JexlUtils.addDerAttrsToContext(any, (JexlContext)jexlContext);
            evalConnObjectLink = JexlUtils.evaluate(connObjectLink, (JexlContext)jexlContext);
        }
        return MappingUtils.getName(evalConnObjectLink, connObjectKey);
    }

    public static Name evaluateNAME(Realm realm, OrgUnit orgUnit, String connObjectKey) {
        if (StringUtils.isBlank((CharSequence)connObjectKey)) {
            LOG.warn("Missing ConnObjectKey value for {}: ", (Object)orgUnit.getResource());
        }
        String connObjectLink = orgUnit == null ? null : orgUnit.getConnObjectLink();
        String evalConnObjectLink = null;
        if (StringUtils.isNotBlank((CharSequence)connObjectLink)) {
            MapContext jexlContext = new MapContext();
            JexlUtils.addFieldsToContext(realm, (JexlContext)jexlContext);
            evalConnObjectLink = JexlUtils.evaluate(connObjectLink, (JexlContext)jexlContext);
        }
        return MappingUtils.getName(evalConnObjectLink, connObjectKey);
    }

    public static List<ItemTransformer> getItemTransformers(Item item) {
        ArrayList<ItemTransformer> result = new ArrayList<ItemTransformer>();
        if (StringUtils.isNotBlank((CharSequence)item.getPropagationJEXLTransformer()) || StringUtils.isNotBlank((CharSequence)item.getPullJEXLTransformer())) {
            JEXLItemTransformer jexlTransformer = (JEXLItemTransformer)ApplicationContextProvider.getBeanFactory().createBean(JEXLItemTransformerImpl.class, 1, false);
            jexlTransformer.setPropagationJEXL(item.getPropagationJEXLTransformer());
            jexlTransformer.setPullJEXL(item.getPullJEXLTransformer());
            result.add((ItemTransformer)jexlTransformer);
        }
        item.getTransformers().forEach(impl -> {
            try {
                result.add((ItemTransformer)ImplementationManager.build((Implementation)impl));
            }
            catch (Exception e) {
                LOG.error("While building {}", impl, (Object)e);
            }
        });
        return result;
    }

    public static OperationOptions buildOperationOptions(Iterator<? extends Item> iterator) {
        OperationOptionsBuilder builder = new OperationOptionsBuilder();
        HashSet<String> attrsToGet = new HashSet<String>();
        attrsToGet.add(Name.NAME);
        attrsToGet.add(Uid.NAME);
        attrsToGet.add(OperationalAttributes.ENABLE_NAME);
        while (iterator.hasNext()) {
            Item item = iterator.next();
            if (item.getPurpose() == MappingPurpose.NONE) continue;
            attrsToGet.add(item.getExtAttrName());
        }
        builder.setAttributesToGet(attrsToGet);
        return builder.build();
    }

    private MappingUtils() {
    }
}

