/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.core.persistence.api.dao.PushCorrelationRule;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.policy.PushCorrelationRuleEntity;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.TimeoutException;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.ImplementationManager;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Component
public class PushUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PushUtils.class);
    @Autowired
    private MappingManager mappingManager;

    public List<ConnectorObject> match(Connector connector, Any<?> any, Provision provision) {
        Optional correlationRule = provision.getResource().getPushPolicy() == null ? Optional.empty() : provision.getResource().getPushPolicy().getCorrelationRule(provision.getAnyType());
        Optional rule = Optional.empty();
        if (correlationRule.isPresent()) {
            try {
                rule = ImplementationManager.buildPushCorrelationRule((Implementation)((PushCorrelationRuleEntity)correlationRule.get()).getImplementation());
            }
            catch (Exception e) {
                LOG.error("While building {}", (Object)((PushCorrelationRuleEntity)correlationRule.get()).getImplementation(), (Object)e);
            }
        }
        try {
            return rule.isPresent() ? this.findByCorrelationRule(connector, any, provision, (PushCorrelationRule)rule.get()) : this.findByConnObjectKey(connector, any, provision);
        }
        catch (RuntimeException e) {
            LOG.error("Could not match {} with any existing {}", new Object[]{any, provision.getObjectClass(), e});
            return Collections.emptyList();
        }
    }

    private List<ConnectorObject> findByCorrelationRule(Connector connector, Any<?> any, Provision provision, PushCorrelationRule rule) {
        ArrayList<ConnectorObject> objs = new ArrayList<ConnectorObject>();
        try {
            connector.search(provision.getObjectClass(), rule.getFilter(any, provision), obj -> {
                objs.add(obj);
                return true;
            }, MappingUtils.buildOperationOptions(provision.getMapping().getItems().iterator()));
        }
        catch (TimeoutException toe) {
            LOG.debug("Request timeout", (Throwable)toe);
            throw toe;
        }
        catch (RuntimeException ignore) {
            LOG.debug("Unexpected exception", (Throwable)ignore);
        }
        return objs;
    }

    public List<ConnectorObject> findByConnObjectKey(Connector connector, Any<?> any, Provision provision) {
        Optional<? extends MappingItem> connObjectKey = MappingUtils.getConnObjectKeyItem(provision);
        Optional connObjectKeyValue = this.mappingManager.getConnObjectKeyValue(any, provision);
        ConnectorObject obj = null;
        if (connObjectKey.isPresent() && connObjectKeyValue.isPresent()) {
            try {
                obj = connector.getObject(provision.getObjectClass(), AttributeBuilder.build((String)connObjectKey.get().getExtAttrName(), (Object[])new Object[]{connObjectKeyValue.get()}), provision.isIgnoreCaseMatch(), MappingUtils.buildOperationOptions(provision.getMapping().getItems().iterator()));
            }
            catch (TimeoutException toe) {
                LOG.debug("Request timeout", (Throwable)toe);
                throw toe;
            }
            catch (RuntimeException ignore) {
                LOG.debug("While resolving {}", connObjectKeyValue.get(), (Object)ignore);
            }
        }
        return obj == null ? Collections.emptyList() : Collections.singletonList(obj);
    }
}

