/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskCallable;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.java.propagation.AbstractPropagationTaskExecutor;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationTaskCallable;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class PriorityPropagationTaskExecutor
extends AbstractPropagationTaskExecutor {
    @Resource(name="propagationTaskExecutorAsyncExecutor")
    protected ThreadPoolTaskExecutor executor;

    protected PropagationTaskCallable newPropagationTaskCallable(PropagationTaskTO taskTO, PropagationReporter reporter) {
        PropagationTaskCallable callable = (PropagationTaskCallable)ApplicationContextProvider.getBeanFactory().createBean(DefaultPropagationTaskCallable.class, 2, false);
        callable.setExecutor((PropagationTaskExecutor)this);
        callable.setTaskTO(taskTO);
        callable.setReporter(reporter);
        return callable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(Collection<PropagationTaskTO> tasks, PropagationReporter reporter, boolean nullPriorityAsync) {
        Map<PropagationTaskTO, ExternalResource> taskToResource = tasks.stream().collect(Collectors.toMap(Function.identity(), task -> this.resourceDAO.find(task.getResource())));
        List<PropagationTaskTO> prioritizedTasks = tasks.stream().filter(task -> ((ExternalResource)taskToResource.get(task)).getPropagationPriority() != null).collect(Collectors.toList());
        Collections.sort(prioritizedTasks, new PriorityComparator(taskToResource));
        LOG.debug("Propagation tasks sorted by priority, for serial execution: {}", prioritizedTasks);
        Collection concurrentTasks = tasks.stream().filter(task -> !prioritizedTasks.contains(task)).collect(Collectors.toSet());
        LOG.debug("Propagation tasks for concurrent execution: {}", (Object)concurrentTasks);
        prioritizedTasks.forEach(task -> {
            ExecStatus execStatus;
            TaskExec execution = null;
            try {
                execution = (TaskExec)this.newPropagationTaskCallable((PropagationTaskTO)task, reporter).call();
                execStatus = ExecStatus.valueOf((String)execution.getStatus());
            }
            catch (Exception e) {
                LOG.error("Unexpected exception", (Throwable)e);
                execStatus = ExecStatus.FAILURE;
            }
            if (execStatus != ExecStatus.SUCCESS) {
                throw new PropagationException(task.getResource(), execution == null ? null : execution.getMessage());
            }
        });
        ExecutorCompletionService completionService = new ExecutorCompletionService((Executor)this.executor);
        HashMap<PropagationTaskTO, Future> nullPriority = new HashMap<PropagationTaskTO, Future>(concurrentTasks.size());
        concurrentTasks.forEach(task -> {
            try {
                nullPriority.put((PropagationTaskTO)task, completionService.submit(this.newPropagationTaskCallable((PropagationTaskTO)task, reporter)));
            }
            catch (Exception e) {
                LOG.error("Unexpected exception", (Throwable)e);
            }
        });
        if (!nullPriority.isEmpty()) {
            if (nullPriorityAsync) {
                nullPriority.forEach((task, exec) -> reporter.onSuccessOrNonPriorityResourceFailures(task, ExecStatus.CREATED, null, null, null));
            } else {
                HashSet nullPriorityFutures = new HashSet(nullPriority.values());
                try {
                    this.executor.submit(() -> {
                        while (!nullPriorityFutures.isEmpty()) {
                            try {
                                nullPriorityFutures.remove(completionService.take());
                            }
                            catch (Exception e) {
                                LOG.error("Unexpected exception", (Throwable)e);
                            }
                        }
                    }).get(60L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    LOG.error("Unexpected exception", (Throwable)e);
                }
                finally {
                    nullPriorityFutures.forEach(future -> future.cancel(true));
                    nullPriorityFutures.clear();
                    nullPriority.clear();
                }
            }
        }
    }

    protected static class PriorityComparator
    implements Comparator<PropagationTaskTO>,
    Serializable {
        private static final long serialVersionUID = -1969355670784448878L;
        private final Map<PropagationTaskTO, ExternalResource> taskToResource;

        public PriorityComparator(Map<PropagationTaskTO, ExternalResource> taskToResource) {
            this.taskToResource = taskToResource;
        }

        @Override
        public int compare(PropagationTaskTO task1, PropagationTaskTO task2) {
            int prop2;
            int prop1 = this.taskToResource.get(task1).getPropagationPriority();
            return prop1 > (prop2 = this.taskToResource.get(task2).getPropagationPriority().intValue()) ? 1 : (prop1 == prop2 ? 0 : -1);
        }
    }
}

