/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.collections.IteratorChain;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.TraceLevel;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnit;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnitItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorFactory;
import org.apache.syncope.core.provisioning.api.TimeoutException;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCache;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCacheValue;
import org.apache.syncope.core.provisioning.api.data.TaskDataBinder;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.provisioning.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationReporter;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.ImplementationManager;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public abstract class AbstractPropagationTaskExecutor
implements PropagationTaskExecutor {
    protected static final Logger LOG = LoggerFactory.getLogger(PropagationTaskExecutor.class);
    @Autowired
    protected ConnectorFactory connFactory;
    @Autowired
    protected ConnObjectUtils connObjectUtils;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;
    @Autowired
    protected TaskDAO taskDAO;
    @Autowired
    protected ExternalResourceDAO resourceDAO;
    @Autowired
    protected VirSchemaDAO virSchemaDAO;
    @Autowired
    protected NotificationManager notificationManager;
    @Autowired
    protected AuditManager auditManager;
    @Autowired
    protected TaskDataBinder taskDataBinder;
    @Autowired
    protected AnyUtilsFactory anyUtilsFactory;
    @Autowired
    protected TaskUtilsFactory taskUtilsFactory;
    @Autowired
    protected EntityFactory entityFactory;
    @Autowired
    protected VirAttrCache virAttrCache;

    public TaskExec execute(PropagationTaskTO task) {
        return this.execute(task, null);
    }

    protected List<PropagationActions> getPropagationActions(ExternalResource resource) {
        ArrayList<PropagationActions> result = new ArrayList<PropagationActions>();
        resource.getPropagationActions().forEach(impl -> {
            try {
                result.add((PropagationActions)ImplementationManager.build((Implementation)impl));
            }
            catch (Exception e) {
                LOG.error("While building {}", impl, (Object)e);
            }
        });
        return result;
    }

    protected Uid createOrUpdate(PropagationTask task, ConnectorObject beforeObj, Connector connector, AtomicReference<Boolean> propagationAttempted) {
        Uid result;
        Attribute mandatoryNullOrEmpty;
        HashSet attributes = new HashSet(task.getAttributes());
        HashSet mandatoryAttrNames = new HashSet();
        Attribute mandatoryMissing = AttributeUtil.find((String)"__MANDATORY_MISSING__", (Set)task.getAttributes());
        if (mandatoryMissing != null) {
            attributes.remove(mandatoryMissing);
            if (beforeObj == null) {
                mandatoryAttrNames.addAll(mandatoryMissing.getValue());
            }
        }
        if ((mandatoryNullOrEmpty = AttributeUtil.find((String)"__MANDATORY_NULL_OR_EMPTY__", (Set)task.getAttributes())) != null) {
            attributes.remove(mandatoryNullOrEmpty);
            mandatoryAttrNames.addAll(mandatoryNullOrEmpty.getValue());
        }
        if (!mandatoryAttrNames.isEmpty()) {
            throw new IllegalArgumentException("Not attempted because there are mandatory attributes without value(s): " + mandatoryAttrNames);
        }
        if (beforeObj == null) {
            LOG.debug("Create {} on {}", attributes, (Object)task.getResource().getKey());
            result = connector.create(new ObjectClass(task.getObjectClassName()), attributes, null, propagationAttempted);
            task.getResource().getProvision(task.getAnyType()).ifPresent(provision -> {
                if (provision.getUidOnCreate() != null) {
                    this.anyUtilsFactory.getInstance(task.getAnyTypeKind()).addAttr(task.getEntityKey(), provision.getUidOnCreate(), result.getUidValue());
                }
            });
        } else {
            Name newName = AttributeUtil.getNameFromAttributes(attributes);
            LOG.debug("Rename required with value {}", (Object)newName);
            if (newName != null && newName.equals((Object)beforeObj.getName()) && !newName.getNameValue().equals(beforeObj.getUid().getUidValue())) {
                LOG.debug("Remote object name unchanged");
                attributes.remove(newName);
            }
            Map<String, Attribute> originalAttrMap = beforeObj.getAttributes().stream().collect(Collectors.toMap(attr -> attr.getName().toUpperCase(), attr -> attr));
            Map<String, Attribute> updateAttrMap = attributes.stream().collect(Collectors.toMap(attr -> attr.getName().toUpperCase(), attr -> attr));
            Set<String> skipAttrNames = originalAttrMap.keySet();
            skipAttrNames.removeAll(updateAttrMap.keySet());
            new HashSet<String>(skipAttrNames).forEach(attrName -> originalAttrMap.remove(attrName));
            HashSet<Attribute> originalAttrs = new HashSet<Attribute>(originalAttrMap.values());
            if (originalAttrs.equals(attributes)) {
                LOG.debug("Don't need to propagate anything: {} is equal to {}", originalAttrs, attributes);
                result = AttributeUtil.getUidAttribute(attributes);
            } else {
                LOG.debug("Attributes that would be updated {}", attributes);
                HashSet strictlyModified = new HashSet();
                attributes.stream().filter(attr -> !originalAttrs.contains(attr)).forEachOrdered(attr -> strictlyModified.add(attr));
                LOG.debug("Update {} on {}", strictlyModified, (Object)task.getResource().getKey());
                result = connector.update(beforeObj.getObjectClass(), new Uid(beforeObj.getUid().getUidValue()), strictlyModified, null, propagationAttempted);
            }
        }
        return result;
    }

    protected Uid delete(PropagationTask task, ConnectorObject beforeObj, Connector connector, AtomicReference<Boolean> propagationAttempted) {
        Uid result;
        if (beforeObj == null) {
            LOG.debug("{} not found on external resource: ignoring delete", (Object)task.getConnObjectKey());
            result = null;
        } else {
            Collection<Object> resources = Collections.emptySet();
            if (task.getEntityKey() != null && task.getAnyTypeKind() != null) {
                switch (task.getAnyTypeKind()) {
                    case USER: {
                        try {
                            resources = this.userDAO.findAllResourceKeys(task.getEntityKey());
                        }
                        catch (Exception e) {
                            LOG.error("Could not read user {}", (Object)task.getEntityKey(), (Object)e);
                        }
                        break;
                    }
                    case GROUP: {
                        try {
                            resources = this.groupDAO.findAllResourceKeys(task.getEntityKey());
                        }
                        catch (Exception e) {
                            LOG.error("Could not read group {}", (Object)task.getEntityKey(), (Object)e);
                        }
                        break;
                    }
                    default: {
                        try {
                            resources = this.anyObjectDAO.findAllResourceKeys(task.getEntityKey());
                            break;
                        }
                        catch (Exception e) {
                            LOG.error("Could not read any object {}", (Object)task.getEntityKey(), (Object)e);
                        }
                    }
                }
            }
            if (task.getAnyTypeKind() == null || !resources.contains(task.getResource().getKey())) {
                LOG.debug("Delete {} on {}", (Object)beforeObj.getUid(), (Object)task.getResource().getKey());
                connector.delete(beforeObj.getObjectClass(), beforeObj.getUid(), null, propagationAttempted);
                result = beforeObj.getUid();
            } else {
                result = this.createOrUpdate(task, beforeObj, connector, propagationAttempted);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected TaskExec execute(PropagationTaskTO taskTO, PropagationReporter reporter) {
        AuditElements.Result result;
        ConnectorObject afterObj;
        ConnectorObject beforeObj;
        TaskExec execution;
        String resource;
        List<PropagationActions> actions;
        PropagationTask task;
        block39: {
            Connector connector;
            Uid uid;
            OrgUnit orgUnit;
            Provision provision;
            AtomicReference<Boolean> propagationAttempted;
            String failureReason;
            String taskExecutionMessage;
            Date start;
            block35: {
                block36: {
                    if (taskTO.getKey() == null) {
                        task = (PropagationTask)this.entityFactory.newEntity(PropagationTask.class);
                        task.setResource(this.resourceDAO.find(taskTO.getResource()));
                        task.setObjectClassName(taskTO.getObjectClassName());
                        task.setAnyTypeKind(taskTO.getAnyTypeKind());
                        task.setAnyType(taskTO.getAnyType());
                        task.setEntityKey(taskTO.getEntityKey());
                        task.setOperation(taskTO.getOperation());
                        task.setConnObjectKey(taskTO.getConnObjectKey());
                        task.setOldConnObjectKey(taskTO.getOldConnObjectKey());
                    } else {
                        task = (PropagationTask)this.taskDAO.find(taskTO.getKey());
                    }
                    HashSet<Object> attributes = new HashSet<Object>();
                    if (StringUtils.isNotBlank((CharSequence)taskTO.getAttributes())) {
                        attributes.addAll(Arrays.asList((Object[])POJOHelper.deserialize((String)taskTO.getAttributes(), Attribute[].class)));
                    }
                    task.setAttributes(attributes);
                    actions = this.getPropagationActions(task.getResource());
                    resource = task.getResource().getKey();
                    start = new Date();
                    execution = (TaskExec)this.entityFactory.newEntity(TaskExec.class);
                    execution.setStatus(ExecStatus.CREATED.name());
                    taskExecutionMessage = null;
                    failureReason = null;
                    propagationAttempted = new AtomicReference<Boolean>(false);
                    beforeObj = null;
                    afterObj = null;
                    provision = null;
                    orgUnit = null;
                    uid = null;
                    connector = null;
                    provision = task.getResource().getProvision(new ObjectClass(task.getObjectClassName())).orElse(null);
                    orgUnit = task.getResource().getOrgUnit();
                    connector = this.connFactory.getConnector(task.getResource());
                    beforeObj = provision == null && orgUnit == null ? null : (orgUnit == null ? this.getRemoteObject(task, connector, provision, false) : this.getRemoteObject(task, connector, orgUnit, false));
                    for (PropagationActions action2 : actions) {
                        action2.before(task, beforeObj);
                    }
                    switch (task.getOperation()) {
                        case CREATE: 
                        case UPDATE: {
                            uid = this.createOrUpdate(task, beforeObj, connector, propagationAttempted);
                            break;
                        }
                        case DELETE: {
                            uid = this.delete(task, beforeObj, connector, propagationAttempted);
                            break;
                        }
                    }
                    execution.setStatus(propagationAttempted.get() != false ? ExecStatus.SUCCESS.name() : ExecStatus.NOT_ATTEMPTED.name());
                    LOG.debug("Successfully propagated to {}", (Object)task.getResource());
                    result = AuditElements.Result.SUCCESS;
                    if (connector == null) break block35;
                    if (uid == null) break block36;
                    task.setConnObjectKey(uid.getUidValue());
                }
                try {
                    afterObj = provision == null && orgUnit == null ? null : (orgUnit == null ? this.getRemoteObject(task, connector, provision, true) : this.getRemoteObject(task, connector, orgUnit, true));
                }
                catch (Exception ignore) {
                    LOG.error("Error retrieving after object", (Throwable)ignore);
                }
            }
            if (task.getOperation() != ResourceOperation.DELETE && afterObj == null && uid != null) {
                afterObj = new ConnectorObjectBuilder().setObjectClass(new ObjectClass(task.getObjectClassName())).setUid(uid).setName(AttributeUtil.getNameFromAttributes((Set)task.getAttributes())).build();
            }
            execution.setStart(start);
            execution.setMessage(taskExecutionMessage);
            execution.setEnd(new Date());
            LOG.debug("Execution finished: {}", (Object)execution);
            if (this.hasToBeregistered(task, execution)) {
                LOG.debug("Execution to be stored: {}", (Object)execution);
                execution.setTask((Task)task);
                task.add(execution);
                this.taskDAO.save((Task)task);
                this.taskDAO.flush();
            }
            if (reporter != null) {
                reporter.onSuccessOrNonPriorityResourceFailures(taskTO, ExecStatus.valueOf((String)execution.getStatus()), failureReason, beforeObj, afterObj);
            }
            break block39;
            catch (Exception e) {
                block37: {
                    block38: {
                        try {
                            result = AuditElements.Result.FAILURE;
                            LOG.error("Exception during provision on resource " + resource, (Throwable)e);
                            if (e instanceof ConnectorException && e.getCause() != null) {
                                taskExecutionMessage = e.getCause().getMessage();
                                failureReason = e.getCause().getMessage() == null ? e.getMessage() : e.getMessage() + "\n\n Cause: " + e.getCause().getMessage().split("\n")[0];
                            } else {
                                taskExecutionMessage = ExceptionUtils2.getFullStackTrace((Throwable)e);
                                failureReason = e.getCause() == null ? e.getMessage() : e.getMessage() + "\n\n Cause: " + e.getCause().getMessage().split("\n")[0];
                            }
                            try {
                                execution.setStatus(ExecStatus.FAILURE.name());
                            }
                            catch (Exception wft) {
                                LOG.error("While executing KO action on {}", (Object)execution, (Object)wft);
                            }
                            propagationAttempted.set(true);
                            actions.forEach(action -> action.onError(task, execution, e));
                            if (connector == null) break block37;
                            if (uid == null) break block38;
                        }
                        catch (Throwable throwable) {
                            if (connector != null) {
                                if (uid != null) {
                                    task.setConnObjectKey(uid.getUidValue());
                                }
                                try {
                                    afterObj = provision == null && orgUnit == null ? null : (orgUnit == null ? this.getRemoteObject(task, connector, provision, true) : this.getRemoteObject(task, connector, orgUnit, true));
                                }
                                catch (Exception ignore) {
                                    LOG.error("Error retrieving after object", (Throwable)ignore);
                                }
                            }
                            if (task.getOperation() != ResourceOperation.DELETE && afterObj == null && uid != null) {
                                afterObj = new ConnectorObjectBuilder().setObjectClass(new ObjectClass(task.getObjectClassName())).setUid(uid).setName(AttributeUtil.getNameFromAttributes((Set)task.getAttributes())).build();
                            }
                            execution.setStart(start);
                            execution.setMessage(taskExecutionMessage);
                            execution.setEnd(new Date());
                            LOG.debug("Execution finished: {}", (Object)execution);
                            if (this.hasToBeregistered(task, execution)) {
                                LOG.debug("Execution to be stored: {}", (Object)execution);
                                execution.setTask((Task)task);
                                task.add(execution);
                                this.taskDAO.save((Task)task);
                                this.taskDAO.flush();
                            }
                            if (reporter != null) {
                                reporter.onSuccessOrNonPriorityResourceFailures(taskTO, ExecStatus.valueOf((String)execution.getStatus()), failureReason, beforeObj, afterObj);
                            }
                            throw throwable;
                        }
                        task.setConnObjectKey(uid.getUidValue());
                    }
                    try {
                        afterObj = provision == null && orgUnit == null ? null : (orgUnit == null ? this.getRemoteObject(task, connector, provision, true) : this.getRemoteObject(task, connector, orgUnit, true));
                    }
                    catch (Exception ignore) {
                        LOG.error("Error retrieving after object", (Throwable)ignore);
                    }
                }
                if (task.getOperation() != ResourceOperation.DELETE && afterObj == null && uid != null) {
                    afterObj = new ConnectorObjectBuilder().setObjectClass(new ObjectClass(task.getObjectClassName())).setUid(uid).setName(AttributeUtil.getNameFromAttributes((Set)task.getAttributes())).build();
                }
                execution.setStart(start);
                execution.setMessage(taskExecutionMessage);
                execution.setEnd(new Date());
                LOG.debug("Execution finished: {}", (Object)execution);
                if (this.hasToBeregistered(task, execution)) {
                    LOG.debug("Execution to be stored: {}", (Object)execution);
                    execution.setTask((Task)task);
                    task.add(execution);
                    this.taskDAO.save((Task)task);
                    this.taskDAO.flush();
                }
                if (reporter != null) {
                    reporter.onSuccessOrNonPriorityResourceFailures(taskTO, ExecStatus.valueOf((String)execution.getStatus()), failureReason, beforeObj, afterObj);
                }
            }
        }
        for (PropagationActions action2 : actions) {
            action2.after(task, execution, afterObj);
        }
        String anyTypeKind = task.getAnyTypeKind() == null ? "realm" : task.getAnyTypeKind().name().toLowerCase();
        String operation = task.getOperation().name().toLowerCase();
        boolean notificationsAvailable = this.notificationManager.notificationsAvailable(AuditElements.EventCategoryType.PROPAGATION, anyTypeKind, resource, operation);
        boolean auditRequested = this.auditManager.auditRequested(AuditElements.EventCategoryType.PROPAGATION, anyTypeKind, resource, operation);
        if (notificationsAvailable || auditRequested) {
            ExecTO execTO = this.taskDataBinder.getExecTO(execution);
            this.notificationManager.createTasks(AuditElements.EventCategoryType.PROPAGATION, anyTypeKind, resource, operation, result, (Object)beforeObj, (Object)new Object[]{execTO, afterObj}, new Object[]{taskTO});
            this.auditManager.audit(AuditElements.EventCategoryType.PROPAGATION, anyTypeKind, resource, operation, result, (Object)beforeObj, (Object)new Object[]{execTO, afterObj}, new Object[]{taskTO});
        }
        return execution;
    }

    protected abstract void doExecute(Collection<PropagationTaskTO> var1, PropagationReporter var2, boolean var3);

    public PropagationReporter execute(Collection<PropagationTaskTO> tasks, boolean nullPriorityAsync) {
        DefaultPropagationReporter reporter = new DefaultPropagationReporter();
        try {
            this.doExecute(tasks, reporter, nullPriorityAsync);
        }
        catch (PropagationException e) {
            LOG.error("Error propagation priority resource", (Throwable)e);
            reporter.onPriorityResourceFailure(e.getResourceName(), tasks);
        }
        return reporter;
    }

    protected boolean hasToBeregistered(PropagationTask task, TaskExec execution) {
        boolean result;
        boolean failed = ExecStatus.valueOf((String)execution.getStatus()) != ExecStatus.SUCCESS;
        switch (task.getOperation()) {
            case CREATE: {
                result = failed && task.getResource().getCreateTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || task.getResource().getCreateTraceLevel() == TraceLevel.ALL;
                break;
            }
            case UPDATE: {
                result = failed && task.getResource().getUpdateTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || task.getResource().getUpdateTraceLevel() == TraceLevel.ALL;
                break;
            }
            case DELETE: {
                result = failed && task.getResource().getDeleteTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || task.getResource().getDeleteTraceLevel() == TraceLevel.ALL;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    protected ConnectorObject getRemoteObject(PropagationTask task, Connector connector, Provision provision, boolean latest) {
        String connObjectKey = latest || task.getOldConnObjectKey() == null ? task.getConnObjectKey() : task.getOldConnObjectKey();
        Set linkingMappingItems = this.virSchemaDAO.findByProvision(provision).stream().map(schema -> schema.asLinkingMappingItem()).collect(Collectors.toSet());
        ConnectorObject obj = null;
        Optional<? extends MappingItem> connObjectKeyItem = MappingUtils.getConnObjectKeyItem(provision);
        if (connObjectKeyItem.isPresent()) {
            try {
                obj = connector.getObject(new ObjectClass(task.getObjectClassName()), AttributeBuilder.build((String)connObjectKeyItem.get().getExtAttrName(), (Object[])new Object[]{connObjectKey}), provision.isIgnoreCaseMatch(), MappingUtils.buildOperationOptions((Iterator<? extends Item>)new IteratorChain(MappingUtils.getPropagationItems(provision.getMapping().getItems()).iterator(), linkingMappingItems.iterator())));
                for (MappingItem item : linkingMappingItems) {
                    Attribute attr = obj.getAttributeByName(item.getExtAttrName());
                    if (attr == null) {
                        this.virAttrCache.expire(task.getAnyType(), task.getEntityKey(), item.getIntAttrName());
                        continue;
                    }
                    VirAttrCacheValue cacheValue = new VirAttrCacheValue();
                    cacheValue.setValues((Collection)attr.getValue());
                    this.virAttrCache.put(task.getAnyType(), task.getEntityKey(), item.getIntAttrName(), cacheValue);
                }
            }
            catch (TimeoutException toe) {
                LOG.debug("Request timeout", (Throwable)toe);
                throw toe;
            }
            catch (RuntimeException ignore) {
                LOG.debug("While resolving {}", (Object)connObjectKey, (Object)ignore);
            }
        }
        return obj;
    }

    protected ConnectorObject getRemoteObject(PropagationTask task, Connector connector, OrgUnit orgUnit, boolean latest) {
        String connObjectKey = latest || task.getOldConnObjectKey() == null ? task.getConnObjectKey() : task.getOldConnObjectKey();
        ConnectorObject obj = null;
        Optional connObjectKeyItem = orgUnit.getConnObjectKeyItem();
        if (connObjectKeyItem.isPresent()) {
            try {
                obj = connector.getObject(new ObjectClass(task.getObjectClassName()), AttributeBuilder.build((String)((OrgUnitItem)connObjectKeyItem.get()).getExtAttrName(), (Object[])new Object[]{connObjectKey}), orgUnit.isIgnoreCaseMatch(), MappingUtils.buildOperationOptions(MappingUtils.getPropagationItems(orgUnit.getItems()).iterator()));
            }
            catch (TimeoutException toe) {
                LOG.debug("Request timeout", (Throwable)toe);
                throw toe;
            }
            catch (RuntimeException ignore) {
                LOG.debug("While resolving {}", (Object)connObjectKey, (Object)ignore);
            }
        }
        return obj;
    }
}

