/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.MembershipPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.java.job.AbstractInterruptableJob;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SetUMembershipsJob
extends AbstractInterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(SetUMembershipsJob.class);
    public static final String MEMBERSHIPS_BEFORE_KEY = "membershipsBefore";
    public static final String MEMBERSHIPS_AFTER_KEY = "membershipsAfter";
    @Autowired
    private UserProvisioningManager userProvisioningManager;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            AuthContextUtils.execWithAuthContext((String)context.getMergedJobDataMap().getString("domain"), () -> {
                Map membershipsBefore = (Map)context.getMergedJobDataMap().get((Object)MEMBERSHIPS_BEFORE_KEY);
                LOG.debug("Memberships before pull (User -> Groups) {}", (Object)membershipsBefore);
                Map membershipsAfter = (Map)context.getMergedJobDataMap().get((Object)MEMBERSHIPS_AFTER_KEY);
                LOG.debug("Memberships after pull (User -> Groups) {}", (Object)membershipsAfter);
                ArrayList patches = new ArrayList();
                membershipsAfter.forEach((user, groups) -> {
                    UserPatch userPatch = new UserPatch();
                    userPatch.setKey(user);
                    patches.add(userPatch);
                    groups.forEach(group -> {
                        Set before = (Set)membershipsBefore.get(user);
                        if (before == null || !before.contains(group)) {
                            userPatch.getMemberships().add(((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.ADD_REPLACE)).group(group).build());
                        }
                    });
                });
                membershipsBefore.forEach((user, groups) -> {
                    UserPatch userPatch = patches.stream().filter(patch -> user.equals(patch.getKey())).findFirst().orElseGet(() -> {
                        UserPatch patch = new UserPatch();
                        patch.setKey(user);
                        patches.add(patch);
                        return patch;
                    });
                    groups.forEach(group -> {
                        Set after = (Set)membershipsAfter.get(user);
                        if (after == null || !after.contains(group)) {
                            userPatch.getMemberships().add(((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.DELETE)).group(group).build());
                        }
                    });
                });
                patches.stream().filter(patch -> !patch.isEmpty()).forEach(patch -> {
                    LOG.debug("About to update User {}", patch);
                    this.userProvisioningManager.update((AnyPatch)patch, true);
                });
                return null;
            });
        }
        catch (RuntimeException e) {
            LOG.error("While setting memberships", (Throwable)e);
            throw new JobExecutionException("While executing memberships", (Throwable)e);
        }
    }
}

