/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.util.Map;
import org.quartz.SchedulerContext;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;

public class AutowiringSpringBeanJobFactory
extends SpringBeanJobFactory
implements ApplicationContextAware {
    private transient AutowireCapableBeanFactory beanFactory;
    private String[] ignoredUnknownProperties;
    private SchedulerContext schedulerContext;

    public void setApplicationContext(ApplicationContext context) {
        this.beanFactory = context.getAutowireCapableBeanFactory();
    }

    public void setIgnoredUnknownProperties(String ... ignoredUnknownProperties) {
        String[] defensiveCopy = (String[])ignoredUnknownProperties.clone();
        super.setIgnoredUnknownProperties(defensiveCopy);
        this.ignoredUnknownProperties = defensiveCopy;
    }

    public void setSchedulerContext(SchedulerContext schedulerContext) {
        super.setSchedulerContext(schedulerContext);
        this.schedulerContext = schedulerContext;
    }

    protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
        Object job = this.beanFactory.getBean(bundle.getJobDetail().getKey().getName());
        if (this.isEligibleForPropertyPopulation(job)) {
            BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)job);
            MutablePropertyValues pvs = new MutablePropertyValues();
            if (this.schedulerContext != null) {
                pvs.addPropertyValues((Map)this.schedulerContext);
            }
            pvs.addPropertyValues((Map)bundle.getJobDetail().getJobDataMap());
            pvs.addPropertyValues((Map)bundle.getTrigger().getJobDataMap());
            if (this.ignoredUnknownProperties != null) {
                for (String propName : this.ignoredUnknownProperties) {
                    if (!pvs.contains(propName) || bw.isWritableProperty(propName)) continue;
                    pvs.removePropertyValue(propName);
                }
                bw.setPropertyValues((PropertyValues)pvs);
            } else {
                bw.setPropertyValues((PropertyValues)pvs, true);
            }
        }
        return job;
    }
}

