/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.RandomBasedGenerator;
import java.util.Map;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.java.job.AbstractInterruptableJob;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class AfterHandlingJob
extends AbstractInterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(AfterHandlingJob.class);
    private static final RandomBasedGenerator UUID_GENERATOR = Generators.randomBasedGenerator();
    @Autowired
    private NotificationManager notificationManager;
    @Autowired
    private AuditManager auditManager;

    public static void schedule(SchedulerFactoryBean scheduler, Map<String, Object> jobMap) {
        AfterHandlingJob jobInstance = (AfterHandlingJob)ApplicationContextProvider.getBeanFactory().createBean(AfterHandlingJob.class, 2, false);
        String jobName = AfterHandlingJob.class.getName() + UUID_GENERATOR.generate();
        jobMap.put("domain", AuthContextUtils.getDomain());
        ApplicationContextProvider.getBeanFactory().registerSingleton(jobName, (Object)jobInstance);
        JobBuilder jobDetailBuilder = JobBuilder.newJob(AfterHandlingJob.class).withIdentity(jobName).usingJobData(new JobDataMap(jobMap));
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(JobNamer.getTriggerName((String)jobName)).startNow();
        try {
            scheduler.getScheduler().scheduleJob(jobDetailBuilder.build(), triggerBuilder.build());
        }
        catch (SchedulerException e) {
            LOG.error("Could not schedule, aborting", (Throwable)e);
        }
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            AuthContextUtils.execWithAuthContext((String)context.getMergedJobDataMap().getString("domain"), () -> {
                this.notificationManager.createTasks((AfterHandlingEvent)context.getMergedJobDataMap().get((Object)"AfterHandlingEvent"));
                this.auditManager.audit((AfterHandlingEvent)context.getMergedJobDataMap().get((Object)"AfterHandlingEvent"));
                return null;
            });
        }
        catch (RuntimeException e) {
            throw new JobExecutionException("While handling notification / audit events", (Throwable)e);
        }
    }
}

