/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.AttrPatch;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.GroupablePlainAttr;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.user.SecurityQuestion;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.URelationship;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.java.data.AbstractAnyDataBinder;
import org.apache.syncope.core.spring.BeanUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Throwable.class})
public class UserDataBinderImpl
extends AbstractAnyDataBinder
implements UserDataBinder {
    private static final String[] IGNORE_PROPERTIES = new String[]{"type", "realm", "auxClasses", "roles", "dynRoles", "relationships", "memberships", "dynMemberships", "plainAttrs", "derAttrs", "virAttrs", "resources", "securityQuestion", "securityAnswer"};
    @Autowired
    private RoleDAO roleDAO;
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private SecurityQuestionDAO securityQuestionDAO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private AccessTokenDAO accessTokenDAO;
    @Resource(name="adminUser")
    private String adminUser;
    @Resource(name="anonymousUser")
    private String anonymousUser;

    @Transactional(readOnly=true)
    public UserTO returnUserTO(UserTO userTO) {
        if (!((Boolean)this.confDAO.find("return.password.value", (Object)false)).booleanValue()) {
            userTO.setPassword(null);
        }
        return userTO;
    }

    @Transactional(readOnly=true)
    public UserTO getAuthenticatedUserTO() {
        UserTO authUserTO;
        String authUsername = AuthContextUtils.getUsername();
        if (this.anonymousUser.equals(authUsername)) {
            authUserTO = new UserTO();
            authUserTO.setKey(null);
            authUserTO.setUsername(this.anonymousUser);
        } else if (this.adminUser.equals(authUsername)) {
            authUserTO = new UserTO();
            authUserTO.setKey(null);
            authUserTO.setUsername(this.adminUser);
        } else {
            User authUser = this.userDAO.findByUsername(authUsername);
            authUserTO = this.getUserTO(authUser, true);
        }
        return authUserTO;
    }

    private void setPassword(User user, String password, SyncopeClientCompositeException scce) {
        try {
            String algorithm = (String)this.confDAO.find("password.cipher.algorithm", (Object)CipherAlgorithm.AES.name());
            user.setPassword(password, CipherAlgorithm.valueOf((String)algorithm));
        }
        catch (IllegalArgumentException e) {
            SyncopeClientException invalidCiperAlgorithm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.NotFound);
            invalidCiperAlgorithm.getElements().add(e.getMessage());
            scce.addException(invalidCiperAlgorithm);
            throw scce;
        }
    }

    public void create(User user, UserTO userTO, boolean storePassword) {
        SecurityQuestion securityQuestion;
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        user.setUsername(userTO.getUsername());
        if (StringUtils.isBlank((CharSequence)userTO.getPassword()) || !storePassword) {
            LOG.debug("Password was not provided or not required to be stored");
        } else {
            this.setPassword(user, userTO.getPassword(), scce);
        }
        user.setMustChangePassword(userTO.isMustChangePassword());
        if (userTO.getSecurityQuestion() != null && (securityQuestion = this.securityQuestionDAO.find(userTO.getSecurityQuestion())) != null) {
            user.setSecurityQuestion(securityQuestion);
        }
        user.setSecurityAnswer(userTO.getSecurityAnswer());
        userTO.getRoles().forEach(roleKey -> {
            Role role = this.roleDAO.find(roleKey);
            if (role == null) {
                LOG.warn("Ignoring unknown role with id {}", roleKey);
            } else {
                user.add(role);
            }
        });
        Realm realm = this.realmDAO.findByFullPath(userTO.getRealm());
        if (realm == null) {
            SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            noRealm.getElements().add("Invalid or null realm specified: " + userTO.getRealm());
            scce.addException(noRealm);
        }
        user.setRealm(realm);
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(AnyTypeKind.USER);
        if (user.getRealm() != null) {
            userTO.getRelationships().forEach(relationshipTO -> {
                AnyObject otherEnd = (AnyObject)this.anyObjectDAO.find(relationshipTO.getOtherEndKey());
                if (otherEnd == null) {
                    LOG.debug("Ignoring invalid anyObject " + relationshipTO.getOtherEndKey());
                } else if (user.getRealm().getFullPath().startsWith(otherEnd.getRealm().getFullPath())) {
                    RelationshipType relationshipType = this.relationshipTypeDAO.find(relationshipTO.getType());
                    if (relationshipType == null) {
                        LOG.debug("Ignoring invalid relationship type {}", (Object)relationshipTO.getType());
                    } else {
                        URelationship relationship = (URelationship)this.entityFactory.newEntity(URelationship.class);
                        relationship.setType(relationshipType);
                        relationship.setRightEnd((Any)otherEnd);
                        relationship.setLeftEnd((Any)user);
                        user.add((Relationship)relationship);
                    }
                } else {
                    LOG.error("{} cannot be assigned to {}", (Object)otherEnd, (Object)user);
                    SyncopeClientException unassignabled = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                    unassignabled.getElements().add("Cannot be assigned: " + otherEnd);
                    scce.addException(unassignabled);
                }
            });
            userTO.getMemberships().forEach(membershipTO -> {
                Group group;
                Group group2 = group = membershipTO.getGroupKey() == null ? this.groupDAO.findByName(membershipTO.getGroupName()) : (Group)this.groupDAO.find(membershipTO.getGroupKey());
                if (group == null) {
                    LOG.debug("Ignoring invalid group " + membershipTO.getGroupKey() + " / " + membershipTO.getGroupName());
                } else if (user.getRealm().getFullPath().startsWith(group.getRealm().getFullPath())) {
                    UMembership membership = (UMembership)this.entityFactory.newEntity(UMembership.class);
                    membership.setRightEnd((Any)group);
                    membership.setLeftEnd((Any)user);
                    user.add((Membership)membership);
                    this.fill((Any)user, (Membership)membership, (MembershipTO)membershipTO, anyUtils, scce);
                } else {
                    LOG.error("{} cannot be assigned to {}", (Object)group, (Object)user);
                    SyncopeClientException unassignable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                    unassignable.getElements().add("Cannot be assigned: " + group);
                    scce.addException(unassignable);
                }
            });
        }
        this.fill((Any)user, (AnyTO)userTO, anyUtils, scce);
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    private boolean isPasswordMapped(ExternalResource resource) {
        boolean result = false;
        Optional provision = resource.getProvision(this.anyTypeDAO.findUser());
        if (provision.isPresent() && ((Provision)provision.get()).getMapping() != null) {
            result = ((Provision)provision.get()).getMapping().getItems().stream().anyMatch(item -> item.isPassword());
        }
        return result;
    }

    public PropagationByResource update(User toBeUpdated, UserPatch userPatch) {
        User user = (User)this.userDAO.save((Any)toBeUpdated);
        PropagationByResource propByRes = new PropagationByResource();
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(AnyTypeKind.USER);
        Collection currentResources = this.userDAO.findAllResourceKeys(user.getKey());
        Map<String, String> oldConnObjectKeys = this.getConnObjectKeys((Any<?>)user, anyUtils);
        this.setRealm((Any<?>)user, (AnyPatch)userPatch);
        if (userPatch.getPassword() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)userPatch.getPassword().getValue()))) {
            if (userPatch.getPassword().isOnSyncope()) {
                this.setPassword(user, (String)userPatch.getPassword().getValue(), scce);
                user.setChangePwdDate(new Date());
            }
            propByRes.addAll(ResourceOperation.UPDATE, (Collection)userPatch.getPassword().getResources());
        }
        if (userPatch.getUsername() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)userPatch.getUsername().getValue()))) {
            AccessToken accessToken;
            String oldUsername = user.getUsername();
            user.setUsername((String)userPatch.getUsername().getValue());
            if (oldUsername.equals(AuthContextUtils.getUsername())) {
                AuthContextUtils.updateUsername((String)((String)userPatch.getUsername().getValue()));
            }
            if ((accessToken = this.accessTokenDAO.findByOwner(oldUsername)) != null) {
                accessToken.setOwner((String)userPatch.getUsername().getValue());
                this.accessTokenDAO.save(accessToken);
            }
            propByRes.addAll(ResourceOperation.UPDATE, currentResources);
        }
        if (userPatch.getSecurityQuestion() != null) {
            if (userPatch.getSecurityQuestion().getValue() == null) {
                user.setSecurityQuestion(null);
                user.setSecurityAnswer(null);
            } else {
                SecurityQuestion securityQuestion = this.securityQuestionDAO.find((String)userPatch.getSecurityQuestion().getValue());
                if (securityQuestion != null) {
                    user.setSecurityQuestion(securityQuestion);
                    user.setSecurityAnswer((String)userPatch.getSecurityAnswer().getValue());
                }
            }
        }
        if (userPatch.getMustChangePassword() != null) {
            user.setMustChangePassword(((Boolean)userPatch.getMustChangePassword().getValue()).booleanValue());
        }
        block3: for (StringPatchItem patch2 : userPatch.getRoles()) {
            Role role = this.roleDAO.find((String)patch2.getValue());
            if (role == null) {
                LOG.warn("Ignoring unknown role with key {}", patch2.getValue());
                continue;
            }
            switch (patch2.getOperation()) {
                case ADD_REPLACE: {
                    user.add(role);
                    continue block3;
                }
            }
            user.getRoles().remove(role);
        }
        propByRes.merge(this.fill((Any)user, (AnyPatch)userPatch, anyUtils, scce));
        userPatch.getRelationships().stream().filter(patch -> patch.getRelationshipTO() != null).forEachOrdered(patch -> {
            RelationshipType relationshipType = this.relationshipTypeDAO.find(patch.getRelationshipTO().getType());
            if (relationshipType == null) {
                LOG.debug("Ignoring invalid relationship type {}", (Object)patch.getRelationshipTO().getType());
            } else {
                user.getRelationship(relationshipType, patch.getRelationshipTO().getOtherEndKey()).ifPresent(relationship -> {
                    user.getRelationships().remove(relationship);
                    relationship.setLeftEnd(null);
                });
                if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                    AnyObject otherEnd = (AnyObject)this.anyObjectDAO.find(patch.getRelationshipTO().getOtherEndKey());
                    if (otherEnd == null) {
                        LOG.debug("Ignoring invalid any object {}", (Object)patch.getRelationshipTO().getOtherEndKey());
                    } else if (user.getRealm().getFullPath().startsWith(otherEnd.getRealm().getFullPath())) {
                        URelationship newRelationship = (URelationship)this.entityFactory.newEntity(URelationship.class);
                        newRelationship.setType(relationshipType);
                        newRelationship.setRightEnd((Any)otherEnd);
                        newRelationship.setLeftEnd((Any)user);
                        user.add((Relationship)newRelationship);
                    } else {
                        LOG.error("{} cannot be assigned to {}", (Object)otherEnd, (Object)user);
                        SyncopeClientException unassignable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                        unassignable.getElements().add("Cannot be assigned: " + otherEnd);
                        scce.addException(unassignable);
                    }
                }
            }
        });
        Collection resources = this.userDAO.findAllResources(user);
        HashMap reasons = new HashMap();
        user.getResources().forEach(resource -> reasons.put(resource.getKey(), new HashSet<String>(Collections.singleton(user.getKey()))));
        this.userDAO.findAllGroupKeys(user).forEach(group -> this.groupDAO.findAllResourceKeys(group).forEach(resource -> {
            if (!reasons.containsKey(resource)) {
                reasons.put(resource, new HashSet());
            }
            ((Set)reasons.get(resource)).add(group);
        }));
        HashSet toBeDeprovisioned = new HashSet();
        HashSet toBeProvisioned = new HashSet();
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        userPatch.getMemberships().stream().filter(membPatch -> membPatch.getGroup() != null).forEachOrdered(membPatch -> {
            user.getMembership(membPatch.getGroup()).ifPresent(membership -> {
                user.getMemberships().remove(membership);
                membership.setLeftEnd(null);
                user.getPlainAttrs((Membership)membership).forEach(attr -> {
                    user.remove((GroupablePlainAttr)attr);
                    attr.setOwner(null);
                    attr.setMembership(null);
                });
                if (membPatch.getOperation() == PatchOperation.DELETE) {
                    this.groupDAO.findAllResourceKeys(((Group)membership.getRightEnd()).getKey()).stream().filter(resource -> reasons.containsKey(resource)).forEach(resource -> {
                        ((Set)reasons.get(resource)).remove(((Group)membership.getRightEnd()).getKey());
                        toBeProvisioned.add(resource);
                    });
                }
            });
            if (membPatch.getOperation() == PatchOperation.ADD_REPLACE) {
                Group group = (Group)this.groupDAO.find(membPatch.getGroup());
                if (group == null) {
                    LOG.debug("Ignoring invalid group {}", (Object)membPatch.getGroup());
                } else if (user.getRealm().getFullPath().startsWith(group.getRealm().getFullPath())) {
                    UMembership newMembership = (UMembership)this.entityFactory.newEntity(UMembership.class);
                    newMembership.setRightEnd((Any)group);
                    newMembership.setLeftEnd((Any)user);
                    user.add((Membership)newMembership);
                    membPatch.getPlainAttrs().forEach(attrTO -> {
                        PlainSchema schema = this.getPlainSchema(attrTO.getSchema());
                        if (schema == null) {
                            LOG.debug("Invalid " + PlainSchema.class.getSimpleName() + "{}, ignoring...", (Object)attrTO.getSchema());
                        } else {
                            UPlainAttr attr = user.getPlainAttr(schema.getKey(), (Membership)newMembership).orElse(null);
                            if (attr == null) {
                                LOG.debug("No plain attribute found for {} and membership of {}", (Object)schema, (Object)newMembership.getRightEnd());
                                attr = (UPlainAttr)anyUtils.newPlainAttr();
                                attr.setOwner((Any)user);
                                attr.setMembership((Membership)newMembership);
                                attr.setSchema(schema);
                                user.add((GroupablePlainAttr)attr);
                                AttrPatch patch = (AttrPatch)new AttrPatch.Builder().attrTO(attrTO).build();
                                this.processAttrPatch((Any)user, patch, schema, (PlainAttr<?>)attr, anyUtils, resources, propByRes, invalidValues);
                            }
                        }
                    });
                    if (!invalidValues.isEmpty()) {
                        scce.addException(invalidValues);
                    }
                    toBeProvisioned.addAll(this.groupDAO.findAllResourceKeys(group.getKey()));
                    if (toBeUpdated.canDecodePassword()) {
                        if (userPatch.getPassword() == null) {
                            userPatch.setPassword(new PasswordPatch());
                        }
                        group.getResources().stream().filter(resource -> this.isPasswordMapped((ExternalResource)resource)).forEachOrdered(resource -> userPatch.getPassword().getResources().add(resource.getKey()));
                    }
                } else {
                    LOG.error("{} cannot be assigned to {}", (Object)group, (Object)user);
                    SyncopeClientException unassignabled = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                    unassignabled.getElements().add("Cannot be assigned: " + group);
                    scce.addException(unassignabled);
                }
            }
        });
        reasons.entrySet().stream().filter(entry -> ((Set)entry.getValue()).isEmpty()).forEach(entry -> toBeDeprovisioned.add(entry.getKey()));
        propByRes.addAll(ResourceOperation.DELETE, toBeDeprovisioned);
        propByRes.addAll(ResourceOperation.UPDATE, toBeProvisioned);
        if (!toBeDeprovisioned.isEmpty() || !toBeProvisioned.isEmpty()) {
            currentResources.removeAll(toBeDeprovisioned);
            propByRes.addAll(ResourceOperation.UPDATE, currentResources);
        }
        Map<String, String> newConnObjectKeys = this.getConnObjectKeys((Any<?>)user, anyUtils);
        oldConnObjectKeys.entrySet().stream().filter(entry -> newConnObjectKeys.containsKey(entry.getKey()) && !((String)entry.getValue()).equals(newConnObjectKeys.get(entry.getKey()))).forEach(entry -> {
            propByRes.addOldConnObjectKey((String)entry.getKey(), (String)entry.getValue());
            propByRes.add(ResourceOperation.UPDATE, (String)entry.getKey());
        });
        Pair dynGroupMembs = this.userDAO.saveAndGetDynGroupMembs(user);
        ((Set)dynGroupMembs.getLeft()).stream().filter(group -> !((Set)dynGroupMembs.getRight()).contains(group)).forEach(delete -> ((Group)this.groupDAO.find(delete)).getResources().stream().filter(resource -> !propByRes.contains(resource.getKey())).forEach(resource -> propByRes.add(ResourceOperation.DELETE, resource.getKey())));
        ((Set)dynGroupMembs.getLeft()).stream().filter(group -> ((Set)dynGroupMembs.getRight()).contains(group)).forEach(update -> ((Group)this.groupDAO.find(update)).getResources().stream().filter(resource -> !propByRes.contains(resource.getKey())).forEach(resource -> propByRes.add(ResourceOperation.UPDATE, resource.getKey())));
        ((Set)dynGroupMembs.getRight()).stream().filter(group -> !((Set)dynGroupMembs.getLeft()).contains(group)).forEach(create -> ((Group)this.groupDAO.find(create)).getResources().stream().filter(resource -> !propByRes.contains(resource.getKey())).forEach(resource -> propByRes.add(ResourceOperation.CREATE, resource.getKey())));
        if (scce.hasExceptions()) {
            throw scce;
        }
        return propByRes;
    }

    @Transactional(readOnly=true)
    public UserTO getUserTO(User user, boolean details) {
        UserTO userTO = new UserTO();
        BeanUtils.copyProperties((Object)user, (Object)userTO, (String[])IGNORE_PROPERTIES);
        userTO.setSuspended(BooleanUtils.isTrue((Boolean)user.isSuspended()));
        if (user.getSecurityQuestion() != null) {
            userTO.setSecurityQuestion(user.getSecurityQuestion().getKey());
        }
        Map virAttrValues = details ? this.virAttrHandler.getValues((Any)user) : Collections.emptyMap();
        this.fillTO((AnyTO)userTO, user.getRealm().getFullPath(), user.getAuxClasses(), user.getPlainAttrs(), this.derAttrHandler.getValues((Any)user), virAttrValues, this.userDAO.findAllResources(user), details);
        if (details) {
            userTO.getDynRealms().addAll(this.userDAO.findDynRealms(user.getKey()));
            userTO.getRoles().addAll(user.getRoles().stream().map(Entity::getKey).collect(Collectors.toList()));
            userTO.getDynRoles().addAll(this.userDAO.findDynRoles(user.getKey()).stream().map(Entity::getKey).collect(Collectors.toList()));
            userTO.getPrivileges().addAll(this.userDAO.findAllRoles(user).stream().flatMap(role -> role.getPrivileges().stream()).map(Entity::getKey).collect(Collectors.toSet()));
            userTO.getRelationships().addAll(user.getRelationships().stream().map(relationship -> this.getRelationshipTO(relationship.getType().getKey(), relationship.getRightEnd())).collect(Collectors.toList()));
            userTO.getMemberships().addAll(user.getMemberships().stream().map(membership -> this.getMembershipTO(user.getPlainAttrs((Membership)membership), this.derAttrHandler.getValues((GroupableRelatable)user, (Membership)membership), this.virAttrHandler.getValues((Any)user, (Membership)membership), (Membership<? extends Any<?>>)membership)).collect(Collectors.toList()));
            userTO.getDynMemberships().addAll(this.userDAO.findDynGroups(user.getKey()).stream().map(group -> new MembershipTO.Builder().group(group.getKey(), group.getName()).build()).collect(Collectors.toList()));
        }
        return userTO;
    }

    @Transactional(readOnly=true)
    public UserTO getUserTO(String key) {
        return this.getUserTO((User)this.userDAO.authFind(key), true);
    }
}

