/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.NotificationTaskTO;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.task.AnyTemplatePullTask;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTaskAnyFilter;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtils;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.provisioning.api.data.TaskDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.BeanUtils;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;

@Component
public class TaskDataBinderImpl
implements TaskDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(TaskDataBinder.class);
    private static final String[] IGNORE_TASK_PROPERTIES = new String[]{"destinationRealm", "templates", "filters", "executions", "resource", "matchingRule", "unmatchingRule", "notification", "jobDelegate", "actions"};
    private static final String[] IGNORE_TASK_EXECUTION_PROPERTIES = new String[]{"key", "task"};
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private TaskExecDAO taskExecDAO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private ImplementationDAO implementationDAO;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private TemplateUtils templateUtils;
    @Autowired
    private SchedulerFactoryBean scheduler;
    @Autowired
    private TaskUtilsFactory taskUtilsFactory;

    private void fill(ProvisioningTask task, ProvisioningTaskTO taskTO) {
        if (task instanceof PushTask && taskTO instanceof PushTaskTO) {
            Implementation jobDelegate;
            PushTask pushTask = (PushTask)task;
            PushTaskTO pushTaskTO = (PushTaskTO)taskTO;
            Implementation implementation2 = jobDelegate = pushTaskTO.getJobDelegate() == null ? (Implementation)this.implementationDAO.find(ImplementationType.TASKJOB_DELEGATE).stream().filter(impl -> PushJobDelegate.class.getName().equals(impl.getBody())).findFirst().orElse(null) : this.implementationDAO.find(pushTaskTO.getJobDelegate());
            if (jobDelegate == null) {
                jobDelegate = (Implementation)this.entityFactory.newEntity(Implementation.class);
                jobDelegate.setKey(PushJobDelegate.class.getSimpleName());
                jobDelegate.setEngine(ImplementationEngine.JAVA);
                jobDelegate.setType(ImplementationType.TASKJOB_DELEGATE);
                jobDelegate.setBody(PushJobDelegate.class.getName());
                jobDelegate = this.implementationDAO.save(jobDelegate);
            }
            pushTask.setJobDelegate(jobDelegate);
            pushTask.setSourceRealm(this.realmDAO.findByFullPath(pushTaskTO.getSourceRealm()));
            pushTask.setMatchingRule(pushTaskTO.getMatchingRule() == null ? MatchingRule.LINK : pushTaskTO.getMatchingRule());
            pushTask.setUnmatchingRule(pushTaskTO.getUnmatchingRule() == null ? UnmatchingRule.ASSIGN : pushTaskTO.getUnmatchingRule());
            pushTaskTO.getFilters().forEach((type, fiql) -> {
                AnyType anyType = this.anyTypeDAO.find(type);
                if (anyType == null) {
                    LOG.debug("Invalid AnyType {} specified, ignoring...", type);
                } else {
                    PushTaskAnyFilter filter = pushTask.getFilter(anyType).orElse(null);
                    if (filter == null) {
                        filter = (PushTaskAnyFilter)this.entityFactory.newEntity(PushTaskAnyFilter.class);
                        filter.setAnyType(anyType);
                        filter.setPushTask(pushTask);
                        pushTask.add(filter);
                    }
                    filter.setFIQLCond(fiql);
                }
            });
            pushTask.getFilters().removeIf(anyFilter -> !pushTaskTO.getFilters().containsKey(anyFilter.getAnyType().getKey()));
        } else if (task instanceof PullTask && taskTO instanceof PullTaskTO) {
            Implementation jobDelegate;
            PullTask pullTask = (PullTask)task;
            PullTaskTO pullTaskTO = (PullTaskTO)taskTO;
            Implementation implementation3 = jobDelegate = pullTaskTO.getJobDelegate() == null ? (Implementation)this.implementationDAO.find(ImplementationType.TASKJOB_DELEGATE).stream().filter(impl -> PullJobDelegate.class.getName().equals(impl.getBody())).findFirst().orElse(null) : this.implementationDAO.find(pullTaskTO.getJobDelegate());
            if (jobDelegate == null) {
                jobDelegate = (Implementation)this.entityFactory.newEntity(Implementation.class);
                jobDelegate.setKey(PullJobDelegate.class.getSimpleName());
                jobDelegate.setEngine(ImplementationEngine.JAVA);
                jobDelegate.setType(ImplementationType.TASKJOB_DELEGATE);
                jobDelegate.setBody(PullJobDelegate.class.getName());
                jobDelegate = this.implementationDAO.save(jobDelegate);
            }
            pullTask.setJobDelegate(jobDelegate);
            pullTask.setPullMode(pullTaskTO.getPullMode());
            if (pullTaskTO.getReconFilterBuilder() == null) {
                pullTask.setReconFilterBuilder(null);
            } else {
                Implementation reconFilterBuilder = this.implementationDAO.find(pullTaskTO.getReconFilterBuilder());
                if (reconFilterBuilder == null) {
                    LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", (Object)pullTaskTO.getReconFilterBuilder());
                } else {
                    pullTask.setReconFilterBuilder(reconFilterBuilder);
                }
            }
            pullTask.setDestinationRealm(this.realmDAO.findByFullPath(pullTaskTO.getDestinationRealm()));
            pullTask.setMatchingRule(pullTaskTO.getMatchingRule() == null ? MatchingRule.UPDATE : pullTaskTO.getMatchingRule());
            pullTask.setUnmatchingRule(pullTaskTO.getUnmatchingRule() == null ? UnmatchingRule.PROVISION : pullTaskTO.getUnmatchingRule());
            this.templateUtils.check(pullTaskTO.getTemplates(), ClientExceptionType.InvalidPullTask);
            pullTaskTO.getTemplates().forEach((type, template) -> {
                AnyType anyType = this.anyTypeDAO.find(type);
                if (anyType == null) {
                    LOG.debug("Invalid AnyType {} specified, ignoring...", type);
                } else {
                    AnyTemplatePullTask anyTemplate = pullTask.getTemplate(anyType).orElse(null);
                    if (anyTemplate == null) {
                        anyTemplate = (AnyTemplatePullTask)this.entityFactory.newEntity(AnyTemplatePullTask.class);
                        anyTemplate.setAnyType(anyType);
                        anyTemplate.setPullTask(pullTask);
                        pullTask.add(anyTemplate);
                    }
                    anyTemplate.set(template);
                }
            });
            pullTask.getTemplates().removeIf(anyTemplate -> !pullTaskTO.getTemplates().containsKey(anyTemplate.getAnyType().getKey()));
            pullTask.setRemediation(pullTaskTO.isRemediation());
        }
        task.setPerformCreate(taskTO.isPerformCreate());
        task.setPerformUpdate(taskTO.isPerformUpdate());
        task.setPerformDelete(taskTO.isPerformDelete());
        task.setSyncStatus(taskTO.isSyncStatus());
        taskTO.getActions().forEach(action -> {
            Implementation implementation = this.implementationDAO.find(action);
            if (implementation == null) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", action);
            } else {
                task.add(implementation);
            }
        });
        task.getActions().removeIf(implementation -> !taskTO.getActions().contains(implementation.getKey()));
    }

    public SchedTask createSchedTask(SchedTaskTO taskTO, TaskUtils taskUtils) {
        Class taskTOClass = taskUtils.taskTOClass();
        if (taskTOClass == null || !taskTOClass.equals(taskTO.getClass())) {
            throw new IllegalArgumentException(String.format("Expected %s, found %s", taskTOClass, taskTO.getClass()));
        }
        SchedTask task = (SchedTask)taskUtils.newTask();
        task.setStartAt(taskTO.getStartAt());
        task.setCronExpression(taskTO.getCronExpression());
        task.setName(taskTO.getName());
        task.setDescription(taskTO.getDescription());
        task.setActive(taskTO.isActive());
        if (taskUtils.getType() == TaskType.SCHEDULED) {
            Implementation implementation = this.implementationDAO.find(taskTO.getJobDelegate());
            if (implementation == null) {
                throw new NotFoundException("Implementation " + taskTO.getJobDelegate());
            }
            task.setJobDelegate(implementation);
        } else if (taskTO instanceof ProvisioningTaskTO) {
            ProvisioningTaskTO provisioningTaskTO = (ProvisioningTaskTO)taskTO;
            ExternalResource resource = this.resourceDAO.find(provisioningTaskTO.getResource());
            if (resource == null) {
                throw new NotFoundException("Resource " + provisioningTaskTO.getResource());
            }
            ((ProvisioningTask)task).setResource(resource);
            this.fill((ProvisioningTask)task, provisioningTaskTO);
        }
        return task;
    }

    public void updateSchedTask(SchedTask task, SchedTaskTO taskTO, TaskUtils taskUtils) {
        Class taskTOClass = taskUtils.taskTOClass();
        if (taskTOClass == null || !taskTOClass.equals(taskTO.getClass())) {
            throw new IllegalArgumentException(String.format("Expected %s, found %s", taskTOClass, taskTO.getClass()));
        }
        if (StringUtils.isBlank((CharSequence)taskTO.getName())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add("name");
            throw sce;
        }
        task.setName(taskTO.getName());
        task.setDescription(taskTO.getDescription());
        task.setCronExpression(taskTO.getCronExpression());
        task.setActive(taskTO.isActive());
        if (task instanceof ProvisioningTask) {
            this.fill((ProvisioningTask)task, (ProvisioningTaskTO)taskTO);
        }
    }

    public String buildRefDesc(Task task) {
        return this.taskUtilsFactory.getInstance(task).getType().name() + " Task " + task.getKey() + " " + (task instanceof SchedTask ? ((SchedTask)SchedTask.class.cast(task)).getName() : (task instanceof PropagationTask ? ((PropagationTask)PropagationTask.class.cast(task)).getConnObjectKey() : ""));
    }

    public ExecTO getExecTO(TaskExec execution) {
        ExecTO execTO = new ExecTO();
        BeanUtils.copyProperties((Object)execution, (Object)execTO, (String[])IGNORE_TASK_EXECUTION_PROPERTIES);
        if (execution.getKey() != null) {
            execTO.setKey(execution.getKey());
        }
        if (execution.getTask() != null && execution.getTask().getKey() != null) {
            execTO.setJobType(JobType.TASK);
            execTO.setRefKey(execution.getTask().getKey());
            execTO.setRefDesc(this.buildRefDesc(execution.getTask()));
        }
        return execTO;
    }

    private void setExecTime(SchedTaskTO taskTO, Task task) {
        taskTO.setLastExec(taskTO.getStart());
        String triggerName = JobNamer.getTriggerName((String)JobNamer.getJobKey((Task)task).getName());
        try {
            Trigger trigger = this.scheduler.getScheduler().getTrigger(new TriggerKey(triggerName, "DEFAULT"));
            if (trigger != null) {
                taskTO.setLastExec(trigger.getPreviousFireTime());
                taskTO.setNextExec(trigger.getNextFireTime());
            }
        }
        catch (SchedulerException e) {
            LOG.warn("While trying to get to " + triggerName, (Throwable)e);
        }
    }

    public <T extends TaskTO> T getTaskTO(Task task, TaskUtils taskUtils, boolean details) {
        TaskTO taskTO = taskUtils.newTaskTO();
        BeanUtils.copyProperties((Object)task, (Object)taskTO, (String[])IGNORE_TASK_PROPERTIES);
        TaskExec latestExec = this.taskExecDAO.findLatestStarted(task);
        if (latestExec == null) {
            taskTO.setLatestExecStatus("");
        } else {
            taskTO.setLatestExecStatus(latestExec.getStatus());
            taskTO.setStart(latestExec.getStart());
            taskTO.setEnd(latestExec.getEnd());
        }
        if (details) {
            task.getExecs().stream().filter(execution -> execution != null).forEachOrdered(execution -> taskTO.getExecutions().add(this.getExecTO((TaskExec)execution)));
        }
        switch (taskUtils.getType()) {
            case PROPAGATION: {
                PropagationTask propagationTask = (PropagationTask)task;
                PropagationTaskTO propagationTaskTO = (PropagationTaskTO)taskTO;
                propagationTaskTO.setAnyTypeKind(propagationTask.getAnyTypeKind());
                propagationTaskTO.setEntityKey(propagationTask.getEntityKey());
                propagationTaskTO.setResource(propagationTask.getResource().getKey());
                propagationTaskTO.setAttributes(propagationTask.getSerializedAttributes());
                break;
            }
            case SCHEDULED: {
                SchedTask schedTask = (SchedTask)task;
                SchedTaskTO schedTaskTO = (SchedTaskTO)taskTO;
                this.setExecTime(schedTaskTO, task);
                if (schedTask.getJobDelegate() == null) break;
                schedTaskTO.setJobDelegate(schedTask.getJobDelegate().getKey());
                break;
            }
            case PULL: {
                PullTask pullTask = (PullTask)task;
                PullTaskTO pullTaskTO = (PullTaskTO)taskTO;
                this.setExecTime((SchedTaskTO)pullTaskTO, task);
                pullTaskTO.setDestinationRealm(pullTask.getDestinatioRealm().getFullPath());
                pullTaskTO.setResource(pullTask.getResource().getKey());
                pullTaskTO.setMatchingRule(pullTask.getMatchingRule() == null ? MatchingRule.UPDATE : pullTask.getMatchingRule());
                pullTaskTO.setUnmatchingRule(pullTask.getUnmatchingRule() == null ? UnmatchingRule.PROVISION : pullTask.getUnmatchingRule());
                if (pullTask.getReconFilterBuilder() != null) {
                    pullTaskTO.setReconFilterBuilder(pullTask.getReconFilterBuilder().getKey());
                }
                pullTaskTO.getActions().addAll(pullTask.getActions().stream().map(Entity::getKey).collect(Collectors.toList()));
                pullTask.getTemplates().forEach(template -> pullTaskTO.getTemplates().put(template.getAnyType().getKey(), template.get()));
                pullTaskTO.setRemediation(pullTask.isRemediation());
                break;
            }
            case PUSH: {
                PushTask pushTask = (PushTask)task;
                PushTaskTO pushTaskTO = (PushTaskTO)taskTO;
                this.setExecTime((SchedTaskTO)pushTaskTO, task);
                pushTaskTO.setSourceRealm(pushTask.getSourceRealm().getFullPath());
                pushTaskTO.setResource(pushTask.getResource().getKey());
                pushTaskTO.setMatchingRule(pushTask.getMatchingRule() == null ? MatchingRule.LINK : pushTask.getMatchingRule());
                pushTaskTO.setUnmatchingRule(pushTask.getUnmatchingRule() == null ? UnmatchingRule.ASSIGN : pushTask.getUnmatchingRule());
                pushTaskTO.getActions().addAll(pushTask.getActions().stream().map(Entity::getKey).collect(Collectors.toList()));
                pushTask.getFilters().forEach(filter -> pushTaskTO.getFilters().put(filter.getAnyType().getKey(), filter.getFIQLCond()));
                break;
            }
            case NOTIFICATION: {
                NotificationTask notificationTask = (NotificationTask)task;
                NotificationTaskTO notificationTaskTO = (NotificationTaskTO)taskTO;
                notificationTaskTO.setNotification(notificationTask.getNotification().getKey());
                notificationTaskTO.setAnyTypeKind(notificationTask.getAnyTypeKind());
                notificationTaskTO.setEntityKey(notificationTask.getEntityKey());
                if (!notificationTask.isExecuted() || !StringUtils.isBlank((CharSequence)taskTO.getLatestExecStatus())) break;
                taskTO.setLatestExecStatus("[EXECUTED]");
                break;
            }
        }
        return (T)taskTO;
    }
}

