/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.stream.Collectors;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.ReportExecDAO;
import org.apache.syncope.core.persistence.api.dao.ReportTemplateDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.ReportExec;
import org.apache.syncope.core.persistence.api.entity.ReportTemplate;
import org.apache.syncope.core.provisioning.api.data.ReportDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.spring.BeanUtils;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;

@Component
public class ReportDataBinderImpl
implements ReportDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(ReportDataBinder.class);
    private static final String[] IGNORE_REPORT_PROPERTIES = new String[]{"key", "template", "reportlets", "executions"};
    private static final String[] IGNORE_REPORT_EXECUTION_PROPERTIES = new String[]{"key", "report", "execResult"};
    @Autowired
    private ReportTemplateDAO reportTemplateDAO;
    @Autowired
    private ReportExecDAO reportExecDAO;
    @Autowired
    private ImplementationDAO implementationDAO;
    @Autowired
    private SchedulerFactoryBean scheduler;

    public void getReport(Report report, ReportTO reportTO) {
        BeanUtils.copyProperties((Object)reportTO, (Object)report, (String[])IGNORE_REPORT_PROPERTIES);
        ReportTemplate template = this.reportTemplateDAO.find(reportTO.getTemplate());
        if (template == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add("template");
            throw sce;
        }
        report.setTemplate(template);
        reportTO.getReportlets().forEach(reportletKey -> {
            Implementation reportlet = this.implementationDAO.find(reportletKey);
            if (reportlet == null) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", reportletKey);
            } else {
                report.add(reportlet);
            }
        });
        report.getReportlets().removeIf(reportlet -> !reportTO.getReportlets().contains(reportlet.getKey()));
    }

    public ReportTO getReportTO(Report report) {
        ReportTO reportTO = new ReportTO();
        reportTO.setKey(report.getKey());
        reportTO.setTemplate(report.getTemplate().getKey());
        BeanUtils.copyProperties((Object)report, (Object)reportTO, (String[])IGNORE_REPORT_PROPERTIES);
        reportTO.getReportlets().addAll(report.getReportlets().stream().map(Entity::getKey).collect(Collectors.toList()));
        ReportExec latestExec = this.reportExecDAO.findLatestStarted(report);
        if (latestExec == null) {
            reportTO.setLatestExecStatus("");
        } else {
            reportTO.setLatestExecStatus(latestExec.getStatus());
            reportTO.setStart(latestExec.getStart());
            reportTO.setEnd(latestExec.getEnd());
            reportTO.setLastExec(reportTO.getStart());
        }
        reportTO.getExecutions().addAll(report.getExecs().stream().map(reportExec -> this.getExecTO((ReportExec)reportExec)).collect(Collectors.toList()));
        String triggerName = JobNamer.getTriggerName((String)JobNamer.getJobKey((Report)report).getName());
        try {
            Trigger trigger = this.scheduler.getScheduler().getTrigger(new TriggerKey(triggerName, "DEFAULT"));
            if (trigger != null) {
                reportTO.setLastExec(trigger.getPreviousFireTime());
                reportTO.setNextExec(trigger.getNextFireTime());
            }
        }
        catch (SchedulerException e) {
            LOG.warn("While trying to get to " + triggerName, (Throwable)e);
        }
        return reportTO;
    }

    public String buildRefDesc(Report report) {
        return "Report " + report.getKey() + " " + report.getName();
    }

    public ExecTO getExecTO(ReportExec execution) {
        ExecTO execTO = new ExecTO();
        execTO.setKey(execution.getKey());
        BeanUtils.copyProperties((Object)execution, (Object)execTO, (String[])IGNORE_REPORT_EXECUTION_PROPERTIES);
        if (execution.getKey() != null) {
            execTO.setKey(execution.getKey());
        }
        execTO.setJobType(JobType.REPORT);
        execTO.setRefKey(execution.getReport().getKey());
        execTO.setRefDesc(this.buildRefDesc(execution.getReport()));
        return execTO;
    }
}

