/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.DynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.ADynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.group.TypeExtension;
import org.apache.syncope.core.persistence.api.entity.user.UDynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.java.data.AbstractAnyDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Throwable.class})
public class GroupDataBinderImpl
extends AbstractAnyDataBinder
implements GroupDataBinder {
    @Autowired
    private AnyTypeDAO anyTypeDAO;

    private void setDynMembership(Group group, AnyType anyType, String dynMembershipFIQL) {
        DynGroupMembership dynMembership;
        SearchCond dynMembershipCond = SearchCondConverter.convert((String)dynMembershipFIQL, (String[])new String[0]);
        if (!dynMembershipCond.isValid()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchExpression);
            sce.getElements().add(dynMembershipFIQL);
            throw sce;
        }
        if (anyType.getKind() == AnyTypeKind.GROUP) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
            sce.getElements().add(anyType.getKind().name());
            throw sce;
        }
        if (anyType.getKind() == AnyTypeKind.ANY_OBJECT && !group.getADynMembership(anyType).isPresent()) {
            dynMembership = (DynGroupMembership)this.entityFactory.newEntity(ADynGroupMembership.class);
            dynMembership.setGroup(group);
            ((ADynGroupMembership)dynMembership).setAnyType(anyType);
            group.add((ADynGroupMembership)dynMembership);
        } else if (anyType.getKind() == AnyTypeKind.USER && group.getUDynMembership() == null) {
            dynMembership = (DynGroupMembership)this.entityFactory.newEntity(UDynGroupMembership.class);
            dynMembership.setGroup(group);
            group.setUDynMembership((UDynGroupMembership)dynMembership);
        } else {
            dynMembership = anyType.getKind() == AnyTypeKind.ANY_OBJECT ? (DynGroupMembership)group.getADynMembership(anyType).get() : group.getUDynMembership();
        }
        dynMembership.setFIQLCond(dynMembershipFIQL);
    }

    public void create(Group group, GroupTO groupTO) {
        User owner;
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidGroups = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidGroup);
        if (groupTO.getName() == null) {
            LOG.error("No name specified for this group");
            invalidGroups.getElements().add("No name specified for this group");
        } else {
            group.setName(groupTO.getName());
        }
        Realm realm = this.realmDAO.findByFullPath(groupTO.getRealm());
        if (realm == null) {
            SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            noRealm.getElements().add("Invalid or null realm specified: " + groupTO.getRealm());
            scce.addException(noRealm);
        }
        group.setRealm(realm);
        this.fill((Any)group, (AnyTO)groupTO, this.anyUtilsFactory.getInstance(AnyTypeKind.GROUP), scce);
        if (groupTO.getUserOwner() != null) {
            owner = (User)this.userDAO.find(groupTO.getUserOwner());
            if (owner == null) {
                LOG.warn("Ignoring invalid user specified as owner: {}", (Object)groupTO.getUserOwner());
            } else {
                group.setUserOwner(owner);
            }
        }
        if (groupTO.getGroupOwner() != null) {
            owner = (Group)this.groupDAO.find(groupTO.getGroupOwner());
            if (owner == null) {
                LOG.warn("Ignoring invalid group specified as owner: {}", (Object)groupTO.getGroupOwner());
            } else {
                group.setGroupOwner((Group)owner);
            }
        }
        if (groupTO.getUDynMembershipCond() != null) {
            this.setDynMembership(group, this.anyTypeDAO.findUser(), groupTO.getUDynMembershipCond());
        }
        groupTO.getADynMembershipConds().forEach((type, fiql) -> {
            AnyType anyType = this.anyTypeDAO.find(type);
            if (anyType == null) {
                LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), type);
            } else {
                this.setDynMembership(group, anyType, (String)fiql);
            }
        });
        groupTO.getTypeExtensions().forEach(typeExtTO -> {
            AnyType anyType = this.anyTypeDAO.find(typeExtTO.getAnyType());
            if (anyType == null) {
                LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), (Object)typeExtTO.getAnyType());
            } else {
                TypeExtension typeExt = (TypeExtension)this.entityFactory.newEntity(TypeExtension.class);
                typeExt.setAnyType(anyType);
                typeExt.setGroup(group);
                group.add(typeExt);
                typeExtTO.getAuxClasses().forEach(name -> {
                    AnyTypeClass anyTypeClass = this.anyTypeClassDAO.find(name);
                    if (anyTypeClass == null) {
                        LOG.warn("Ignoring invalid {}: {}", (Object)AnyTypeClass.class.getSimpleName(), name);
                    } else {
                        typeExt.add(anyTypeClass);
                    }
                });
                if (typeExt.getAuxClasses().isEmpty()) {
                    group.getTypeExtensions().remove(typeExt);
                    typeExt.setGroup(null);
                }
            }
        });
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public PropagationByResource update(Group toBeUpdated, GroupPatch groupPatch) {
        AnyType anyType;
        Group group = (Group)this.groupDAO.save((Any)toBeUpdated);
        PropagationByResource propByRes = new PropagationByResource();
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(AnyTypeKind.GROUP);
        Map<String, String> oldConnObjectKeys = this.getConnObjectKeys((Any<?>)group, anyUtils);
        this.setRealm((Any<?>)group, (AnyPatch)groupPatch);
        if (groupPatch.getName() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)groupPatch.getName().getValue()))) {
            propByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(group.getKey()));
            group.setName((String)groupPatch.getName().getValue());
        }
        if (groupPatch.getUserOwner() != null) {
            group.setUserOwner(groupPatch.getUserOwner().getValue() == null ? null : (User)this.userDAO.find((String)groupPatch.getUserOwner().getValue()));
        }
        if (groupPatch.getGroupOwner() != null) {
            group.setGroupOwner(groupPatch.getGroupOwner().getValue() == null ? null : (Group)this.groupDAO.find((String)groupPatch.getGroupOwner().getValue()));
        }
        propByRes.merge(this.fill((Any)group, (AnyPatch)groupPatch, anyUtils, scce));
        Map<String, String> newConnObjectKeys = this.getConnObjectKeys((Any<?>)group, anyUtils);
        oldConnObjectKeys.entrySet().stream().filter(entry -> newConnObjectKeys.containsKey(entry.getKey()) && !((String)entry.getValue()).equals(newConnObjectKeys.get(entry.getKey()))).forEach(entry -> {
            propByRes.addOldConnObjectKey((String)entry.getKey(), (String)entry.getValue());
            propByRes.add(ResourceOperation.UPDATE, (String)entry.getKey());
        });
        group = (Group)this.groupDAO.save((Any)group);
        if (groupPatch.getUDynMembershipCond() == null) {
            if (group.getUDynMembership() != null) {
                group.getUDynMembership().setGroup(null);
                group.setUDynMembership(null);
                this.groupDAO.clearUDynMembers(group);
            }
        } else {
            this.setDynMembership(group, this.anyTypeDAO.findUser(), groupPatch.getUDynMembershipCond());
        }
        Iterator itor = group.getADynMemberships().iterator();
        while (itor.hasNext()) {
            ADynGroupMembership memb = (ADynGroupMembership)itor.next();
            memb.setGroup(null);
            itor.remove();
        }
        this.groupDAO.clearADynMembers(group);
        for (Map.Entry entry2 : groupPatch.getADynMembershipConds().entrySet()) {
            anyType = this.anyTypeDAO.find((String)entry2.getKey());
            if (anyType == null) {
                LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), entry2.getKey());
                continue;
            }
            this.setDynMembership(group, anyType, (String)entry2.getValue());
        }
        group = this.groupDAO.saveAndRefreshDynMemberships(group);
        for (TypeExtensionTO typeExtTO : groupPatch.getTypeExtensions()) {
            anyType = this.anyTypeDAO.find(typeExtTO.getAnyType());
            if (anyType == null) {
                LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), (Object)typeExtTO.getAnyType());
                continue;
            }
            TypeExtension typeExt2 = group.getTypeExtension(anyType).orElse(null);
            if (typeExt2 == null) {
                typeExt2 = (TypeExtension)this.entityFactory.newEntity(TypeExtension.class);
                typeExt2.setAnyType(anyType);
                typeExt2.setGroup(group);
                group.add(typeExt2);
            }
            for (String name : typeExtTO.getAuxClasses()) {
                AnyTypeClass anyTypeClass2 = this.anyTypeClassDAO.find(name);
                if (anyTypeClass2 == null) {
                    LOG.warn("Ignoring invalid {}: {}", (Object)AnyTypeClass.class.getSimpleName(), (Object)name);
                    continue;
                }
                typeExt2.add(anyTypeClass2);
            }
            typeExt2.getAuxClasses().removeIf(anyTypeClass -> !typeExtTO.getAuxClasses().contains(anyTypeClass.getKey()));
            if (!typeExt2.getAuxClasses().isEmpty()) continue;
            group.getTypeExtensions().remove(typeExt2);
            typeExt2.setGroup(null);
        }
        group.getTypeExtensions().removeIf(typeExt -> !groupPatch.getTypeExtension(typeExt.getAnyType().getKey()).isPresent());
        if (scce.hasExceptions()) {
            throw scce;
        }
        return propByRes;
    }

    public TypeExtensionTO getTypeExtensionTO(TypeExtension typeExt) {
        TypeExtensionTO typeExtTO = new TypeExtensionTO();
        typeExtTO.setAnyType(typeExt.getAnyType().getKey());
        typeExtTO.getAuxClasses().addAll(typeExt.getAuxClasses().stream().map(Entity::getKey).collect(Collectors.toList()));
        return typeExtTO;
    }

    @Transactional(readOnly=true)
    public GroupTO getGroupTO(Group group, boolean details) {
        GroupTO groupTO = new GroupTO();
        groupTO.setCreator(group.getCreator());
        groupTO.setCreationDate(group.getCreationDate());
        groupTO.setLastModifier(group.getLastModifier());
        groupTO.setLastChangeDate(group.getLastChangeDate());
        groupTO.setKey(group.getKey());
        groupTO.setName(group.getName());
        if (group.getUserOwner() != null) {
            groupTO.setUserOwner(group.getUserOwner().getKey());
        }
        if (group.getGroupOwner() != null) {
            groupTO.setGroupOwner(group.getGroupOwner().getKey());
        }
        Map derAttrValues = this.derAttrHandler.getValues((Any)group);
        Map virAttrValues = details ? this.virAttrHandler.getValues((Any)group) : Collections.emptyMap();
        this.fillTO((AnyTO)groupTO, group.getRealm().getFullPath(), group.getAuxClasses(), group.getPlainAttrs(), derAttrValues, virAttrValues, group.getResources(), details);
        if (details) {
            groupTO.getDynRealms().addAll(this.groupDAO.findDynRealms(group.getKey()));
        }
        groupTO.setStaticUserMembershipCount(this.groupDAO.countUMembers(group));
        groupTO.setStaticAnyObjectMembershipCount(this.groupDAO.countAMembers(group));
        groupTO.setDynamicUserMembershipCount(this.groupDAO.countUDynMembers(group));
        groupTO.setDynamicAnyObjectMembershipCount(this.groupDAO.countADynMembers(group));
        if (group.getUDynMembership() != null) {
            groupTO.setUDynMembershipCond(group.getUDynMembership().getFIQLCond());
        }
        group.getADynMemberships().forEach(memb -> groupTO.getADynMembershipConds().put(memb.getAnyType().getKey(), memb.getFIQLCond()));
        group.getTypeExtensions().forEach(typeExt -> groupTO.getTypeExtensions().add(this.getTypeExtensionTO((TypeExtension)typeExt)));
        return groupTO;
    }

    @Transactional(readOnly=true)
    public GroupTO getGroupTO(String key) {
        return this.getGroupTO((Group)this.groupDAO.authFind(key), true);
    }

    private void populateTransitiveResources(Group group, Any<?> any, Map<String, PropagationByResource> result) {
        PropagationByResource propByRes = new PropagationByResource();
        group.getResources().forEach(resource -> {
            if (!any.getResources().contains(resource)) {
                propByRes.add(ResourceOperation.DELETE, resource.getKey());
            }
            if (!propByRes.isEmpty()) {
                result.put(any.getKey(), propByRes);
            }
        });
    }

    @Transactional(readOnly=true)
    public Map<String, PropagationByResource> findAnyObjectsWithTransitiveResources(String groupKey) {
        Group group = (Group)this.groupDAO.authFind(groupKey);
        HashMap<String, PropagationByResource> result = new HashMap<String, PropagationByResource>();
        this.groupDAO.findAMemberships(group).forEach(membership -> this.populateTransitiveResources(group, membership.getLeftEnd(), result));
        return result;
    }

    @Transactional(readOnly=true)
    public Map<String, PropagationByResource> findUsersWithTransitiveResources(String groupKey) {
        Group group = (Group)this.groupDAO.authFind(groupKey);
        HashMap<String, PropagationByResource> result = new HashMap<String, PropagationByResource>();
        this.groupDAO.findUMemberships(group).forEach(membership -> this.populateTransitiveResources(group, membership.getLeftEnd(), result));
        return result;
    }
}

