/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.RandomBasedGenerator;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.rs.security.jose.common.JoseType;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.syncope.common.lib.to.AccessTokenTO;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.provisioning.api.data.AccessTokenDataBinder;
import org.apache.syncope.core.spring.BeanUtils;
import org.apache.syncope.core.spring.security.DefaultCredentialChecker;
import org.apache.syncope.core.spring.security.jws.AccessTokenJwsSignatureProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccessTokenDataBinderImpl
implements AccessTokenDataBinder {
    private static final RandomBasedGenerator UUID_GENERATOR = Generators.randomBasedGenerator();
    @Resource(name="adminUser")
    private String adminUser;
    @Resource(name="jwtIssuer")
    private String jwtIssuer;
    @Autowired
    private AccessTokenJwsSignatureProvider jwsSignatureProvider;
    @Autowired
    private AccessTokenDAO accessTokenDAO;
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private DefaultCredentialChecker credentialChecker;

    public Pair<String, Date> generateJWT(String tokenId, String subject, long duration, Map<String, Object> claims) {
        this.credentialChecker.checkIsDefaultJWSKeyInUse();
        long currentTime = new Date().getTime() / 1000L;
        long expiryTime = currentTime + 60L * duration;
        JwtClaims jwtClaims = new JwtClaims();
        jwtClaims.setTokenId(tokenId);
        jwtClaims.setSubject(subject);
        jwtClaims.setIssuedAt(Long.valueOf(currentTime));
        jwtClaims.setIssuer(this.jwtIssuer);
        jwtClaims.setExpiryTime(Long.valueOf(expiryTime));
        jwtClaims.setNotBefore(Long.valueOf(currentTime));
        claims.forEach((key, value) -> jwtClaims.setClaim(key, value));
        JwsHeaders jwsHeaders = new JwsHeaders(JoseType.JWT, this.jwsSignatureProvider.getAlgorithm());
        JwtToken token = new JwtToken(jwsHeaders, jwtClaims);
        JwsJwtCompactProducer producer = new JwsJwtCompactProducer(token);
        String signed = producer.signWith((JwsSignatureProvider)this.jwsSignatureProvider);
        return Pair.of((Object)signed, (Object)new Date(expiryTime * 1000L));
    }

    private AccessToken replace(String subject, Map<String, Object> claims, byte[] authorities, AccessToken accessToken) {
        Pair<String, Date> generated = this.generateJWT(accessToken.getKey(), subject, (Long)this.confDAO.find("jwt.lifetime.minutes", (Object)120L), claims);
        accessToken.setBody((String)generated.getLeft());
        accessToken.setExpiryTime((Date)generated.getRight());
        accessToken.setOwner(subject);
        if (!this.adminUser.equals(accessToken.getOwner())) {
            accessToken.setAuthorities(authorities);
        }
        return this.accessTokenDAO.save(accessToken);
    }

    public Pair<String, Date> create(String subject, Map<String, Object> claims, byte[] authorities, boolean replace) {
        AccessToken accessToken = this.accessTokenDAO.findByOwner(subject);
        if (accessToken == null) {
            accessToken = (AccessToken)this.entityFactory.newEntity(AccessToken.class);
            accessToken.setKey(UUID_GENERATOR.generate().toString());
            accessToken = this.replace(subject, claims, authorities, accessToken);
        } else if (replace) {
            accessToken = this.replace(subject, claims, authorities, accessToken);
        }
        return Pair.of((Object)accessToken.getBody(), (Object)accessToken.getExpiryTime());
    }

    public Pair<String, Date> update(AccessToken accessToken, byte[] authorities) {
        JwsJwtCompactConsumer consumer = new JwsJwtCompactConsumer(accessToken.getBody());
        this.credentialChecker.checkIsDefaultJWSKeyInUse();
        long duration = (Long)this.confDAO.find("jwt.lifetime.minutes", (Object)120L);
        long currentTime = new Date().getTime() / 1000L;
        long expiry = currentTime + 60L * duration;
        consumer.getJwtClaims().setExpiryTime(Long.valueOf(expiry));
        Date expiryDate = new Date(expiry * 1000L);
        JwsHeaders jwsHeaders = new JwsHeaders(JoseType.JWT, this.jwsSignatureProvider.getAlgorithm());
        JwtToken token = new JwtToken(jwsHeaders, consumer.getJwtClaims());
        JwsJwtCompactProducer producer = new JwsJwtCompactProducer(token);
        String body = producer.signWith((JwsSignatureProvider)this.jwsSignatureProvider);
        accessToken.setBody(body);
        accessToken.setExpiryTime(expiryDate);
        if (!this.adminUser.equals(accessToken.getOwner())) {
            accessToken.setAuthorities(authorities);
        }
        this.accessTokenDAO.save(accessToken);
        return Pair.of((Object)body, (Object)expiryDate);
    }

    public AccessTokenTO getAccessTokenTO(AccessToken accessToken) {
        AccessTokenTO accessTokenTO = new AccessTokenTO();
        BeanUtils.copyProperties((Object)accessToken, (Object)accessTokenTO);
        return accessTokenTO;
    }
}

