/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class IntAttrNameParser {
    private static final Pattern PRIVILEGE_PATTERN = Pattern.compile("^privileges\\[([\\p{L}\\p{gc=Mn}\\p{gc=Me}\\p{gc=Mc}\\p{Digit}\\p{gc=Pc} \\-@.]+)\\]");
    private static final Pattern ENCLOSING_GROUP_PATTERN = Pattern.compile("^groups\\[([\\p{L}\\p{gc=Mn}\\p{gc=Me}\\p{gc=Mc}\\p{Digit}\\p{gc=Pc} \\-@.]+)\\]\\.(.+)");
    private static final Pattern RELATED_USER_PATTERN = Pattern.compile("^users\\[([\\p{L}\\p{gc=Mn}\\p{gc=Me}\\p{gc=Mc}\\p{Digit}\\p{gc=Pc} \\-@.]+)\\]\\.(.+)");
    private static final Pattern RELATED_ANY_OBJECT_PATTERN = Pattern.compile("^anyObjects\\[([\\p{L}\\p{gc=Mn}\\p{gc=Me}\\p{gc=Mc}\\p{Digit}\\p{gc=Pc} \\-@.]+)\\]\\.(.+)");
    private static final Pattern MEMBERSHIP_PATTERN = Pattern.compile("^memberships\\[([\\p{L}\\p{gc=Mn}\\p{gc=Me}\\p{gc=Mc}\\p{Digit}\\p{gc=Pc} \\-@.]+)\\]\\.(.+)");
    private static final Pattern RELATIONSHIP_PATTERN = Pattern.compile("^relationships\\[([\\p{L}\\p{gc=Mn}\\p{gc=Me}\\p{gc=Mc}\\p{Digit}\\p{gc=Pc} \\-@.]+)\\]\\[([\\p{L}\\p{gc=Mn}\\p{gc=Me}\\p{gc=Mc}\\p{Digit}\\p{gc=Pc} \\-@.]+)\\]\\.(.+)");
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private DerSchemaDAO derSchemaDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;

    private SchemaType find(String key) {
        Schema schema = this.plainSchemaDAO.find(key);
        if (schema == null) {
            schema = this.derSchemaDAO.find(key);
            if (schema == null) {
                schema = this.virSchemaDAO.find(key);
                if (schema == null) {
                    return null;
                }
                return SchemaType.VIRTUAL;
            }
            return SchemaType.DERIVED;
        }
        return SchemaType.PLAIN;
    }

    private void setFieldOrSchemaName(String fieldOrSchemaName, AnyTypeKind anyTypeKind, IntAttrName result) {
        if (this.anyUtilsFactory.getInstance(anyTypeKind).isFieldName(fieldOrSchemaName)) {
            result.setField(fieldOrSchemaName);
        } else {
            result.setSchemaType(this.find(fieldOrSchemaName));
            result.setSchemaName(fieldOrSchemaName);
        }
    }

    @Transactional(readOnly=true)
    public IntAttrName parse(String intAttrName, AnyTypeKind provisionAnyTypeKind) throws ParseException {
        IntAttrName result = new IntAttrName();
        if (intAttrName.indexOf(46) == -1) {
            Matcher matcher = PRIVILEGE_PATTERN.matcher(intAttrName);
            if (matcher.matches()) {
                result.setAnyTypeKind(AnyTypeKind.USER);
                result.setPrivilegesOfApplication(matcher.group(1));
            } else {
                result.setAnyTypeKind(provisionAnyTypeKind);
                this.setFieldOrSchemaName(intAttrName, result.getAnyTypeKind(), result);
            }
        } else {
            Matcher matcher = ENCLOSING_GROUP_PATTERN.matcher(intAttrName);
            if (matcher.matches()) {
                result.setAnyTypeKind(AnyTypeKind.GROUP);
                result.setEnclosingGroup(matcher.group(1));
                this.setFieldOrSchemaName(matcher.group(2), result.getAnyTypeKind(), result);
            } else {
                matcher = RELATED_ANY_OBJECT_PATTERN.matcher(intAttrName);
                if (matcher.matches()) {
                    result.setAnyTypeKind(AnyTypeKind.ANY_OBJECT);
                    result.setRelatedAnyObject(matcher.group(1));
                    this.setFieldOrSchemaName(matcher.group(2), result.getAnyTypeKind(), result);
                } else {
                    matcher = MEMBERSHIP_PATTERN.matcher(intAttrName);
                    if (matcher.matches()) {
                        result.setAnyTypeKind(AnyTypeKind.USER);
                        result.setMembershipOfGroup(matcher.group(1));
                        this.setFieldOrSchemaName(matcher.group(2), result.getAnyTypeKind(), result);
                    } else {
                        matcher = RELATED_USER_PATTERN.matcher(intAttrName);
                        if (matcher.matches()) {
                            result.setAnyTypeKind(AnyTypeKind.USER);
                            result.setRelatedUser(matcher.group(1));
                            this.setFieldOrSchemaName(matcher.group(2), result.getAnyTypeKind(), result);
                        } else {
                            matcher = RELATIONSHIP_PATTERN.matcher(intAttrName);
                            if (matcher.matches()) {
                                result.setAnyTypeKind(AnyTypeKind.ANY_OBJECT);
                                result.setRelationshipType(matcher.group(1));
                                result.setRelationshipAnyType(matcher.group(2));
                                this.setFieldOrSchemaName(matcher.group(3), result.getAnyTypeKind(), result);
                            } else {
                                throw new ParseException("Unparsable expression: " + intAttrName, 0);
                            }
                        }
                    }
                }
            }
        }
        return result;
    }
}

