/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.java.jexl.JexlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Component
public class DerAttrHandlerImpl
implements DerAttrHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DerAttrHandler.class);
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;

    private Map<DerSchema, String> getValues(Any<?> any, Set<DerSchema> schemas) {
        HashMap<DerSchema, String> result = new HashMap<DerSchema, String>(schemas.size());
        schemas.forEach(schema -> {
            MapContext jexlContext = new MapContext();
            JexlUtils.addPlainAttrsToContext(any.getPlainAttrs(), (JexlContext)jexlContext);
            JexlUtils.addFieldsToContext(any, (JexlContext)jexlContext);
            result.put((DerSchema)schema, JexlUtils.evaluate(schema.getExpression(), (JexlContext)jexlContext));
        });
        return result;
    }

    public String getValue(Any<?> any, DerSchema schema) {
        if (!this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, DerSchema.class).forSelfContains((Schema)schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, any);
            return null;
        }
        return this.getValues(any, Collections.singleton(schema)).get(schema);
    }

    public String getValue(Any<?> any, Membership<?> membership, DerSchema schema) {
        if (!this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, DerSchema.class).getForMembership((Group)membership.getRightEnd()).contains(schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, any);
            return null;
        }
        return this.getValues(any, Collections.singleton(schema)).get(schema);
    }

    public Map<DerSchema, String> getValues(Any<?> any) {
        return this.getValues(any, this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, DerSchema.class).getForSelf());
    }

    private Map<DerSchema, String> getValues(GroupableRelatable<?, ?, ?, ?, ?> any, Membership<?> membership, Set<DerSchema> schemas) {
        HashMap<DerSchema, String> result = new HashMap<DerSchema, String>(schemas.size());
        schemas.forEach(schema -> {
            MapContext jexlContext = new MapContext();
            JexlUtils.addPlainAttrsToContext(any.getPlainAttrs(membership), (JexlContext)jexlContext);
            JexlUtils.addFieldsToContext(any, (JexlContext)jexlContext);
            result.put((DerSchema)schema, JexlUtils.evaluate(schema.getExpression(), (JexlContext)jexlContext));
        });
        return result;
    }

    public Map<DerSchema, String> getValues(GroupableRelatable<?, ?, ?, ?, ?> any, Membership<?> membership) {
        return this.getValues(any, membership, this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, DerSchema.class).getForMembership((Group)membership.getRightEnd()));
    }
}

