/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.util.concurrent.atomic.AtomicReference;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.ResultsHandlerConfiguration;
import org.identityconnectors.framework.api.operations.SyncApiOp;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.impl.api.local.operations.AttributesToGetResultsHandler;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorAPIOperationRunner;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;
import org.identityconnectors.framework.impl.api.local.operations.NormalizingSyncResultsHandler;
import org.identityconnectors.framework.impl.api.local.operations.SpiOperationLoggingUtil;
import org.identityconnectors.framework.spi.AttributeNormalizer;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.SyncTokenResultsHandler;
import org.identityconnectors.framework.spi.operations.SyncOp;

public class SyncImpl
extends ConnectorAPIOperationRunner
implements SyncApiOp {
    private static final Log OP_LOG = Log.getLog(SyncOp.class);
    private static final Log HANDLER_LOG = Log.getLog(SyncTokenResultsHandler.class);

    public SyncImpl(ConnectorOperationalContext context, Connector connector) {
        super(context, connector);
    }

    public SyncToken sync(ObjectClass objectClass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        Assertions.nullCheck((Object)objectClass, (String)"objectClass");
        Assertions.nullCheck((Object)handler, (String)"handler");
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        ResultsHandlerConfiguration hdlCfg = null != this.getOperationalContext() ? this.getOperationalContext().getResultsHandlerConfiguration() : new ResultsHandlerConfiguration();
        String[] attrsToGet = options.getAttributesToGet();
        if (attrsToGet != null && attrsToGet.length > 0 && hdlCfg.isEnableAttributesToGetSearchResultsHandler()) {
            handler = new AttributesToGetSyncResultsHandler(handler, attrsToGet);
        }
        if (this.getConnector() instanceof AttributeNormalizer && hdlCfg.isEnableNormalizingResultsHandler()) {
            handler = new NormalizingSyncResultsHandler(handler, this.getNormalizer(objectClass));
        }
        final SyncResultsHandler handlerChain = handler;
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        SyncTokenResultsHandler syncHandler = new SyncTokenResultsHandler(){

            public void handleResult(SyncToken token) {
                if (HANDLER_LOG.isLoggable(SpiOperationLoggingUtil.LOG_LEVEL)) {
                    HANDLER_LOG.log(SyncTokenResultsHandler.class, "handleResult", SpiOperationLoggingUtil.LOG_LEVEL, "Enter: handleResult(" + token + ")", null);
                }
                try {
                    result.compareAndSet(null, token);
                }
                catch (RuntimeException e) {
                    SpiOperationLoggingUtil.logOpException(HANDLER_LOG, SyncTokenResultsHandler.class, "handleResult", e);
                    throw e;
                }
                if (HANDLER_LOG.isLoggable(SpiOperationLoggingUtil.LOG_LEVEL)) {
                    HANDLER_LOG.log(SyncTokenResultsHandler.class, "handleResult", SpiOperationLoggingUtil.LOG_LEVEL, "Return", null);
                }
            }

            public boolean handle(SyncDelta delta) {
                boolean ret;
                if (HANDLER_LOG.isLoggable(SpiOperationLoggingUtil.LOG_LEVEL)) {
                    HANDLER_LOG.log(SyncTokenResultsHandler.class, "handle", SpiOperationLoggingUtil.LOG_LEVEL, "Enter: handle(" + delta + ")", null);
                }
                try {
                    ret = handlerChain.handle(delta);
                }
                catch (RuntimeException e) {
                    SpiOperationLoggingUtil.logOpException(HANDLER_LOG, SyncTokenResultsHandler.class, "handle", e);
                    throw e;
                }
                if (HANDLER_LOG.isLoggable(SpiOperationLoggingUtil.LOG_LEVEL)) {
                    HANDLER_LOG.log(SyncTokenResultsHandler.class, "handle", SpiOperationLoggingUtil.LOG_LEVEL, "Return: " + ret, null);
                }
                return ret;
            }
        };
        if (SyncImpl.isLoggable()) {
            StringBuilder bld = new StringBuilder();
            bld.append("Enter: sync(");
            bld.append(objectClass).append(", ");
            bld.append(token).append(", ");
            bld.append(syncHandler).append(", ");
            bld.append(options).append(")");
            String msg = bld.toString();
            OP_LOG.log(SyncOp.class, "sync", SpiOperationLoggingUtil.LOG_LEVEL, msg, null);
        }
        try {
            ((SyncOp)this.getConnector()).sync(objectClass, token, (SyncResultsHandler)syncHandler, options);
        }
        catch (RuntimeException e) {
            SpiOperationLoggingUtil.logOpException(OP_LOG, SyncOp.class, "sync", e);
            throw e;
        }
        if (SyncImpl.isLoggable()) {
            OP_LOG.log(SyncOp.class, "sync", SpiOperationLoggingUtil.LOG_LEVEL, "Return", null);
        }
        return result.get();
    }

    public SyncToken getLatestSyncToken(ObjectClass objectClass) {
        return ((SyncOp)this.getConnector()).getLatestSyncToken(objectClass);
    }

    private static boolean isLoggable() {
        return OP_LOG.isLoggable(SpiOperationLoggingUtil.LOG_LEVEL);
    }

    public static class AttributesToGetSyncResultsHandler
    extends AttributesToGetResultsHandler
    implements SyncResultsHandler {
        private final SyncResultsHandler handler;

        public AttributesToGetSyncResultsHandler(SyncResultsHandler handler, String[] attrsToGet) {
            super(attrsToGet);
            this.handler = handler;
        }

        public boolean handle(SyncDelta delta) {
            SyncDeltaBuilder bld = new SyncDeltaBuilder(delta);
            if (delta.getObject() != null) {
                bld.setObject(this.reduceToAttrsToGet(delta.getObject()));
            }
            return this.handler.handle(bld.build());
        }
    }
}

