/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Base64;
import org.identityconnectors.framework.common.objects.SyncToken;

class SyncTokenDeserializer
extends JsonDeserializer<SyncToken> {
    SyncTokenDeserializer() {
    }

    public SyncToken deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        ObjectNode tree = (ObjectNode)jp.readValueAsTree();
        Object value = null;
        if (tree.has("value")) {
            JsonNode node = tree.get("value");
            Object object = node.isNull() ? null : (node.isBoolean() ? Boolean.valueOf(node.asBoolean()) : (node.isDouble() ? Double.valueOf(node.asDouble()) : (node.isLong() ? Long.valueOf(node.asLong()) : (value = node.isInt() ? Integer.valueOf(node.asInt()) : node.asText()))));
            if (value instanceof String) {
                String base64 = (String)value;
                try {
                    value = Base64.getDecoder().decode(base64);
                }
                catch (RuntimeException e) {
                    value = base64;
                }
            }
        }
        return new SyncToken(value);
    }
}

