/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form;

import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.DateTextFieldConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.references.BootstrapDatepickerJsReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.references.BootstrapDatepickerLangJsReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.references.BootstrapDatepickerReference;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.json.JSONFunction;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class DateTextField
extends org.apache.wicket.extensions.markup.html.form.DateTextField {
    private static final long serialVersionUID = 3499287675713818823L;
    private static final String EVENT_PARAM = "datePickerEvent";
    private static final String DATE = "date";
    private final Map<Event, AbstractEventHandler> eventMap = new HashMap<Event, AbstractEventHandler>();
    private DateTextFieldConfig config;

    public DateTextField(String markupId) {
        this(markupId, new DateTextFieldConfig());
    }

    public DateTextField(String markupId, String datePattern) {
        this(markupId, new DateTextFieldConfig().withFormat(datePattern));
    }

    public DateTextField(String markupId, IModel<Date> model) {
        this(markupId, model, new DateTextFieldConfig());
    }

    public DateTextField(String markupId, IModel<Date> model, String dateFormat) {
        this(markupId, model, new DateTextFieldConfig().withFormat(dateFormat));
    }

    public DateTextField(String markupId, IModel<Date> model, DateTextFieldConfig config) {
        super(markupId, model, config.getFormat());
        this.config = (DateTextFieldConfig)((Object)Args.notNull((Object)((Object)config), (String)"config"));
    }

    public DateTextField(String markupId, DateTextFieldConfig config) {
        super(markupId, config.getFormat());
        this.config = (DateTextFieldConfig)((Object)Args.notNull((Object)((Object)config), (String)"config"));
    }

    protected void onInitialize() {
        super.onInitialize();
        this.setOutputMarkupId(true);
    }

    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "input");
        Attributes.set((ComponentTag)tag, (String)"type", (String)"text");
        super.onComponentTag(tag);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)BootstrapDatepickerReference.INSTANCE));
        if (!this.config.isDefaultLanguageSet()) {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new BootstrapDatepickerLangJsReference(this.config.getLanguage())));
        } else {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)BootstrapDatepickerJsReference.INSTANCE));
        }
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createScript(this.config)));
    }

    protected CharSequence createScript(DateTextFieldConfig config) {
        String script = JQuery.$((Component)this).chain((CharSequence)"datepicker", (Config)config, new Config[0]).get();
        if (this.eventMap.isEmpty()) {
            return script;
        }
        StringBuilder sb = new StringBuilder(script.subSequence(0, script.length() - 1));
        for (Event type : this.eventMap.keySet()) {
            sb.append(".on('").append((Object)type).append("',").append(this.eventMap.get((Object)type).getFunction()).append(')');
        }
        sb.append(';');
        return sb;
    }

    public final DateTextFieldConfig getConfig() {
        return this.config;
    }

    public DateTextField with(DateTextFieldConfig config) {
        if (config != null) {
            this.config = config;
        }
        return this;
    }

    public DateTextField addEvent(Event type, AbstractEventHandler handler) {
        this.eventMap.put(type, handler);
        return this;
    }

    public DateTextField addAjaxEvent(Event type, IAjaxEventHandler evenHandler) {
        this.addAjaxEvent(type, evenHandler, false);
        return this;
    }

    public DateTextField addAjaxEvent(Event type, IAjaxEventHandler evenHandler, boolean updateModel) {
        DatePickerAbstractDefaultAjaxBehavior datePickerAbstractDefaultAjaxBehavior = new DatePickerAbstractDefaultAjaxBehavior(type, evenHandler, updateModel);
        this.add(new Behavior[]{datePickerAbstractDefaultAjaxBehavior});
        this.addEvent(type, datePickerAbstractDefaultAjaxBehavior.abstractAjaxEvent);
        return this;
    }

    public DateTextField removeEvent(Event type) {
        this.eventMap.remove((Object)type);
        return this;
    }

    public String getDestroyScript() {
        return "$('#" + this.getMarkupId() + "').datepicker('destroy');";
    }

    private class DatePickerAbstractDefaultAjaxBehavior
    extends AbstractDefaultAjaxBehavior {
        private final AbstractAjaxEvent abstractAjaxEvent;

        public DatePickerAbstractDefaultAjaxBehavior(Event event, IAjaxEventHandler handler, boolean updateModel) {
            Args.notNull((Object)((Object)event), (String)"event");
            Args.notNull((Object)handler, (String)"handler");
            this.abstractAjaxEvent = this.createNew(event, handler, updateModel);
        }

        protected AbstractAjaxEvent createNew(Event event, IAjaxEventHandler handler, boolean updateModel) {
            return new AbstractAjaxEvent(event, handler, updateModel){

                @Override
                protected CharSequence getBody() {
                    return DatePickerAbstractDefaultAjaxBehavior.this.getCallbackScript().toString();
                }
            };
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            this.abstractAjaxEvent.updateAjaxAttributes(attributes);
        }

        protected void respond(AjaxRequestTarget target) {
            this.abstractAjaxEvent.onAjaxEvent(target);
        }
    }

    private abstract class AbstractAjaxEvent
    extends AbstractEventHandler {
        private final Event event;
        private final IAjaxEventHandler handler;
        private final boolean updateModel;

        public AbstractAjaxEvent(Event event, IAjaxEventHandler handler, boolean updateModel) {
            this.event = event;
            this.handler = handler;
            this.updateModel = updateModel;
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            attributes.getExtraParameters().put(DateTextField.EVENT_PARAM, this.event.name());
            attributes.getExtraParameters().put(DateTextField.DATE, new JSONFunction((CharSequence)"e.format()"));
        }

        protected void onAjaxEvent(AjaxRequestTarget target) {
            Date date;
            String dateStr = RequestCycle.get().getRequest().getRequestParameters().getParameterValue(DateTextField.DATE).toString(null);
            Date date2 = date = !Strings.isEmpty((CharSequence)dateStr) ? (Date)DateTextField.this.getConverter(Date.class).convertToObject(dateStr, RequestCycle.get().getRequest().getLocale()) : null;
            if (this.updateModel) {
                DateTextField.this.setDefaultModelObject(date);
            }
            this.handler.onAjaxEvent(target, date, this.event);
        }
    }

    public static interface IAjaxEventHandler
    extends Serializable {
        public void onAjaxEvent(AjaxRequestTarget var1, Date var2, Event var3);
    }

    public abstract class AbstractEventHandler
    implements Serializable {
        protected abstract CharSequence getBody();

        protected String getFunction() {
            StringBuilder sb = new StringBuilder("function(e) {\n");
            sb.append(this.getBody());
            sb.append("\n}");
            return sb.toString();
        }
    }

    public static enum Event {
        show,
        hide,
        clearDate,
        changeDate,
        changeMonth,
        changeYear,
        changeDecade,
        changeCentury;

    }
}

