/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.AttachManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.kernel.TransferFieldManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.UserException;

abstract class AttachStrategy
extends TransferFieldManager {
    private static final Localizer _loc = Localizer.forPackage(AttachStrategy.class);

    AttachStrategy() {
    }

    public abstract Object attach(AttachManager var1, Object var2, ClassMetaData var3, PersistenceCapable var4, OpenJPAStateManager var5, ValueMetaData var6, boolean var7);

    protected abstract Object getDetachedObjectId(AttachManager var1, Object var2);

    protected abstract void provideField(Object var1, StateManagerImpl var2, int var3);

    protected StateManagerImpl persist(AttachManager manager, PersistenceCapable pc, ClassMetaData meta, Object appId, boolean explicit) {
        PersistenceCapable newInstance = !manager.getCopyNew() ? pc : (appId == null ? pc.pcNewInstance(null, false) : pc.pcNewInstance(null, appId, false));
        StateManagerImpl sm = (StateManagerImpl)manager.getBroker().persist(newInstance, appId, explicit, manager.getBehavior(), !manager.getCopyNew());
        this.attachPCKeyFields(pc, sm, meta, manager);
        return sm;
    }

    private void attachPCKeyFields(PersistenceCapable fromPC, StateManagerImpl sm, ClassMetaData meta, AttachManager manager) {
        if (fromPC.pcGetStateManager() == null) {
            FieldMetaData[] fmds;
            fromPC.pcReplaceStateManager(sm);
            for (FieldMetaData fmd : fmds = meta.getDefinedFields()) {
                if (!fmd.isPrimaryKey() || fmd.getDeclaredTypeCode() != 15) continue;
                this.attachField(manager, fromPC, sm, fmd, true);
            }
            fromPC.pcReplaceStateManager(null);
        }
    }

    protected boolean attachField(AttachManager manager, Object toAttach, StateManagerImpl sm, FieldMetaData fmd, boolean nullLoaded) {
        if (fmd.isVersion() || fmd.getManagement() != 3) {
            return false;
        }
        PersistenceCapable into = sm.getPersistenceCapable();
        int i = fmd.getIndex();
        this.provideField(toAttach, sm, i);
        int set = 2;
        switch (fmd.getDeclaredTypeCode()) {
            case 0: {
                sm.settingBooleanField(into, i, sm.fetchBooleanField(i), this.fetchBooleanField(i), set);
                break;
            }
            case 1: {
                sm.settingByteField(into, i, sm.fetchByteField(i), this.fetchByteField(i), set);
                break;
            }
            case 2: {
                sm.settingCharField(into, i, sm.fetchCharField(i), this.fetchCharField(i), set);
                break;
            }
            case 3: {
                sm.settingDoubleField(into, i, sm.fetchDoubleField(i), this.fetchDoubleField(i), set);
                break;
            }
            case 4: {
                sm.settingFloatField(into, i, sm.fetchFloatField(i), this.fetchFloatField(i), set);
                break;
            }
            case 5: {
                sm.settingIntField(into, i, sm.fetchIntField(i), this.fetchIntField(i), set);
                break;
            }
            case 6: {
                sm.settingLongField(into, i, sm.fetchLongField(i), this.fetchLongField(i), set);
                break;
            }
            case 7: {
                sm.settingShortField(into, i, sm.fetchShortField(i), this.fetchShortField(i), set);
                break;
            }
            case 9: {
                String sval = this.fetchStringField(i);
                if (sval == null && !nullLoaded) {
                    return false;
                }
                sm.settingStringField(into, i, sm.fetchStringField(i), sval, set);
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: {
                Object val = this.fetchObjectField(i);
                if (val == null && !nullLoaded) {
                    return false;
                }
                sm.settingObjectField(into, i, sm.fetchObjectField(i), val, set);
                break;
            }
            case 15: 
            case 27: {
                PersistenceCapable topc;
                Object frmpc = this.fetchObjectField(i);
                if (frmpc == null && !nullLoaded) {
                    return false;
                }
                OpenJPAStateManager tosm = manager.getBroker().getStateManager(sm.fetchObjectField(i));
                PersistenceCapable persistenceCapable = topc = tosm == null ? null : tosm.getPersistenceCapable();
                if (frmpc == null && topc == null) break;
                if (fmd.getCascadeAttach() == 0) {
                    PersistenceCapable cpy = manager.getAttachedCopy(frmpc);
                    frmpc = cpy != null ? cpy : this.getReference(manager, frmpc, sm, fmd);
                } else {
                    PersistenceCapable intopc = topc;
                    if (!fmd.isEmbeddedPC() && frmpc != null && topc != null && !Objects.equals(topc.pcFetchObjectId(), manager.getDetachedObjectId(frmpc))) {
                        intopc = null;
                    }
                    frmpc = manager.attach(frmpc, intopc, sm, fmd, false);
                }
                if (frmpc == topc) break;
                sm.settingObjectField(into, i, topc, frmpc, set);
                break;
            }
            case 12: {
                Collection frmc = (Collection)this.fetchObjectField(i);
                if (frmc == null && !nullLoaded) {
                    return false;
                }
                Collection toc = (Collection)sm.fetchObjectField(i);
                if ((toc == null || toc.isEmpty()) && (frmc == null || frmc.isEmpty())) break;
                if (frmc == null) {
                    sm.settingObjectField(into, i, toc, null, set);
                    break;
                }
                if (toc == null) {
                    sm.settingObjectField(into, i, null, this.attachCollection(manager, frmc, sm, fmd), set);
                    break;
                }
                if (toc instanceof Set && frmc instanceof Set) {
                    this.replaceCollection(manager, frmc, toc, sm, fmd);
                    break;
                }
                sm.settingObjectField(into, i, toc, this.replaceList(manager, frmc, toc, sm, fmd), set);
                break;
            }
            case 13: {
                Map frmm = (Map)this.fetchObjectField(i);
                if (frmm == null && !nullLoaded) {
                    return false;
                }
                Map tom = (Map)sm.fetchObjectField(i);
                if ((tom == null || tom.isEmpty()) && (frmm == null || frmm.isEmpty())) break;
                if (frmm == null) {
                    sm.settingObjectField(into, i, tom, null, set);
                    break;
                }
                if (tom == null) {
                    sm.settingObjectField(into, i, null, this.attachMap(manager, frmm, sm, fmd), set);
                    break;
                }
                this.replaceMap(manager, frmm, tom, sm, fmd);
                break;
            }
            case 11: {
                Object frma = this.fetchObjectField(i);
                if (frma == null && !nullLoaded) {
                    return false;
                }
                Object toa = sm.fetchObjectField(i);
                if ((toa == null || Array.getLength(toa) <= 0) && (frma == null || Array.getLength(frma) <= 0)) break;
                if (frma == null) {
                    sm.settingObjectField(into, i, toa, null, set);
                    break;
                }
                sm.settingObjectField(into, i, toa, this.replaceArray(manager, frma, toa, sm, fmd), set);
                break;
            }
            default: {
                throw new InternalException(fmd.toString());
            }
        }
        return true;
    }

    protected Object getReference(AttachManager manager, Object toAttach, OpenJPAStateManager sm, ValueMetaData vmd) {
        Object oid;
        if (toAttach == null) {
            return null;
        }
        if (manager.getBroker().isNew(toAttach)) {
            PersistenceCapable pc = manager.getAttachedCopy(toAttach);
            if (pc != null) {
                return pc;
            }
            return toAttach;
        }
        if (manager.getBroker().isPersistent(toAttach)) {
            return toAttach;
        }
        if (manager.getBroker().isDetached(toAttach) && (oid = manager.getDetachedObjectId(toAttach)) != null) {
            return manager.getBroker().find(oid, false, null);
        }
        throw new UserException(_loc.get("cant-cascade-attach", (Object)vmd)).setFailedObject(toAttach);
    }

    private void replaceCollection(AttachManager manager, Collection frmc, Collection toc, OpenJPAStateManager sm, FieldMetaData fmd) {
        if (frmc.isEmpty()) {
            if (!toc.isEmpty()) {
                toc.clear();
            }
            return;
        }
        boolean pc = fmd.getElement().isDeclaredTypePC();
        if (pc) {
            frmc = this.attachCollection(manager, frmc, sm, fmd);
        }
        toc.retainAll(frmc);
        if (frmc.size() != toc.size()) {
            for (Object ob : frmc) {
                if (toc.contains(ob)) continue;
                toc.add(ob);
            }
        }
    }

    protected Collection attachCollection(AttachManager manager, Collection orig, OpenJPAStateManager sm, FieldMetaData fmd) {
        Collection coll = this.copyCollection(manager, orig, fmd, sm);
        ValueMetaData vmd = fmd.getElement();
        if (!vmd.isDeclaredTypePC()) {
            return coll;
        }
        coll.clear();
        Iterator itr = orig.iterator();
        while (itr.hasNext()) {
            Object elem = vmd.getCascadeAttach() == 0 ? this.getReference(manager, itr.next(), sm, vmd) : manager.attach(itr.next(), null, sm, vmd, false);
            coll.add(elem);
        }
        return coll;
    }

    private Collection copyCollection(AttachManager manager, Collection orig, FieldMetaData fmd) {
        Collection coll = manager.getProxyManager().copyCollection(orig);
        if (coll == null) {
            throw new UserException(_loc.get("not-copyable", (Object)fmd));
        }
        return coll;
    }

    private Collection copyCollection(AttachManager manager, Collection orig, FieldMetaData fmd, OpenJPAStateManager sm) {
        if (orig == null) {
            throw new UserException(_loc.get("not-copyable", (Object)fmd));
        }
        try {
            return this.copyCollection(manager, orig, fmd);
        }
        catch (Exception e) {
            Collection coll = (Collection)sm.newFieldProxy(fmd.getIndex());
            coll.addAll(orig);
            return coll;
        }
    }

    private Map copyMap(AttachManager manager, Map orig, FieldMetaData fmd, OpenJPAStateManager sm) {
        if (orig == null) {
            throw new UserException(_loc.get("not-copyable", (Object)fmd));
        }
        try {
            return manager.getProxyManager().copyMap(orig);
        }
        catch (Exception e) {
            Map map = (Map)sm.newFieldProxy(fmd.getIndex());
            for (Map.Entry entry : orig.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
            return map;
        }
    }

    private Collection replaceList(AttachManager manager, Collection frml, Collection tol, OpenJPAStateManager sm, FieldMetaData fmd) {
        boolean pc = fmd.getElement().isDeclaredTypePC();
        if (pc) {
            frml = this.attachCollection(manager, frml, sm, fmd);
        }
        if (frml.size() >= tol.size()) {
            Iterator frmi = frml.iterator();
            Iterator toi = tol.iterator();
            while (toi.hasNext()) {
                if (AttachStrategy.equals(frmi.next(), toi.next(), pc)) continue;
                return pc ? frml : this.copyCollection(manager, frml, fmd, sm);
            }
            while (frmi.hasNext()) {
                tol.add(frmi.next());
            }
            return tol;
        }
        return pc ? frml : this.copyCollection(manager, frml, fmd, sm);
    }

    private void replaceMap(AttachManager manager, Map frmm, Map tom, OpenJPAStateManager sm, FieldMetaData fmd) {
        if (frmm.isEmpty()) {
            if (!tom.isEmpty()) {
                tom.clear();
            }
            return;
        }
        boolean keyPC = fmd.getKey().isDeclaredTypePC();
        boolean valPC = fmd.getElement().isDeclaredTypePC();
        if (keyPC || valPC) {
            frmm = this.attachMap(manager, frmm, sm, fmd);
        }
        for (Map.Entry entry : frmm.entrySet()) {
            if (tom.containsKey(entry.getKey()) && AttachStrategy.equals(tom.get(entry.getKey()), entry.getValue(), valPC)) continue;
            tom.put(entry.getKey(), entry.getValue());
        }
        if (tom.size() != frmm.size()) {
            Iterator i = tom.keySet().iterator();
            while (i.hasNext()) {
                if (frmm.containsKey(i.next())) continue;
                i.remove();
            }
        }
    }

    protected Map attachMap(AttachManager manager, Map orig, OpenJPAStateManager sm, FieldMetaData fmd) {
        Map map = this.copyMap(manager, orig, fmd, sm);
        if (map == null) {
            throw new UserException(_loc.get("not-copyable", (Object)fmd));
        }
        ValueMetaData keymd = fmd.getKey();
        ValueMetaData valmd = fmd.getElement();
        if (!keymd.isDeclaredTypePC() && !valmd.isDeclaredTypePC()) {
            return map;
        }
        if (keymd.isDeclaredTypePC()) {
            map.clear();
            for (Map.Entry entry : orig.entrySet()) {
                Object key = entry.getKey();
                key = keymd.getCascadeAttach() == 0 ? this.getReference(manager, key, sm, keymd) : manager.attach(key, null, sm, keymd, false);
                Object val = entry.getValue();
                if (valmd.isDeclaredTypePC()) {
                    val = valmd.getCascadeAttach() == 0 ? this.getReference(manager, val, sm, valmd) : manager.attach(val, null, sm, valmd, false);
                }
                map.put(key, val);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                Object val = valmd.getCascadeAttach() == 0 ? this.getReference(manager, entry.getValue(), sm, valmd) : manager.attach(entry.getValue(), null, sm, valmd, false);
                entry.setValue(val);
            }
        }
        return map;
    }

    private Object replaceArray(AttachManager manager, Object frma, Object toa, OpenJPAStateManager sm, FieldMetaData fmd) {
        int len = Array.getLength(frma);
        boolean diff = toa == null || len != Array.getLength(toa);
        Object newa = Array.newInstance(fmd.getElement().getDeclaredType(), len);
        ValueMetaData vmd = fmd.getElement();
        boolean pc = vmd.isDeclaredTypePC();
        for (int i = 0; i < len; ++i) {
            Object elem = Array.get(frma, i);
            if (pc) {
                elem = vmd.getCascadeAttach() == 0 ? this.getReference(manager, elem, sm, vmd) : manager.attach(elem, null, sm, vmd, false);
            }
            diff = diff || !AttachStrategy.equals(elem, Array.get(toa, i), pc);
            Array.set(newa, i, elem);
        }
        return diff ? newa : toa;
    }

    private static boolean equals(Object a, Object b, boolean pc) {
        if (a == b) {
            return true;
        }
        if (pc || a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }
}

