/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.scheduler;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import com.googlecode.wicket.jquery.core.utils.DateUtils;
import com.googlecode.wicket.jquery.core.utils.JsonUtils;
import com.googlecode.wicket.kendo.ui.scheduler.ISchedulerConverter;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerEvent;
import com.googlecode.wicket.kendo.ui.scheduler.resource.ResourceList;
import java.util.Date;
import java.util.List;

public class SchedulerConverter
implements ISchedulerConverter {
    private static final long serialVersionUID = 1L;

    @Override
    public JSONObject toJson(SchedulerEvent event) {
        JSONObject object = new JSONObject();
        object.put("id", event.getId());
        object.put("isAllDay", event.isAllDay());
        object.putOpt("title", (Object)event.getTitle());
        object.putOpt("description", (Object)event.getDescription());
        if (event.getStart() != null) {
            object.put("start", (Object)DateUtils.toUTCString((Date)event.getStart()));
        }
        if (event.getEnd() != null) {
            object.put("end", (Object)DateUtils.toUTCString((Date)event.getEnd()));
        }
        object.putOpt("recurrenceId", (Object)event.getRecurrenceId());
        object.putOpt("recurrenceRule", (Object)event.getRecurrenceRule());
        object.putOpt("recurrenceException", (Object)event.getRecurrenceException());
        for (String field : event.getFields()) {
            object.put(field, event.getValue(field));
        }
        return object;
    }

    @Override
    public SchedulerEvent toObject(JSONObject object, List<ResourceList> lists) {
        SchedulerEvent event = this.newSchedulerEvent();
        event.setId(object.get("id"));
        event.setTitle(object.optString("title"));
        event.setDescription(object.optString("description"));
        event.setStart(object.getLong("start"));
        event.setEnd(object.getLong("end"));
        event.setAllDay(object.getBoolean("isAllDay"));
        event.setRecurrenceId(object.optString("recurrenceId"));
        event.setRecurrenceRule(object.optString("recurrenceRule"));
        event.setRecurrenceException(object.optString("recurrenceException"));
        for (ResourceList list : lists) {
            String field = list.getField();
            Object value = object.opt(field);
            if (list.isMultiple() && value instanceof JSONArray) {
                event.setValue(field, JsonUtils.toList((JSONArray)((JSONArray)value)));
                continue;
            }
            event.setValue(field, value);
        }
        return event;
    }

    protected SchedulerEvent newSchedulerEvent() {
        return new SchedulerEvent();
    }
}

