/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.cache.NullCacheKey;
import org.apache.ibatis.reflection.ArrayUtil;

public class CacheKey
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1146682552656046210L;
    public static final CacheKey NULL_CACHE_KEY = new NullCacheKey();
    private static final int DEFAULT_MULTIPLYER = 37;
    private static final int DEFAULT_HASHCODE = 17;
    private final int multiplier;
    private int hashcode = 17;
    private long checksum;
    private int count = 0;
    private transient List<Object> updateList = new ArrayList<Object>();

    public CacheKey() {
        this.multiplier = 37;
    }

    public CacheKey(Object[] objects) {
        this();
        this.updateAll(objects);
    }

    public int getUpdateCount() {
        return this.updateList.size();
    }

    public void update(Object object) {
        int baseHashCode = object == null ? 1 : ArrayUtil.hashCode(object);
        ++this.count;
        this.checksum += (long)baseHashCode;
        this.hashcode = this.multiplier * this.hashcode + (baseHashCode *= this.count);
        this.updateList.add(object);
    }

    public void updateAll(Object[] objects) {
        for (Object o : objects) {
            this.update(o);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CacheKey)) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)object;
        if (this.hashcode != cacheKey.hashcode) {
            return false;
        }
        if (this.checksum != cacheKey.checksum) {
            return false;
        }
        if (this.count != cacheKey.count) {
            return false;
        }
        for (int i = 0; i < this.updateList.size(); ++i) {
            Object thatObject;
            Object thisObject = this.updateList.get(i);
            if (ArrayUtil.equals(thisObject, thatObject = cacheKey.updateList.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        StringBuilder returnValue = new StringBuilder().append(this.hashcode).append(':').append(this.checksum);
        for (Object object : this.updateList) {
            returnValue.append(':').append(ArrayUtil.toString(object));
        }
        return returnValue.toString();
    }

    public CacheKey clone() throws CloneNotSupportedException {
        CacheKey clonedCacheKey = (CacheKey)super.clone();
        clonedCacheKey.updateList = new ArrayList<Object>(this.updateList);
        return clonedCacheKey;
    }
}

