/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.request;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.util.string.Strings;

enum UserAgent {
    MOZILLA("Opera,AppleWebKit,Konqueror,Trident", Arrays.asList("Mozilla", "Gecko")),
    FIREFOX("Opera,AppleWebKit,Konqueror,Trident,Edge", Arrays.asList("Mozilla", "Gecko", "Firefox")),
    INTERNET_EXPLORER("Opera,Edge", Arrays.asList("Mozilla", "MSIE", "Windows"), Arrays.asList("Mozilla", "MSIE", "Trident"), Arrays.asList("Mozilla", "MSIE", "Mac_PowerPC"), Arrays.asList("Mozilla", "Windows", "Trident", "like Gecko")),
    OPERA(Arrays.asList("Opera")),
    CHROME("Edge", Arrays.asList("Mozilla", "Chrome", "AppleWebKit", "Safari")),
    SAFARI("Chrome,Edge", Arrays.asList("Mozilla", "AppleWebKit", "Safari")),
    KONQUEROR(Arrays.asList("Konqueror")),
    EDGE("Opera,Konqueror,Trident", Arrays.asList("Edge", "Mozilla", "Chrome", "Safari"));

    private final String[] notAllowedList;
    private final List<String>[] detectionStrings;

    private UserAgent(String notAllowed, List<String> ... detectionStrings) {
        this.notAllowedList = Strings.split((String)notAllowed, (char)',');
        this.detectionStrings = detectionStrings;
    }

    private UserAgent(List<String> ... detectionStrings) {
        this((String)null, detectionStrings);
    }

    public boolean matches(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        if (this.notAllowedList != null) {
            for (String value : this.notAllowedList) {
                if (!userAgent.contains(value)) continue;
                return false;
            }
        }
        for (List<String> detectionGroup : this.detectionStrings) {
            boolean groupPassed = true;
            Iterator iterator = detectionGroup.iterator();
            while (iterator.hasNext()) {
                String detectionString = (String)iterator.next();
                if (userAgent.contains(detectionString)) continue;
                groupPassed = false;
                break;
            }
            if (!groupPassed) continue;
            return true;
        }
        return false;
    }
}

