/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousPageStore
implements IPageStore {
    private static final Logger log = LoggerFactory.getLogger(AsynchronousPageStore.class);
    private static final long OFFER_WAIT = 30L;
    private static final long POLL_WAIT = 1000L;
    private final Thread pageSavingThread;
    private final IPageStore delegate;
    private final BlockingQueue<Entry> entries;
    private final ConcurrentMap<String, Entry> entryMap;

    public AsynchronousPageStore(IPageStore delegate, int capacity) {
        this.delegate = (IPageStore)Args.notNull((Object)delegate, (String)"delegate");
        this.entries = new LinkedBlockingQueue<Entry>(capacity);
        this.entryMap = new ConcurrentHashMap<String, Entry>();
        PageSavingRunnable savingRunnable = new PageSavingRunnable(delegate, this.entries, this.entryMap);
        this.pageSavingThread = new Thread((Runnable)savingRunnable, "Wicket-AsyncPageStore-PageSavingThread");
        this.pageSavingThread.setDaemon(true);
        this.pageSavingThread.start();
    }

    private Entry getEntry(String sessionId, int pageId) {
        return (Entry)this.entryMap.get(AsynchronousPageStore.getKey(sessionId, pageId));
    }

    private static String getKey(String sessionId, int pageId) {
        return pageId + ":::" + sessionId;
    }

    private static String getKey(Entry entry) {
        return AsynchronousPageStore.getKey(entry.sessionId, entry.page.getPageId());
    }

    @Override
    public void destroy() {
        if (this.pageSavingThread.isAlive()) {
            this.pageSavingThread.interrupt();
            try {
                this.pageSavingThread.join();
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.delegate.destroy();
    }

    @Override
    public IManageablePage getPage(String sessionId, int pageId) {
        Entry entry = this.getEntry(sessionId, pageId);
        if (entry != null) {
            log.debug("Returning the page of a non-stored entry with session id '{}' and page id '{}'", (Object)sessionId, (Object)pageId);
            return entry.page;
        }
        IManageablePage page = this.delegate.getPage(sessionId, pageId);
        log.debug("Returning the page of a stored entry with session id '{}' and page id '{}'", (Object)sessionId, (Object)pageId);
        return page;
    }

    @Override
    public void removePage(String sessionId, int pageId) {
        Entry entry;
        String key = AsynchronousPageStore.getKey(sessionId, pageId);
        if (key != null && (entry = (Entry)this.entryMap.remove(key)) != null) {
            this.entries.remove(entry);
        }
        this.delegate.removePage(sessionId, pageId);
    }

    @Override
    public void storePage(String sessionId, IManageablePage page) {
        Entry entry = new Entry(sessionId, page);
        String key = AsynchronousPageStore.getKey(entry);
        this.entryMap.put(key, entry);
        try {
            if (this.entries.offer(entry, 30L, TimeUnit.MILLISECONDS)) {
                log.debug("Offered for storing asynchronously page with id '{}' in session '{}'", (Object)page.getPageId(), (Object)sessionId);
            } else {
                log.debug("Storing synchronously page with id '{}' in session '{}'", (Object)page.getPageId(), (Object)sessionId);
                this.entryMap.remove(key);
                this.delegate.storePage(sessionId, page);
            }
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.entryMap.remove(key);
            this.delegate.storePage(sessionId, page);
        }
    }

    @Override
    public void unbind(String sessionId) {
        this.delegate.unbind(sessionId);
    }

    @Override
    public Serializable prepareForSerialization(String sessionId, Serializable page) {
        return this.delegate.prepareForSerialization(sessionId, page);
    }

    @Override
    public Object restoreAfterSerialization(Serializable serializable) {
        return this.delegate.restoreAfterSerialization(serializable);
    }

    @Override
    public IManageablePage convertToPage(Object page) {
        return this.delegate.convertToPage(page);
    }

    @Override
    public boolean canBeAsynchronous() {
        return false;
    }

    private static class PageSavingRunnable
    implements Runnable {
        private static final Logger log = LoggerFactory.getLogger(PageSavingRunnable.class);
        private final BlockingQueue<Entry> entries;
        private final ConcurrentMap<String, Entry> entryMap;
        private final IPageStore delegate;

        private PageSavingRunnable(IPageStore delegate, BlockingQueue<Entry> entries, ConcurrentMap<String, Entry> entryMap) {
            this.delegate = delegate;
            this.entries = entries;
            this.entryMap = entryMap;
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                Entry entry = null;
                try {
                    entry = this.entries.poll(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (entry == null) continue;
                log.debug("Saving asynchronously: {}...", (Object)entry);
                this.delegate.storePage(entry.sessionId, entry.page);
                this.entryMap.remove(AsynchronousPageStore.getKey(entry));
            }
        }
    }

    private static class Entry {
        private final String sessionId;
        private final IManageablePage page;

        public Entry(String sessionId, IManageablePage page) {
            this.sessionId = (String)Args.notNull((Object)sessionId, (String)"sessionId");
            this.page = (IManageablePage)Args.notNull((Object)page, (String)"page");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.page.getPageId();
            result = 31 * result + this.sessionId.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.page.getPageId() != other.page.getPageId()) {
                return false;
            }
            return this.sessionId.equals(other.sessionId);
        }

        public String toString() {
            return "Entry [sessionId=" + this.sessionId + ", pageId=" + this.page.getPageId() + "]";
        }
    }
}

