/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.syncope.client.console.panels.AnyDirectoryPanel;
import org.apache.syncope.client.console.panels.ListViewPanel;
import org.apache.syncope.client.console.panels.search.AnyObjectSearchPanel;
import org.apache.syncope.client.console.panels.search.AnyObjectSelectionDirectoryPanel;
import org.apache.syncope.client.console.panels.search.AnySelectionDirectoryPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchClausePanel;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.RelationshipTypeRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.ajax.markup.html.LabelInfo;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.console.wizards.any.UserWrapper;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.wizard.IWizard;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;

public class Relationships
extends WizardStep
implements WizardModel.ICondition {
    private static final long serialVersionUID = 855618618337931784L;
    private final PageReference pageRef;
    private final AnyTypeRestClient anyTypeRestClient = new AnyTypeRestClient();
    private final AnyTypeClassRestClient anyTypeClassRestClient = new AnyTypeClassRestClient();
    private final AnyTO anyTO;
    private final RelationshipTypeRestClient relationshipTypeRestClient = new RelationshipTypeRestClient();

    public Relationships(AnyWrapper<?> modelObject, PageReference pageRef) {
        this.add(new Component[]{new Label("title", (IModel)new ResourceModel("any.relationships"))});
        if (modelObject instanceof UserWrapper && ((UserWrapper)UserWrapper.class.cast(modelObject)).getPreviousUserTO() != null && !ListUtils.isEqualList((Collection)((UserTO)((UserWrapper)UserWrapper.class.cast(modelObject)).getInnerObject()).getRelationships(), (Collection)((UserWrapper)UserWrapper.class.cast(modelObject)).getPreviousUserTO().getRelationships())) {
            this.add(new Component[]{new LabelInfo("changed", "")});
        } else {
            this.add(new Component[]{new Label("changed", (Serializable)((Object)""))});
        }
        this.anyTO = modelObject.getInnerObject();
        this.pageRef = pageRef;
        this.add(new Component[]{this.getViewFragment().setRenderBodyOnly(true)});
    }

    public Component getHeader(String id, Component parent, IWizard wizard) {
        return super.getHeader(id, parent, wizard).setVisible(false);
    }

    private Fragment getViewFragment() {
        final HashMap<String, List<RelationshipTO>> relationships = new HashMap<String, List<RelationshipTO>>();
        this.addRelationship(relationships, this.getCurrentRelationships().toArray(new RelationshipTO[0]));
        Fragment viewFragment = new Fragment("relationships", "viewFragment", (MarkupContainer)this);
        viewFragment.setOutputMarkupId(true);
        viewFragment.add(new Component[]{new Accordion("relationships", relationships.keySet().stream().map(relationship -> new AbstractTab((IModel)new ResourceModel("relationship", relationship), (String)relationship){
            private static final long serialVersionUID = 1037272333056449378L;
            final /* synthetic */ String val$relationship;
            {
                this.val$relationship = string;
                super(x0);
            }

            public Panel getPanel(String panelId) {
                return new ListViewPanel.Builder<RelationshipTO>(RelationshipTO.class, Relationships.this.pageRef).setItems((List)relationships.get(this.val$relationship)).includes("otherEndType", "otherEndKey").addAction(new ActionLink<RelationshipTO>(){
                    private static final long serialVersionUID = -6847033126124401556L;

                    @Override
                    public void onClick(AjaxRequestTarget target, RelationshipTO modelObject) {
                        Relationships.this.removeRelationships(relationships, new RelationshipTO[]{modelObject});
                        Relationships.this.send((IEventSink)Relationships.this, Broadcast.DEPTH, new ListViewPanel.ListViewReload(target));
                    }
                }, ActionLink.ActionType.DELETE, AnyEntitlement.UPDATE.getFor(Relationships.this.anyTO.getType()), true).build(panelId);
            }
        }).collect(Collectors.toList())){
            private static final long serialVersionUID = 1037272333056449379L;

            public void renderHead(IHeaderResponse response) {
                super.renderHead(response);
                if (relationships.isEmpty()) {
                    response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)String.format("$('#emptyPlaceholder').append(\"%s\")", this.getString("relationships.empty.list"))));
                }
            }
        }});
        ActionsPanel<RelationshipTO> panel = new ActionsPanel<RelationshipTO>("actions", null);
        viewFragment.add(new Component[]{panel});
        panel.add(new ActionLink<RelationshipTO>(){
            private static final long serialVersionUID = 3257738274365467945L;

            @Override
            public void onClick(AjaxRequestTarget target, RelationshipTO ignore) {
                Fragment addFragment = new Fragment("relationships", "addFragment", (MarkupContainer)Relationships.this);
                Relationships.this.addOrReplace(new Component[]{addFragment});
                addFragment.add(new Component[]{new Specification().setRenderBodyOnly(true)});
                target.add(new Component[]{Relationships.this});
            }
        }, ActionLink.ActionType.CREATE, AnyEntitlement.UPDATE.getFor(this.anyTO.getType())).hideLabel();
        return viewFragment;
    }

    private List<RelationshipTO> getCurrentRelationships() {
        return this.anyTO instanceof GroupableRelatableTO ? ((GroupableRelatableTO)GroupableRelatableTO.class.cast(this.anyTO)).getRelationships() : Collections.emptyList();
    }

    private void addRelationship(Map<String, List<RelationshipTO>> relationships, RelationshipTO ... rels) {
        for (RelationshipTO relationship : rels) {
            List<Object> listrels;
            if (relationships.containsKey(relationship.getType())) {
                listrels = relationships.get(relationship.getType());
            } else {
                listrels = new ArrayList();
                relationships.put(relationship.getType(), listrels);
            }
            listrels.add(relationship);
        }
    }

    private void addNewRelationships(RelationshipTO ... rels) {
        this.getCurrentRelationships().addAll(Arrays.asList(rels));
    }

    private void removeRelationships(Map<String, List<RelationshipTO>> relationships, RelationshipTO ... rels) {
        List<RelationshipTO> currentRels = this.getCurrentRelationships();
        for (RelationshipTO relationship : rels) {
            currentRels.remove(relationship);
            if (!relationships.containsKey(relationship.getType())) continue;
            List<RelationshipTO> rellist = relationships.get(relationship.getType());
            rellist.remove(relationship);
            if (!rellist.isEmpty()) continue;
            relationships.remove(relationship.getType());
        }
    }

    public boolean evaluate() {
        return !this.relationshipTypeRestClient.list().isEmpty();
    }

    public class Specification
    extends Panel {
        private static final long serialVersionUID = 6199050589175839467L;
        private final RelationshipTO rel;
        private AnyObjectSearchPanel anyObjectSearchPanel;
        private WizardMgtPanel<AnyWrapper<AnyObjectTO>> anyObjectDirectoryPanel;

        public Specification() {
            super("specification");
            this.rel = new RelationshipTO();
            List availableRels = Relationships.this.relationshipTypeRestClient.list().stream().map(EntityTO::getKey).collect(Collectors.toList());
            final AjaxDropDownChoicePanel type = new AjaxDropDownChoicePanel("type", "type", new PropertyModel((Object)this.rel, "type"));
            type.setChoices(availableRels);
            this.add(new Component[]{type.setRenderBodyOnly(true)});
            final List availableTypes = Relationships.this.anyTypeRestClient.listAnyTypes().stream().filter(anyType -> anyType.getKind() != AnyTypeKind.GROUP && anyType.getKind() != AnyTypeKind.USER).collect(Collectors.toList());
            final AjaxDropDownChoicePanel otherType = new AjaxDropDownChoicePanel("otherType", "otherType", new PropertyModel<AnyTypeTO>((Object)this.rel, "otherType"){
                private static final long serialVersionUID = -5861057041758169508L;

                public AnyTypeTO getObject() {
                    for (AnyTypeTO obj : availableTypes) {
                        if (!obj.getKey().equals(Specification.this.rel.getOtherEndType())) continue;
                        return obj;
                    }
                    return null;
                }

                public void setObject(AnyTypeTO object) {
                    Specification.this.rel.setOtherEndType(object == null ? null : object.getKey());
                }
            }, false);
            otherType.setChoices(availableTypes);
            otherType.setChoiceRenderer(new IChoiceRenderer<AnyTypeTO>(){
                private static final long serialVersionUID = -734743540442190178L;

                public Object getDisplayValue(AnyTypeTO object) {
                    return object.getKey();
                }

                public String getIdValue(AnyTypeTO object, int index) {
                    return object.getKey();
                }

                public AnyTypeTO getObject(String id, IModel<? extends List<? extends AnyTypeTO>> choices) {
                    return ((List)choices.getObject()).stream().filter(anyTypeTO -> id.equals(anyTypeTO.getKey())).findAny().orElse(null);
                }
            });
            otherType.setEnabled(false);
            this.add(new Component[]{otherType});
            final WebMarkupContainer container = new WebMarkupContainer("searchPanelContainer");
            container.setOutputMarkupId(true);
            this.add(new Component[]{container});
            Fragment emptyFragment = new Fragment("searchPanel", "emptyFragment", (MarkupContainer)this);
            container.add(new Component[]{emptyFragment.setRenderBodyOnly(true)});
            type.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    Fragment emptyFragment = new Fragment("searchPanel", "emptyFragment", (MarkupContainer)Specification.this);
                    container.addOrReplace(new Component[]{emptyFragment.setRenderBodyOnly(true)});
                    otherType.setModelObject(null);
                    otherType.setEnabled(type.getModelObject() != null && !((String)type.getModelObject()).isEmpty());
                    target.add(new Component[]{otherType});
                    target.add(new Component[]{container});
                }
            }});
            otherType.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    AnyTypeTO anyType = (AnyTypeTO)otherType.getModelObject();
                    if (anyType == null) {
                        Fragment emptyFragment = new Fragment("searchPanel", "emptyFragment", (MarkupContainer)Specification.this);
                        container.addOrReplace(new Component[]{emptyFragment.setRenderBodyOnly(true)});
                    } else {
                        Fragment fragment = new Fragment("searchPanel", "searchFragment", (MarkupContainer)Specification.this);
                        container.addOrReplace(new Component[]{fragment.setRenderBodyOnly(true)});
                        Specification.this.anyObjectSearchPanel = (AnyObjectSearchPanel)((Object)new AnyObjectSearchPanel.Builder(anyType.getKey(), (IModel<List<SearchClause>>)new ListModel(new ArrayList())).enableSearch((IEventSink)Specification.this).build("searchPanel"));
                        fragment.add(new Component[]{Specification.this.anyObjectSearchPanel.setRenderBodyOnly(true)});
                        Specification.this.anyObjectDirectoryPanel = new AnyObjectSelectionDirectoryPanel.Builder(Relationships.this.anyTypeClassRestClient.list(anyType.getClasses()), anyType.getKey(), Relationships.this.pageRef).setFiql(SyncopeClient.getAnyObjectSearchConditionBuilder((String)anyType.getKey()).is("key").notNullValue().query()).setWizardInModal(true).build("searchResultPanel");
                        fragment.add(new Component[]{Specification.this.anyObjectDirectoryPanel.setRenderBodyOnly(true)});
                    }
                    target.add(new Component[]{container});
                }
            }});
        }

        public void onEvent(IEvent<?> event) {
            if (event.getPayload() instanceof SearchClausePanel.SearchEvent) {
                AjaxRequestTarget target = ((SearchClausePanel.SearchEvent)SearchClausePanel.SearchEvent.class.cast(event.getPayload())).getTarget();
                String fiql = SearchUtils.buildFIQL((List)this.anyObjectSearchPanel.getModel().getObject(), (AbstractFiqlSearchConditionBuilder)SyncopeClient.getAnyObjectSearchConditionBuilder((String)this.anyObjectSearchPanel.getBackObjectType()));
                ((AnyDirectoryPanel)((Object)AnyDirectoryPanel.class.cast(this.anyObjectDirectoryPanel))).search(fiql, target);
            } else if (event.getPayload() instanceof AnySelectionDirectoryPanel.ItemSelection) {
                AjaxRequestTarget target = ((AnySelectionDirectoryPanel.ItemSelection)AnySelectionDirectoryPanel.ItemSelection.class.cast(event.getPayload())).getTarget();
                Object right = ((AnySelectionDirectoryPanel.ItemSelection)AnySelectionDirectoryPanel.ItemSelection.class.cast(event.getPayload())).getSelection();
                this.rel.setOtherEndKey(right.getKey());
                Relationships.this.addNewRelationships(new RelationshipTO[]{this.rel});
                Relationships.this.addOrReplace(new Component[]{Relationships.this.getViewFragment().setRenderBodyOnly(true)});
                target.add(new Component[]{Relationships.this});
            } else {
                super.onEvent(event);
            }
        }
    }
}

