/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesomeIconTypeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.Remediations;
import org.apache.syncope.client.console.rest.RemediationRestClient;
import org.apache.syncope.client.console.wicket.ajax.IndicatorAjaxTimerBehavior;
import org.apache.syncope.client.console.widgets.AlertWidget;
import org.apache.syncope.common.lib.to.RemediationTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.util.time.Duration;

public class RemediationsWidget
extends AlertWidget<RemediationTO> {
    private static final long serialVersionUID = 1817429725840355068L;
    private final RemediationRestClient restClient = new RemediationRestClient();
    private final List<RemediationTO> lastRemediations = new ArrayList<RemediationTO>();

    public RemediationsWidget(String id, PageReference pageRef) {
        super(id);
        this.setOutputMarkupId(true);
        this.latestAlertsList.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.seconds((int)30)){
            private static final long serialVersionUID = 7298597675929755960L;

            protected void onTimer(AjaxRequestTarget target) {
                if (!((List)RemediationsWidget.this.latestAlerts.getObject()).equals(RemediationsWidget.this.lastRemediations)) {
                    RemediationsWidget.this.refreshLatestAlerts(target);
                }
            }
        }});
    }

    public final void refreshLatestAlerts(AjaxRequestTarget target) {
        ((List)this.latestAlerts.getObject()).clear();
        ((List)this.latestAlerts.getObject()).addAll(this.lastRemediations);
        int latestAlertSize = this.getLatestAlertsSize();
        this.linkAlertsNumber.setDefaultModelObject((Object)latestAlertSize);
        target.add(new Component[]{this.linkAlertsNumber});
        this.headerAlertsNumber.setDefaultModelObject((Object)latestAlertSize);
        target.add(new Component[]{this.headerAlertsNumber});
        target.add(new Component[]{this.latestAlertsList});
        this.lastRemediations.clear();
        this.lastRemediations.addAll((Collection)this.latestAlerts.getObject());
    }

    @Override
    protected int getLatestAlertsSize() {
        return SyncopeConsoleSession.get().owns("REMEDIATION_LIST") && SyncopeConsoleSession.get().owns("REMEDIATION_READ") ? this.restClient.countRemediations() : 0;
    }

    @Override
    protected IModel<List<RemediationTO>> getLatestAlerts() {
        return new ListModel<RemediationTO>(){
            private static final long serialVersionUID = 541491929575585613L;

            public List<RemediationTO> getObject() {
                List<RemediationTO> updatedRemediations = SyncopeConsoleSession.get().owns("REMEDIATION_LIST") && SyncopeConsoleSession.get().owns("REMEDIATION_READ") ? RemediationsWidget.this.restClient.getRemediations(1, 5, (SortParam<String>)new SortParam((Object)"instant", true)) : Collections.emptyList();
                return updatedRemediations;
            }
        };
    }

    @Override
    protected AbstractLink getEventsLink(String linkid) {
        BookmarkablePageLink<Remediations> remediations = BookmarkablePageLinkBuilder.build(linkid, Remediations.class);
        MetaDataRoleAuthorizationStrategy.authorize(remediations, (Action)WebPage.ENABLE, (String)"REMEDIATION_LIST");
        return remediations;
    }

    @Override
    protected Icon getIcon(String iconid) {
        return new Icon(iconid, (IconType)FontAwesomeIconTypeBuilder.on((FontAwesomeIconTypeBuilder.FontAwesomeGraphic)FontAwesomeIconTypeBuilder.FontAwesomeGraphic.medkit).build());
    }
}

