/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.layout.AnyObjectFormLayoutInfo;
import org.apache.syncope.client.console.layout.GroupFormLayoutInfo;
import org.apache.syncope.client.console.layout.UserFormLayoutInfo;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.TogglePanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.any.AnyObjectTemplateWizardBuilder;
import org.apache.syncope.client.console.wizards.any.AnyWizardBuilder;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.console.wizards.any.GroupTemplateWizardBuilder;
import org.apache.syncope.client.console.wizards.any.UserTemplateWizardBuilder;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.TemplatableTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public abstract class TemplatesTogglePanel
extends TogglePanel<Serializable> {
    private static final long serialVersionUID = -3195479265440591519L;
    private TemplatableTO targetObject;
    protected final Form<?> form;
    protected final Model<String> typeModel = new Model();
    private final LoadableDetachableModel<List<String>> anyTypes = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return new AnyTypeRestClient().list();
        }
    };

    public TemplatesTogglePanel(final String targetId, final MarkupContainer container, final PageReference pageRef) {
        super("toggleTemplates", pageRef);
        this.form = new Form("templatesForm");
        this.addInnerObject(new Component[]{this.form});
        AbstractFieldPanel type = new AjaxDropDownChoicePanel<String>("type", "type", (IModel<String>)this.typeModel, false).setChoices((IModel<List<String>>)this.anyTypes).setStyleSheet("form-control").setRequired(true);
        type.hideLabel();
        this.form.add(new Component[]{type});
        this.form.add(new Component[]{new AjaxSubmitLink("changeit", this.form){
            private static final long serialVersionUID = -7978723352517770644L;

            protected void onSubmit(AjaxRequestTarget target) {
                try {
                    AnyWizardBuilder builder;
                    AjaxWizard.NewItemActionEvent<Object> payload = new AjaxWizard.NewItemActionEvent<Object>(null, target);
                    payload.setResourceModel((IModel<String>)new StringResourceModel("inner.template.edit", (Component)container, (IModel)Model.of((Serializable)Pair.of((Object)TemplatesTogglePanel.this.typeModel.getObject(), (Object)TemplatesTogglePanel.this.targetObject))).setDefaultValue("Edit template"));
                    List classes = new AnyTypeRestClient().read((String)((Object)TemplatesTogglePanel.this.typeModel.getObject())).getClasses();
                    switch ((String)((Object)TemplatesTogglePanel.this.typeModel.getObject())) {
                        case "USER": {
                            builder = new UserTemplateWizardBuilder(TemplatesTogglePanel.this.targetObject, classes, new UserFormLayoutInfo(), pageRef){
                                private static final long serialVersionUID = -7978723352517770634L;

                                @Override
                                protected Serializable onApplyInternal(AnyWrapper<UserTO> modelObject) {
                                    return TemplatesTogglePanel.this.onApplyInternal(TemplatesTogglePanel.this.targetObject, (String)((Object)TemplatesTogglePanel.this.typeModel.getObject()), (AnyTO)modelObject.getInnerObject());
                                }
                            };
                            break;
                        }
                        case "GROUP": {
                            builder = new GroupTemplateWizardBuilder(TemplatesTogglePanel.this.targetObject, classes, new GroupFormLayoutInfo(), pageRef){
                                private static final long serialVersionUID = -7978723352517770634L;

                                @Override
                                protected Serializable onApplyInternal(AnyWrapper<GroupTO> modelObject) {
                                    return TemplatesTogglePanel.this.onApplyInternal(TemplatesTogglePanel.this.targetObject, (String)((Object)TemplatesTogglePanel.this.typeModel.getObject()), (AnyTO)modelObject.getInnerObject());
                                }
                            };
                            break;
                        }
                        default: {
                            builder = new AnyObjectTemplateWizardBuilder(TemplatesTogglePanel.this.targetObject, (String)((Object)TemplatesTogglePanel.this.typeModel.getObject()), classes, new AnyObjectFormLayoutInfo(), pageRef){
                                private static final long serialVersionUID = -7978723352517770634L;

                                @Override
                                protected Serializable onApplyInternal(AnyWrapper<AnyObjectTO> modelObject) {
                                    return TemplatesTogglePanel.this.onApplyInternal(TemplatesTogglePanel.this.targetObject, (String)((Object)TemplatesTogglePanel.this.typeModel.getObject()), (AnyTO)modelObject.getInnerObject());
                                }
                            };
                        }
                    }
                    ((AnyWizardBuilder)AnyWizardBuilder.class.cast(builder)).setEventSink((IEventSink)container);
                    payload.forceModalPanel(builder.build(targetId));
                    this.send((IEventSink)container, Broadcast.EXACT, payload);
                    TemplatesTogglePanel.this.toggle(target, false);
                }
                catch (SyncopeClientException e) {
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                    LOG.error("While editing template for {}", (Object)TemplatesTogglePanel.this.typeModel.getObject(), (Object)e);
                }
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }

            protected void onError(AjaxRequestTarget target) {
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }});
    }

    protected abstract Serializable onApplyInternal(TemplatableTO var1, String var2, AnyTO var3);

    public void setTargetObject(TemplatableTO targetObject) {
        this.targetObject = targetObject;
    }
}

