/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.status.AbstractStatusBeanProvider;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.commons.status.StatusUtils;
import org.apache.syncope.client.console.panels.AjaxDataTablePanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.console.rest.AnyObjectRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.status.ReconStatusPanel;
import org.apache.syncope.client.console.status.ReconTaskPanel;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.search.UserFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public class ResourceStatusDirectoryPanel
extends DirectoryPanel<StatusBean, StatusBean, DirectoryDataProvider<StatusBean>, AbstractAnyRestClient<?>>
implements ModalPanel {
    private static final long serialVersionUID = -9148734710505211261L;
    private final BaseModal<?> baseModal;
    private final MultilevelPanel multiLevelPanelRef;
    private String type;
    private final ResourceTO resource;

    public ResourceStatusDirectoryPanel(BaseModal<?> baseModal, MultilevelPanel multiLevelPanelRef, PageReference pageRef, String type, ResourceTO resource) {
        super("first", pageRef);
        this.baseModal = baseModal;
        this.multiLevelPanelRef = multiLevelPanelRef;
        this.type = type;
        this.resource = resource;
        this.itemKeyFieldName = "resource";
        this.initResultTable();
    }

    @Override
    protected void resultTableCustomChanges(AjaxDataTablePanel.Builder<StatusBean, String> resultTableBuilder) {
        resultTableBuilder.setMultiLevelPanel(this.baseModal, this.multiLevelPanelRef);
    }

    @Override
    protected List<IColumn<StatusBean, String>> getColumns() {
        ArrayList<IColumn<StatusBean, String>> columns = new ArrayList<IColumn<StatusBean, String>>();
        columns.add((IColumn<StatusBean, String>)new PropertyColumn((IModel)new StringResourceModel("name", (Component)this), (Object)"name", "name"));
        return columns;
    }

    private AnyTypeKind getAnyTypeKind() {
        if (StringUtils.isBlank((CharSequence)this.type)) {
            return null;
        }
        switch (this.type) {
            case "USER": {
                return AnyTypeKind.USER;
            }
            case "GROUP": {
                return AnyTypeKind.GROUP;
            }
        }
        return AnyTypeKind.ANY_OBJECT;
    }

    @Override
    public ActionsPanel<StatusBean> getActions(IModel<StatusBean> model) {
        ActionsPanel<StatusBean> panel = super.getActions(model);
        panel.add(new ActionLink<StatusBean>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            protected boolean statusCondition(StatusBean bean) {
                return ResourceStatusDirectoryPanel.this.getAnyTypeKind() != null;
            }

            @Override
            public void onClick(AjaxRequestTarget target, StatusBean bean) {
                ResourceStatusDirectoryPanel.this.multiLevelPanelRef.next(bean.getResource(), new ReconStatusPanel(bean.getResource(), ResourceStatusDirectoryPanel.this.getAnyTypeKind(), bean.getKey()), target);
                target.add(new Component[]{ResourceStatusDirectoryPanel.this.multiLevelPanelRef});
                ResourceStatusDirectoryPanel.this.getTogglePanel().close(target);
            }
        }, ActionLink.ActionType.VIEW, "RESOURCE_GET_CONNOBJECT");
        panel.add(new ActionLink<StatusBean>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            protected boolean statusCondition(StatusBean bean) {
                return ResourceStatusDirectoryPanel.this.getAnyTypeKind() != null;
            }

            @Override
            public void onClick(AjaxRequestTarget target, StatusBean bean) {
                ResourceStatusDirectoryPanel.this.multiLevelPanelRef.next("PUSH " + bean.getResource(), new ReconTaskPanel(bean.getResource(), (ProvisioningTaskTO)new PushTaskTO(), ResourceStatusDirectoryPanel.this.getAnyTypeKind(), bean.getKey(), ResourceStatusDirectoryPanel.this.multiLevelPanelRef, ResourceStatusDirectoryPanel.this.pageRef), target);
                target.add(new Component[]{ResourceStatusDirectoryPanel.this.multiLevelPanelRef});
                ResourceStatusDirectoryPanel.this.getTogglePanel().close(target);
            }
        }, ActionLink.ActionType.RECONCILIATION_PUSH, "TASK_EXECUTE");
        panel.add(new ActionLink<StatusBean>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            protected boolean statusCondition(StatusBean bean) {
                return ResourceStatusDirectoryPanel.this.getAnyTypeKind() != null;
            }

            @Override
            public void onClick(AjaxRequestTarget target, StatusBean bean) {
                ResourceStatusDirectoryPanel.this.multiLevelPanelRef.next("PULL " + bean.getResource(), new ReconTaskPanel(bean.getResource(), (ProvisioningTaskTO)new PullTaskTO(), ResourceStatusDirectoryPanel.this.getAnyTypeKind(), bean.getKey(), ResourceStatusDirectoryPanel.this.multiLevelPanelRef, ResourceStatusDirectoryPanel.this.pageRef), target);
                target.add(new Component[]{ResourceStatusDirectoryPanel.this.multiLevelPanelRef});
                ResourceStatusDirectoryPanel.this.getTogglePanel().close(target);
            }
        }, ActionLink.ActionType.RECONCILIATION_PULL, "TASK_EXECUTE");
        return panel;
    }

    public void updateResultTable(String type, AjaxRequestTarget target) {
        this.type = type;
        if (StringUtils.isNotBlank((CharSequence)type)) {
            switch (type) {
                case "USER": {
                    this.restClient = new UserRestClient();
                    break;
                }
                case "GROUP": {
                    this.restClient = new GroupRestClient();
                    break;
                }
                default: {
                    this.restClient = new AnyObjectRestClient();
                }
            }
        }
        super.updateResultTable(target);
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        ArrayList<ActionLink.ActionType> batches = new ArrayList<ActionLink.ActionType>();
        batches.add(ActionLink.ActionType.UNLINK);
        batches.add(ActionLink.ActionType.LINK);
        batches.add(ActionLink.ActionType.DEPROVISION);
        batches.add(ActionLink.ActionType.PROVISION);
        batches.add(ActionLink.ActionType.ASSIGN);
        batches.add(ActionLink.ActionType.UNASSIGN);
        return batches;
    }

    @Override
    protected ResourceStatusDataProvider dataProvider() {
        return new ResourceStatusDataProvider();
    }

    @Override
    protected String paginatorRowsKey() {
        return "";
    }

    protected class ResourceStatusDataProvider
    extends AbstractStatusBeanProvider {
        private static final long serialVersionUID = 4586969457669796621L;
        private final String fiql;
        private final AbstractAnyRestClient<? extends AnyTO> restClient;

        public ResourceStatusDataProvider() {
            super(AnyTypeKind.USER.name().equals(ResourceStatusDirectoryPanel.this.type) ? "username" : "name");
            if (StringUtils.isEmpty((CharSequence)ResourceStatusDirectoryPanel.this.type)) {
                this.fiql = null;
                this.restClient = null;
            } else {
                UserFiqlSearchConditionBuilder bld;
                switch (ResourceStatusDirectoryPanel.this.type) {
                    case "USER": {
                        bld = SyncopeClient.getUserSearchConditionBuilder();
                        this.restClient = new UserRestClient();
                        break;
                    }
                    case "GROUP": {
                        bld = SyncopeClient.getGroupSearchConditionBuilder();
                        this.restClient = new GroupRestClient();
                        break;
                    }
                    default: {
                        bld = SyncopeClient.getAnyObjectSearchConditionBuilder((String)ResourceStatusDirectoryPanel.this.type);
                        this.restClient = new AnyObjectRestClient();
                    }
                }
                this.fiql = bld.isNotNull("key").query();
            }
        }

        @Override
        protected List<StatusBean> getStatusBeans(long first, long count) {
            ArrayList<StatusBean> statusBeans = new ArrayList<StatusBean>();
            if (this.fiql != null && this.restClient != null) {
                int page = (int)first / this.paginatorRows;
                List<? extends AnyTO> result = this.restClient.search("/", this.fiql, (page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort(), ResourceStatusDirectoryPanel.this.type);
                statusBeans.addAll(result.stream().map(any -> StatusUtils.getStatusBean(any, ResourceStatusDirectoryPanel.this.resource.getKey(), null, any instanceof GroupTO)).collect(Collectors.toList()));
            }
            return statusBeans;
        }

        @Override
        public long size() {
            return this.fiql == null ? 0L : (long)this.restClient.count("/", this.fiql, ResourceStatusDirectoryPanel.this.type);
        }
    }
}

