/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.policies;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiPanel;
import org.apache.syncope.common.lib.policy.AbstractCorrelationRuleConf;
import org.apache.syncope.common.lib.policy.DefaultPullCorrelationRuleConf;
import org.apache.syncope.common.lib.policy.DefaultPushCorrelationRuleConf;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.policy.ProvisioningPolicyTO;
import org.apache.syncope.common.lib.policy.PullPolicyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class ProvisioningPolicyModalPanel
extends AbstractModalPanel<ProvisioningPolicyTO> {
    private static final long serialVersionUID = 2988891313881271124L;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final PolicyRestClient restClient = new PolicyRestClient();
    private final ImplementationRestClient implRestClient = new ImplementationRestClient();
    private final SchemaRestClient schemaRestClient = new SchemaRestClient();
    private final LoadableDetachableModel<Map<String, ImplementationTO>> implementations;
    private final IModel<List<CorrelationRule>> model;

    public ProvisioningPolicyModalPanel(final ProvisioningPolicyTO policyTO, BaseModal<? extends ProvisioningPolicyTO> modal, PageReference pageRef) {
        super(modal, pageRef);
        modal.setFormModel((ProvisioningPolicyTO)policyTO);
        this.implementations = new LoadableDetachableModel<Map<String, ImplementationTO>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected Map<String, ImplementationTO> load() {
                return ProvisioningPolicyModalPanel.this.implRestClient.list(policyTO instanceof PullPolicyTO ? ImplementationType.PULL_CORRELATION_RULE : ImplementationType.PUSH_CORRELATION_RULE).stream().collect(Collectors.toMap(EntityTO::getKey, Function.identity()));
            }
        };
        this.model = new PropertyModel<List<CorrelationRule>>((Object)policyTO, "correlationRules"){
            private static final long serialVersionUID = -8168676563540297301L;
            private final List<CorrelationRule> rules;
            {
                super(x0, x1);
                this.rules = policyTO.getCorrelationRules().keySet().stream().map(anyType -> new CorrelationRule(policyTO instanceof PullPolicyTO ? DefaultPullCorrelationRuleConf.class : DefaultPushCorrelationRuleConf.class, (String)anyType, (ImplementationTO)((Map)ProvisioningPolicyModalPanel.this.implementations.getObject()).get(policyTO.getCorrelationRules().get(anyType)))).collect(Collectors.toList());
            }

            public List<CorrelationRule> getObject() {
                return this.rules;
            }

            public void setObject(List<CorrelationRule> object) {
                policyTO.getCorrelationRules().clear();
                this.rules.forEach(rule -> policyTO.getCorrelationRules().put(rule.getAnyType(), rule.getImpl().getKey()));
            }
        };
        this.add(new Component[]{new MultiPanel<CorrelationRule>("correlationRules", "correlationRules", this.model){
            private static final long serialVersionUID = -2481579077338205547L;

            @Override
            protected CorrelationRule newModelObject() {
                return new CorrelationRule(policyTO instanceof PullPolicyTO ? DefaultPullCorrelationRuleConf.class : DefaultPushCorrelationRuleConf.class);
            }

            protected CorrelationRulePanel getItemPanel(ListItem<CorrelationRule> item) {
                return new CorrelationRulePanel("panel", (IModel<CorrelationRule>)Model.of((Serializable)((Serializable)item.getModelObject())));
            }
        }});
    }

    @Override
    public void onSubmit(AjaxRequestTarget target) {
        try {
            ((ProvisioningPolicyTO)this.getItem()).getCorrelationRules().clear();
            ((List)this.model.getObject()).forEach(rule -> {
                ((ProvisioningPolicyTO)this.getItem()).getCorrelationRules().put(rule.getAnyType(), rule.getImplKey());
                if (rule.getImpl().getEngine() == ImplementationEngine.JAVA && rule.getDefaultRuleConf() != null) {
                    try {
                        this.implRestClient.update(rule.getImpl());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.restClient.updatePolicy(this.getItem() instanceof PullPolicyTO ? PolicyType.PULL : PolicyType.PUSH, (PolicyTO)this.getItem());
            SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (Exception e) {
            LOG.error("While creating/updating policy", (Throwable)e);
            SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
        }
        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }

    private class CorrelationRule
    implements Serializable {
        private static final long serialVersionUID = 4221521483948294336L;
        private final Class<? extends AbstractCorrelationRuleConf> ruleConfClass;
        private String anyType;
        private ImplementationTO impl;
        private AbstractCorrelationRuleConf defaultRuleConf;

        CorrelationRule(Class<? extends AbstractCorrelationRuleConf> ruleConfClass) {
            this.ruleConfClass = ruleConfClass;
            this.anyType = AnyTypeKind.USER.name();
        }

        CorrelationRule(Class<? extends AbstractCorrelationRuleConf> ruleConfClass, String anyType, ImplementationTO impl) {
            this.ruleConfClass = ruleConfClass;
            this.anyType = anyType;
            this.setImpl(impl);
        }

        public String getAnyType() {
            return this.anyType;
        }

        public void setAnyType(String anyType) {
            this.anyType = anyType;
        }

        public String getImplKey() {
            return this.impl == null ? null : this.impl.getKey();
        }

        public void setImplKey(String key) {
            this.setImpl((ImplementationTO)((Map)ProvisioningPolicyModalPanel.this.implementations.getObject()).get(key));
        }

        public final void setImpl(ImplementationTO impl) {
            this.impl = impl;
            if (impl != null) {
                this.defaultRuleConf = null;
                try {
                    this.defaultRuleConf = (AbstractCorrelationRuleConf)OBJECT_MAPPER.readValue(impl.getBody(), this.ruleConfClass);
                }
                catch (Exception e) {
                    LOG.debug("Could not deserialize {} as {}", (Object)impl.getBody(), (Object)this.ruleConfClass.getName());
                }
            }
        }

        public ImplementationTO getImpl() {
            if (this.defaultRuleConf != null) {
                try {
                    this.impl.setBody(OBJECT_MAPPER.writeValueAsString((Object)this.defaultRuleConf));
                }
                catch (Exception e) {
                    LOG.error("Could not serialize {}", (Object)this.defaultRuleConf);
                }
            }
            return this.impl;
        }

        public void setDefaultRuleConf(DefaultPushCorrelationRuleConf defaultRuleConf) {
            this.defaultRuleConf = defaultRuleConf;
        }

        public AbstractCorrelationRuleConf getDefaultRuleConf() {
            return this.defaultRuleConf;
        }
    }

    protected class CorrelationRulePanel
    extends Panel {
        private static final long serialVersionUID = -5380414818290018189L;

        CorrelationRulePanel(String id, final IModel<CorrelationRule> correlationRule) {
            super(id);
            AjaxDropDownChoicePanel<String> anyType = new AjaxDropDownChoicePanel("anyType", "anyType", new PropertyModel(correlationRule.getObject(), "anyType")).setNullValid(true).setChoices(new AnyTypeRestClient().list());
            anyType.setNullValid(false);
            anyType.setRequired(true);
            anyType.setOutputMarkupId(true);
            this.add(new Component[]{anyType});
            AjaxDropDownChoicePanel rule = new AjaxDropDownChoicePanel("rule", "rule", new PropertyModel(correlationRule.getObject(), "implKey")).setChoices(((Map)ProvisioningPolicyModalPanel.this.implementations.getObject()).keySet().stream().sorted().collect(Collectors.toList()));
            rule.setNullValid(false);
            rule.setRequired(true);
            rule.setOutputMarkupId(true);
            this.add(new Component[]{rule});
            PropertyModel<Boolean> orSchemasModel = new PropertyModel<Boolean>((Object)((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf(), "orSchemas"){
                private static final long serialVersionUID = 807008909842554829L;

                private boolean orSchemas() {
                    AbstractCorrelationRuleConf conf = ((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf();
                    return conf instanceof DefaultPullCorrelationRuleConf ? ((DefaultPullCorrelationRuleConf)DefaultPullCorrelationRuleConf.class.cast(conf)).isOrSchemas() : (conf instanceof DefaultPushCorrelationRuleConf ? ((DefaultPushCorrelationRuleConf)DefaultPushCorrelationRuleConf.class.cast(conf)).isOrSchemas() : false);
                }

                public Boolean getObject() {
                    AbstractCorrelationRuleConf conf = ((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf();
                    return conf instanceof DefaultPullCorrelationRuleConf ? ((DefaultPullCorrelationRuleConf)DefaultPullCorrelationRuleConf.class.cast(conf)).isOrSchemas() : (conf instanceof DefaultPushCorrelationRuleConf ? ((DefaultPushCorrelationRuleConf)DefaultPushCorrelationRuleConf.class.cast(conf)).isOrSchemas() : false);
                }

                public void setObject(Boolean object) {
                    AbstractCorrelationRuleConf conf = ((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf();
                    if (conf instanceof DefaultPullCorrelationRuleConf) {
                        ((DefaultPullCorrelationRuleConf)DefaultPullCorrelationRuleConf.class.cast(conf)).setOrSchemas(object.booleanValue());
                    } else if (conf instanceof DefaultPushCorrelationRuleConf) {
                        ((DefaultPushCorrelationRuleConf)DefaultPushCorrelationRuleConf.class.cast(conf)).setOrSchemas(object.booleanValue());
                    }
                }
            };
            final AjaxCheckBoxPanel orSchemas = new AjaxCheckBoxPanel("orSchemas", "orSchemas", (IModel<Boolean>)orSchemasModel, false);
            orSchemas.setOutputMarkupPlaceholderTag(true);
            this.add(new Component[]{orSchemas.setVisible(((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf() != null)});
            PropertyModel<List<String>> defaultRuleConfModel = new PropertyModel<List<String>>((Object)((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf(), "schemas"){
                private static final long serialVersionUID = 3799387950428254072L;

                private List<String> schemas() {
                    AbstractCorrelationRuleConf conf = ((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf();
                    return conf instanceof DefaultPullCorrelationRuleConf ? ((DefaultPullCorrelationRuleConf)DefaultPullCorrelationRuleConf.class.cast(conf)).getSchemas() : (conf instanceof DefaultPushCorrelationRuleConf ? ((DefaultPushCorrelationRuleConf)DefaultPushCorrelationRuleConf.class.cast(conf)).getSchemas() : Collections.emptyList());
                }

                public List<String> getObject() {
                    ArrayList<String> schemas = new ArrayList<String>();
                    if (((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf() != null) {
                        schemas.addAll(this.schemas());
                    }
                    return schemas;
                }

                public void setObject(List<String> object) {
                    if (((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf() != null) {
                        this.schemas().clear();
                        this.schemas().addAll(object);
                    }
                }
            };
            final AjaxPalettePanel<String> defaultRuleConf = new AjaxPalettePanel.Builder().setName("defaultRuleConf").build("defaultRuleConf", (IModel<List<String>>)defaultRuleConfModel, new AjaxPalettePanel.Builder.Query<String>(){
                private static final long serialVersionUID = -7223078772249308813L;

                @Override
                public List<String> execute(String filter) {
                    return CorrelationRulePanel.this.getSchemas((CorrelationRule)correlationRule.getObject());
                }
            });
            defaultRuleConf.hideLabel().setOutputMarkupPlaceholderTag(true);
            this.add(new Component[]{defaultRuleConf.setVisible(((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf() != null)});
            anyType.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    if (orSchemas.isVisibleInHierarchy()) {
                        target.add(new Component[]{orSchemas});
                    }
                    if (defaultRuleConf.isVisibleInHierarchy()) {
                        ((CorrelationRule)correlationRule.getObject()).setImpl(null);
                        defaultRuleConf.reload(target);
                        target.add(new Component[]{defaultRuleConf});
                    }
                }
            }});
            rule.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    if (((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf() == null) {
                        orSchemas.setVisible(false);
                        defaultRuleConf.setVisible(false);
                    } else {
                        orSchemas.setVisible(true);
                        defaultRuleConf.setVisible(true);
                    }
                    target.add(new Component[]{orSchemas});
                    target.add(new Component[]{defaultRuleConf});
                }
            }});
        }

        private List<String> getSchemas(CorrelationRule rule) {
            ArrayList<String> choices = StringUtils.isEmpty((CharSequence)rule.getAnyType()) ? new ArrayList<String>() : ProvisioningPolicyModalPanel.this.schemaRestClient.getSchemas(SchemaType.PLAIN, rule.getAnyType().equals(AnyTypeKind.USER.name()) ? AnyTypeKind.USER : (rule.getAnyType().equals(AnyTypeKind.GROUP.name()) ? AnyTypeKind.GROUP : AnyTypeKind.ANY_OBJECT)).stream().map(EntityTO::getKey).collect(Collectors.toList());
            choices.add("key");
            choices.add(rule.getAnyType().equals(AnyTypeKind.USER.name()) ? "username" : "name");
            Collections.sort(choices);
            return choices;
        }
    }
}

