/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.TogglePanel;
import org.apache.syncope.client.console.rest.ExecutionRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class StartAtTogglePanel
extends TogglePanel<Serializable> {
    private static final long serialVersionUID = -3195479265440591519L;
    protected String key;
    protected final Form<?> form;
    protected final Model<Date> startAtDateModel = new Model();

    public StartAtTogglePanel(final WebMarkupContainer container, final PageReference pageRef) {
        super("startAt", pageRef);
        this.form = new Form("startAtForm");
        this.addInnerObject(new Component[]{this.form});
        final AjaxDateTimeFieldPanel startAtDate = new AjaxDateTimeFieldPanel("startAtDate", "startAtDate", (IModel<Date>)this.startAtDateModel, SyncopeConstants.DATE_PATTERNS[3]);
        startAtDate.setReadOnly(true).hideLabel();
        this.form.add(new Component[]{startAtDate});
        final AjaxCheckBoxPanel startAtCheck = new AjaxCheckBoxPanel("startAtCheck", "startAtCheck", (IModel<Boolean>)new Model((Serializable)Boolean.valueOf(false)), false);
        this.form.add(new Component[]{startAtCheck});
        startAtCheck.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{startAtDate.setModelObject(null).setReadOnly((Boolean)startAtCheck.getModelObject() == false)});
            }
        }});
        this.form.add(new Component[]{new AjaxSubmitLink("startAt", this.form){
            private static final long serialVersionUID = -7978723352517770644L;

            protected void onSubmit(AjaxRequestTarget target) {
                try {
                    StartAtTogglePanel.this.getRestClient().startExecution(StartAtTogglePanel.this.key, (Date)StartAtTogglePanel.this.startAtDateModel.getObject());
                    SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
                    StartAtTogglePanel.this.toggle(target, false);
                    target.add(new Component[]{container});
                }
                catch (SyncopeClientException e) {
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                    TogglePanel.LOG.error("While running task {}", (Object)StartAtTogglePanel.this.key, (Object)e);
                }
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }

            protected void onError(AjaxRequestTarget target) {
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }});
    }

    public void setExecutionDetail(String key, String header, AjaxRequestTarget target) {
        this.key = key;
        this.setHeader(target, header);
    }

    protected abstract ExecutionRestClient getRestClient();
}

